/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.base.processors.util;

import cn.com.infosec.netsign.logger.ConsoleLogger;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class GZipUtil {
    public static byte[] zip(byte[] _bytes) throws IOException {
        BufferedOutputStream bufOut = null;
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        bufOut = new BufferedOutputStream(new GZIPOutputStream(byteOut));
        bufOut.write(_bytes);
        bufOut.close();
        return byteOut.toByteArray();
    }

    public static void zip2File(InputStream in, String file) throws IOException {
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(file);
            ByteArrayOutputStream inner = new ByteArrayOutputStream();
            GZIPOutputStream out = new GZIPOutputStream(inner);
            byte[] buf = new byte[0x100000];
            int ret = 0;
            while ((ret = in.read(buf)) > 0) {
                out.write(buf, 0, ret);
                fout.write(inner.toByteArray());
                fout.flush();
            }
            out.close();
            fout.write(inner.toByteArray());
            fout.flush();
            fout.close();
        }
        finally {
            try {
                if (fout != null) {
                    fout.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static byte[] unzip(byte[] _bytes) throws IOException {
        ByteArrayOutputStream byteOut = null;
        BufferedInputStream bufIn = null;
        try {
            bufIn = new BufferedInputStream(new GZIPInputStream(new ByteArrayInputStream(_bytes)));
            byteOut = new ByteArrayOutputStream(1024);
            byte[] byteBuf = new byte[1024];
            int len = 0;
            while ((len = bufIn.read(byteBuf, 0, byteBuf.length)) != -1) {
                byteOut.write(byteBuf, 0, len);
            }
            byte[] byArray = byteOut.toByteArray();
            return byArray;
        }
        finally {
            try {
                if (byteOut != null) {
                    byteOut.close();
                }
                if (bufIn != null) {
                    bufIn.close();
                }
            }
            catch (IOException e) {
                ConsoleLogger.logException((Throwable)e);
            }
        }
    }

    public static void main(String[] args) {
        try {
            byte[] zippedBytes = GZipUtil.zip("Test123".getBytes());
            byte[] unzippedBytes = GZipUtil.unzip(zippedBytes);
            zippedBytes = GZipUtil.zip(unzippedBytes);
            System.out.println(new String(GZipUtil.unzip(zippedBytes)));
        }
        catch (IOException e) {
            ConsoleLogger.logException((Throwable)e);
        }
    }
}

