/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.base.processors;

import cn.com.infosec.isfw2.sfw.Request;
import cn.com.infosec.isfw2.sfw.Response;
import cn.com.infosec.netsign.base.AbstractMessage;
import cn.com.infosec.netsign.base.ErrorInfoRes;
import cn.com.infosec.netsign.base.NSMessage;
import cn.com.infosec.netsign.base.NSMessageOpt;
import cn.com.infosec.netsign.base.channels.ServerChannel;
import cn.com.infosec.netsign.base.processors.util.ProcessUtil;
import cn.com.infosec.netsign.base.util.NetSignImpl;
import cn.com.infosec.netsign.base.util.VerifySignatureException;
import cn.com.infosec.netsign.crypto.algorithm.DigestAlgorithm;
import cn.com.infosec.netsign.crypto.util.AlgorithmUtil;
import cn.com.infosec.netsign.crypto.util.SoftCryptoImpl;
import cn.com.infosec.netsign.frame.config.ExtendedConfig;
import cn.com.infosec.netsign.isfwimpl.NetSignProcessor;
import cn.com.infosec.netsign.isfwimpl.NetSignRequest;
import cn.com.infosec.netsign.isfwimpl.NetSignResponse;
import cn.com.infosec.netsign.resources.rawcert.PBCRAWCert;
import cn.com.infosec.netsign.resources.rawcert.PBCRAWCertResourceList;
import cn.com.infosec.netsign.synfwimpl.handle.PBCRAWCertSynManager;
import cn.com.infosec.netsign.synfwimpl.handle.PBCRAWCertSynManagerFactory;
import cn.com.infosec.netsign.synfwimpl.jmx.CertTask;
import cn.com.infosec.synfw.config.SynConfig;
import cn.com.infosec.synfw.jmx.Task;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;

public class VerifyRawSignedValueProcessor
implements NetSignProcessor {
    private ServerChannel channel;
    private PBCRAWCertResourceList certlist;

    public void setChannel(ServerChannel channel) {
        if (this.channel != channel) {
            this.channel = channel;
        }
    }

    public Response process(Request req) {
        NetSignRequest nsreq = (NetSignRequest)req;
        NSMessage request = nsreq.getNSMessage();
        String failedMsg = String.valueOf(this.channel.getId()) + " " + request.getAddress() + " VerifyRawSignedValue failed:";
        NSMessageOpt res = ProcessUtil.createNSMessageOpt(request);
        String certDN = request.getSignCertDN();
        byte[] cryptoText = request.getCryptoText();
        byte[] plainText = request.getPlainText();
        plainText = ProcessUtil.disassemble(plainText, this.channel.isCryptoCommunicate(), this.channel.getCryptoUtil(), request, res);
        if (res.getResult() < 0) {
            ProcessUtil.log(this.channel.getDebugLogger(), this.channel.getId(), request, res);
            ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(failedMsg) + res.getResult(), this.channel.getLogLevel(), nsreq, res);
            return NetSignResponse.createNetSignResponse(res, nsreq);
        }
        this.certlist = (PBCRAWCertResourceList)ProcessUtil.getResourceList(this.channel, request.getResourceName());
        if (this.certlist == null) {
            res.setResult(-100280);
            res.setErrMsg("No certificate list found by " + request.getResourceName());
            ProcessUtil.log(this.channel.getDebugLogger(), this.channel.getId(), request, res);
            ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(this.channel.getId()) + " " + request.getAddress() + " " + failedMsg + ":" + res.getResult(), this.channel.getLogLevel(), nsreq, res);
            return NetSignResponse.createNetSignResponse(res, nsreq);
        }
        PBCRAWCert cert = null;
        if (certDN != null) {
            cert = ProcessUtil.getPBCRAWCert(certDN, this.certlist);
        }
        if (cert == null || cert.getCert() == null) {
            if (SynConfig.isRID_on() && SynConfig.getHostslist().size() > 0) {
                PBCRAWCertSynManager synmanager;
                if (SynConfig.isRID_beforeverify()) {
                    synmanager = PBCRAWCertSynManagerFactory.getSynManager();
                    PBCRAWCert x509 = synmanager.realTimeDownloadCert(certDN, this.certlist.getName());
                    if (x509 != null && x509.getCert() != null) {
                        cert = x509;
                    }
                } else {
                    synmanager = PBCRAWCertSynManagerFactory.getSynManager();
                    CertTask t = CertTask.getInstance(null, (String)this.certlist.getName(), (String)certDN, (String)"syndownloadresource", (boolean)SynConfig.isCenter_host(), null);
                    synmanager.realTimeDownLoad((Task)t);
                }
            }
            if (cert == null || cert.getCertDN() == null) {
                this.setNoCertError(res, certDN);
                ProcessUtil.log(this.channel.getDebugLogger(), this.channel.getId(), request, res);
                ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(failedMsg) + res.getResult(), this.channel.getLogLevel(), nsreq, res);
                return NetSignResponse.createNetSignResponse(res, nsreq);
            }
        }
        if (cert.isInBlackList()) {
            res.setResult(-100226);
            res.setErrMsg("The bank who have this certificate is in blacklist");
            ProcessUtil.log(this.channel.getDebugLogger(), this.channel.getId(), request, res);
            ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(this.channel.getId()) + " " + request.getAddress() + " " + failedMsg + ":" + res.getResult(), this.channel.getLogLevel(), nsreq, res);
            return NetSignResponse.createNetSignResponse(res, nsreq);
        }
        String digestAlg = ProcessUtil.getDigestAlgoritim(request, this.channel, cert.getPublicKey());
        NetSignImpl impl = new NetSignImpl();
        try {
            DigestAlgorithm digestam = AlgorithmUtil.getDigestAlgByName((String)digestAlg);
            if (digestam == null) {
                throw new NoSuchAlgorithmException("The DigestAlgorithm " + digestAlg + " Can not been Supported");
            }
            boolean flag = SoftCryptoImpl.verify((PublicKey)cert.getPublicKey(), (byte[])plainText, (byte[])cryptoText, (String)digestAlg, (String)ExtendedConfig.getVerifyProvider());
            if (!flag) {
                throw new VerifySignatureException(" signature was not verified");
            }
        }
        catch (Exception ex) {
            ProcessUtil.throwDetailException(ex, res);
            ProcessUtil.log(this.channel.getDebugLogger(), this.channel.getId(), request, res);
            ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(failedMsg) + res.getResult(), this.channel.getLogLevel(), nsreq, res);
            return NetSignResponse.createNetSignResponse(res, nsreq);
        }
        if (res.getResult() < 0) {
            ProcessUtil.log(this.channel.getDebugLogger(), this.channel.getId(), request, res);
            ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(failedMsg) + res.getResult(), this.channel.getLogLevel(), nsreq, res);
        } else {
            ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(this.channel.getId()) + " " + request.getAddress() + " VerifyRawSignedValue success", this.channel.getLogLevel(), nsreq, res);
        }
        res.setSignEndTime(String.valueOf(Long.parseLong(cert.getNotAfter()) / 1000L));
        res.setSignIssuerSubject(cert.getIssuerDN());
        res.setSignSerNumber(cert.getSerialNumber());
        res.setSignStartTime(String.valueOf(Long.parseLong(cert.getNotBefore()) / 1000L));
        res.setSignCertDN(cert.getCertDN());
        return NetSignResponse.createNetSignResponse(res, nsreq);
    }

    private void setNoCertError(AbstractMessage res, String dn) {
        res.setResult(-100224);
        res.setErrMsg(String.valueOf(ErrorInfoRes.getErrorInfo(-100224)) + ": " + dn);
    }
}

