/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.base.processors;

import cn.com.infosec.netsign.base.AbstractMessage;
import cn.com.infosec.netsign.base.AdminMessage;
import cn.com.infosec.netsign.base.ErrorInfoRes;
import cn.com.infosec.netsign.base.Processor;
import cn.com.infosec.netsign.base.processors.ProcessorException;
import cn.com.infosec.netsign.base.processors.util.ProcessUtil;
import cn.com.infosec.netsign.logger.ConsoleLogger;
import cn.com.infosec.netsign.manager.CryptoManager;
import cn.com.infosec.netsign.manager.DCServerManager;
import cn.com.infosec.netsign.manager.LogManager;

public class ShutdownSystemProcessor
implements Processor {
    private int id = 1;

    public AbstractMessage process(AbstractMessage request) throws ProcessorException {
        AdminMessage res = ProcessUtil.createAdminMessage(request);
        try {
            CryptoManager.descroy();
        }
        catch (Throwable cryEx) {
            ConsoleLogger.logException((Throwable)cryEx);
            res.setResult(-100033);
            res.setErrMsg(String.valueOf(ErrorInfoRes.getErrorInfo(-100033)) + ": " + cryEx.getMessage());
            LogManager.getDebugLogger().Log(String.valueOf(this.id) + " " + res.getProcessor() + ": " + res.getResult() + ", " + res.getErrMsg());
            LogManager.getAccessLogger().Log(String.valueOf(this.id) + " ShutdownSystem failed");
        }
        try {
            DCServerManager.unregisterServers();
        }
        catch (Throwable crlEx) {
            ConsoleLogger.logException((Throwable)crlEx);
            res.setResult(-100033);
            res.setErrMsg(String.valueOf(ErrorInfoRes.getErrorInfo(-100033)) + ": " + crlEx.getMessage());
            LogManager.getDebugLogger().Log(String.valueOf(this.id) + " " + res.getProcessor() + ": " + res.getResult() + ", " + res.getErrMsg());
            LogManager.getAccessLogger().Log(String.valueOf(this.id) + " ShutdownSystem failed");
        }
        System.exit(0);
        return res;
    }
}

