/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.base.processors;

import cn.com.infosec.netsign.base.AbstractMessage;
import cn.com.infosec.netsign.base.AdminMessage;
import cn.com.infosec.netsign.base.Processor;
import cn.com.infosec.netsign.base.processors.ProcessorException;
import cn.com.infosec.netsign.base.processors.util.MessageConvertor;
import cn.com.infosec.netsign.base.processors.util.ProcessUtil;
import cn.com.infosec.netsign.synfwimpl.CertSYNParameters;
import cn.com.infosec.netsign.synfwimpl.CertSYNResult;
import cn.com.infosec.netsign.synfwimpl.config.HostOfRAWCert;
import cn.com.infosec.netsign.synfwimpl.handle.PBCRAWCertSynEmissary;
import cn.com.infosec.netsign.synfwimpl.handle.PBCRAWCertSynManagerFactory;
import cn.com.infosec.synfw.auth.MessageAuth;
import cn.com.infosec.synfw.auth.MessageAuthFactory;
import cn.com.infosec.synfw.config.SynConfig;
import cn.com.infosec.synfw.logger.SynLogger;
import java.util.HashMap;

public class SYNShakeHandsProcessor
implements Processor {
    public AbstractMessage process(AbstractMessage request) throws ProcessorException {
        AdminMessage res = ProcessUtil.createAdminMessage(request);
        AdminMessage req = MessageConvertor.convertAdminMessage(request, res);
        String uuid = null;
        boolean isProduce = true;
        PBCRAWCertSynEmissary emrep = null;
        CertSYNParameters synpara = null;
        HashMap map = (HashMap)req.getContent();
        byte[] rawPara = (byte[])map.get("rawSynPara");
        boolean needauth = (Boolean)map.get("needauth");
        int authtype = -1;
        try {
            synpara = CertSYNParameters.ByteArrays2Object((byte[])rawPara);
        }
        catch (Exception e1) {
            SynLogger.log((String)"( SYNShakeHandsProcessor )Tranform CertSYNParameters 2 byteArrays failed. Caused by: ");
            SynLogger.log((Throwable)e1);
        }
        HostOfRAWCert desthost = null;
        boolean needauthSelf = false;
        String authcode = null;
        if (needauth) {
            byte[] authcodedigest = (byte[])map.get("authcode");
            desthost = ProcessUtil.findAuthCodeforVerify(authcodedigest);
            if (desthost != null) {
                needauthSelf = desthost.isNeedauth();
                authcode = desthost.getAuthCode();
            }
            authtype = (Integer)map.get("authtype");
            if (authcode == null) {
                SynLogger.log((String)"SYNShakeHands failed, Caused by: Can't find corresponding authcode with req.");
                res.setResult(-100180);
                res.setErrMsg("SYNParameters can't verifed.");
                return res;
            }
        }
        if (needauthSelf && authcode != null) {
            if (needauth) {
                byte[] encrySynPara = (byte[])map.get("encrySynPara");
                MessageAuth auther = MessageAuthFactory.getInstance((int)authtype);
                boolean isverifyok = auther.verifyAuthMessage(rawPara, authcode, encrySynPara);
                if (!isverifyok) {
                    SynLogger.log((String)"SYNShakeHands failed, Caused by: Syn parameters can't verified.");
                    res.setResult(-100180);
                    res.setErrMsg("SYNParameters can't verifed.");
                    return res;
                }
            } else {
                SynLogger.log((String)"SYNShakeHands failed, Caused by: Syn parameters need to verify, there are not auth-message. Can't to verify.");
                res.setResult(-100180);
                res.setErrMsg("SYNParameters can't verifed.");
                return res;
            }
        }
        uuid = synpara.getUuid();
        isProduce = synpara.isIsproduce();
        if (uuid == null || uuid.equals("")) {
            res.setResult(-100052);
            res.setErrMsg("No uuid included when SYN shake hands.");
        } else if (!SynConfig.isProduce_sys() && isProduce) {
            emrep = new PBCRAWCertSynEmissary(true);
            SynLogger.log((String)"I am not produce_system, refuse to accept passive incresyn with produce system.");
        } else if (!PBCRAWCertSynManagerFactory.getSynManager().getSyncontroller().getEmissary().getJustwake() || System.currentTimeMillis() - PBCRAWCertSynManagerFactory.getSynManager().getSyncontroller().getEmissary().getSynstarttime() > (long)(SynConfig.getSyntimeout() * 1000)) {
            PBCRAWCertSynManagerFactory.getSynManager().getSyncontroller().getEmissary().setJustwake(false);
            PBCRAWCertSynManagerFactory.getSynManager().getSyncontroller().getEmissary().setUuid_syning(uuid);
            long startTime = System.currentTimeMillis();
            PBCRAWCertSynManagerFactory.getSynManager().getSyncontroller().getEmissary().setSynstarttime(startTime);
            emrep = new PBCRAWCertSynEmissary();
            SynLogger.log((String)"SYNShakeHandsProcessor sucessed.");
            SynLogger.log((String)("Can to be syning with [ " + uuid + " ] at [ " + startTime + " ]ms."));
        } else {
            emrep = new PBCRAWCertSynEmissary(true);
            SynLogger.log((String)"I am syning now and not over time.");
        }
        CertSYNResult result = new CertSYNResult();
        if (emrep != null) {
            result.setResEmissary(emrep);
        }
        res = ProcessUtil.fillContent2Res(res, result, needauth, authtype);
        return res;
    }
}

