/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.base.processors;

import cn.com.infosec.netsign.base.AbstractMessage;
import cn.com.infosec.netsign.base.AdminMessage;
import cn.com.infosec.netsign.base.Processor;
import cn.com.infosec.netsign.base.processors.ProcessorException;
import cn.com.infosec.netsign.base.processors.util.MessageConvertor;
import cn.com.infosec.netsign.base.processors.util.ProcessUtil;
import cn.com.infosec.netsign.resources.ResourceListFilter;
import cn.com.infosec.netsign.resources.ResourceManager;
import cn.com.infosec.netsign.resources.rawcert.PBCRAWCert;
import cn.com.infosec.netsign.resources.rawcert.PBCRAWCertProxy;
import cn.com.infosec.netsign.resources.rawcert.PBCRAWCertProxyFactory;
import cn.com.infosec.netsign.resources.rawcert.PBCRAWCertResourceList;
import cn.com.infosec.netsign.synfwimpl.CertSYNParameters;
import cn.com.infosec.netsign.synfwimpl.CertSYNResult;
import cn.com.infosec.netsign.synfwimpl.config.HostOfRAWCert;
import cn.com.infosec.synfw.auth.MessageAuth;
import cn.com.infosec.synfw.auth.MessageAuthFactory;
import cn.com.infosec.synfw.logger.SynLogger;
import java.security.cert.CertificateEncodingException;
import java.util.ArrayList;
import java.util.HashMap;

public class SYNDownloadCertProcessor
implements Processor {
    public AbstractMessage process(AbstractMessage request) throws ProcessorException {
        AdminMessage res = ProcessUtil.createAdminMessage(request);
        AdminMessage req = MessageConvertor.convertAdminMessage(request, res);
        String certDN = null;
        String listName = null;
        CertSYNParameters synpara = null;
        HashMap map = (HashMap)req.getContent();
        byte[] rawPara = (byte[])map.get("rawSynPara");
        boolean needauth = (Boolean)map.get("needauth");
        int authtype = -1;
        try {
            synpara = CertSYNParameters.ByteArrays2Object((byte[])rawPara);
        }
        catch (Exception e1) {
            SynLogger.log((String)"( SYNDownloadCertProcessor )Tranform CertSYNParameters 2 byteArrays failed. Caused by: ");
            SynLogger.log((Throwable)e1);
        }
        HostOfRAWCert desthost = null;
        boolean needauthSelf = false;
        String authcode = null;
        if (needauth) {
            byte[] authcodedigest = (byte[])map.get("authcode");
            desthost = ProcessUtil.findAuthCodeforVerify(authcodedigest);
            if (desthost != null) {
                needauthSelf = desthost.isNeedauth();
                authcode = desthost.getAuthCode();
            }
            authtype = (Integer)map.get("authtype");
            if (authcode == null) {
                SynLogger.log((String)"SYNDownloadCert failed, Caused by: Can't find corresponding authcode with req.");
                res.setResult(-100180);
                res.setErrMsg("SYNParameters can't verifed.");
                return res;
            }
        }
        if (needauthSelf && authcode != null) {
            if (needauth) {
                byte[] encrySynPara = (byte[])map.get("encrySynPara");
                MessageAuth auther = MessageAuthFactory.getInstance((int)authtype);
                boolean isverifyok = auther.verifyAuthMessage(rawPara, authcode, encrySynPara);
                if (!isverifyok) {
                    SynLogger.log((String)"SYNDownloadCert failed, Caused by: Syn parameters can't verified.");
                    res.setResult(-100180);
                    res.setErrMsg("SYNParameters can't verifed.");
                    return res;
                }
            } else {
                SynLogger.log((String)"SYNDownloadCert failed, Caused by: Syn parameters need to verify, there are not auth-message. Can't to verify.");
                res.setResult(-100180);
                res.setErrMsg("SYNParameters can't verifed.");
                return res;
            }
        }
        listName = synpara.getListname();
        certDN = synpara.getCertDN();
        if (certDN == null || certDN.equals("")) {
            res.setResult(-100225);
            res.setErrMsg("No certDN received when SYN download.");
            return res;
        }
        PBCRAWCertProxy query = PBCRAWCertProxyFactory.getFindResourceListByName((String)listName);
        PBCRAWCertResourceList certList = (PBCRAWCertResourceList)ResourceManager.getAllResourceList().getResourceList((ResourceListFilter)query);
        PBCRAWCert rawCert = ProcessUtil.getPBCRAWCert(certDN, certList);
        if (rawCert == null || rawCert.getCert() == null) {
            res.setResult(-100224);
            res.setErrMsg("SYNDownloadCert cannot find raw cert by dn:[" + certDN + "]. ");
            SynLogger.log((String)"Can not find raw cert by DN.");
            certList.log("Can not find raw cert by DN.");
            return res;
        }
        ArrayList updatetimes = (ArrayList)rawCert.getModifyTimes();
        String lastUpdate = updatetimes == null || updatetimes.size() == 0 ? "" : (String)updatetimes.get(updatetimes.size() - 1);
        CertSYNResult result = new CertSYNResult();
        result.setUpdatetime(lastUpdate);
        try {
            result.setCert(rawCert.getCert().getEncoded());
        }
        catch (CertificateEncodingException e) {
            SynLogger.log((String)("SYN DownloadCertificate " + certDN + " failed. Caused by: "));
            SynLogger.log((Throwable)e);
        }
        res = ProcessUtil.fillContent2Res(res, result, needauth, authtype);
        SynLogger.log((String)("SYN DownloadCertificate " + certDN + " finished."));
        return res;
    }
}

