/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.base.processors;

import cn.com.infosec.netsign.base.AbstractMessage;
import cn.com.infosec.netsign.base.AdminMessage;
import cn.com.infosec.netsign.base.Processor;
import cn.com.infosec.netsign.base.processors.ProcessorException;
import cn.com.infosec.netsign.base.processors.util.MessageConvertor;
import cn.com.infosec.netsign.base.processors.util.ProcessUtil;
import cn.com.infosec.netsign.resources.ResourceDeleter;
import cn.com.infosec.netsign.resources.ResourceListFilter;
import cn.com.infosec.netsign.resources.ResourceManager;
import cn.com.infosec.netsign.resources.rawcert.PBCRAWCert;
import cn.com.infosec.netsign.resources.rawcert.PBCRAWCertProxy;
import cn.com.infosec.netsign.resources.rawcert.PBCRAWCertProxyFactory;
import cn.com.infosec.netsign.resources.rawcert.PBCRAWCertResourceList;
import cn.com.infosec.netsign.synfwimpl.CertSYNParameters;
import cn.com.infosec.netsign.synfwimpl.config.HostOfRAWCert;
import cn.com.infosec.netsign.synfwimpl.handle.PBCRAWCertSynManager;
import cn.com.infosec.netsign.synfwimpl.handle.PBCRAWCertSynManagerFactory;
import cn.com.infosec.netsign.synfwimpl.jmx.CertTask;
import cn.com.infosec.synfw.auth.MessageAuth;
import cn.com.infosec.synfw.auth.MessageAuthFactory;
import cn.com.infosec.synfw.config.SynConfig;
import cn.com.infosec.synfw.jmx.Task;
import cn.com.infosec.synfw.logger.SynLogger;
import java.util.HashMap;

public class SYNDeleteCertProcessor
implements Processor {
    public AbstractMessage process(AbstractMessage request) throws ProcessorException {
        AdminMessage res = ProcessUtil.createAdminMessage(request);
        AdminMessage req = MessageConvertor.convertAdminMessage(request, res);
        String certDN = null;
        String listName = null;
        String deletedTime = null;
        CertSYNParameters synpara = null;
        HashMap map = (HashMap)req.getContent();
        byte[] rawPara = (byte[])map.get("rawSynPara");
        boolean needauth = (Boolean)map.get("needauth");
        int authtype = -1;
        try {
            synpara = CertSYNParameters.ByteArrays2Object((byte[])rawPara);
        }
        catch (Exception e1) {
            SynLogger.log((String)"( SYNDeleteCertProcessor )Tranform CertSYNParameters 2 byteArrays failed. Caused by: ");
            SynLogger.log((Throwable)e1);
        }
        HostOfRAWCert desthost = null;
        boolean needauthSelf = false;
        String authcode = null;
        if (needauth) {
            byte[] authcodedigest = (byte[])map.get("authcode");
            desthost = ProcessUtil.findAuthCodeforVerify(authcodedigest);
            if (desthost != null) {
                needauthSelf = desthost.isNeedauth();
                authcode = desthost.getAuthCode();
            }
            authtype = (Integer)map.get("authtype");
            if (authcode == null) {
                SynLogger.log((String)"SYNDeleteCert failed, Caused by: Can't find corresponding authcode with req.");
                res.setResult(-100180);
                res.setErrMsg("SYNParameters can't verifed.");
                return res;
            }
        }
        if (needauthSelf && authcode != null) {
            if (needauth) {
                byte[] encrySynPara = (byte[])map.get("encrySynPara");
                MessageAuth auther = MessageAuthFactory.getInstance((int)authtype);
                boolean isverifyok = auther.verifyAuthMessage(rawPara, authcode, encrySynPara);
                if (!isverifyok) {
                    SynLogger.log((String)"SYNDeleteCert failed, Caused by: Syn parameters can't verified.");
                    res.setResult(-100180);
                    res.setErrMsg("SYNParameters can't verifed.");
                    return res;
                }
            } else {
                SynLogger.log((String)"SYNDeleteCert failed, Caused by: Syn parameters need to verify, there are not auth-message. Can't to verify.");
                res.setResult(-100180);
                res.setErrMsg("SYNParameters can't verifed.");
                return res;
            }
        }
        if ((certDN = synpara.getCertDN()) == null || certDN.equals("")) {
            res.setResult(-100225);
            res.setErrMsg("No certDN received when SYN delete cert.");
            return res;
        }
        listName = synpara.getListname();
        deletedTime = synpara.getOperatetime();
        PBCRAWCertResourceList certlist = null;
        PBCRAWCertProxy query = PBCRAWCertProxyFactory.getFindResourceListByName((String)listName);
        certlist = (PBCRAWCertResourceList)ResourceManager.getAllResourceList().getResourceList((ResourceListFilter)query);
        PBCRAWCert cert = new PBCRAWCert();
        cert.setCertDN(certDN);
        if (deletedTime != null && !deletedTime.equals("")) {
            cert.addModifyTime(deletedTime);
        } else {
            cert.addModifyTime();
        }
        cert.setPath(certlist.getPath());
        if (!synpara.isIslocalOper() && SynConfig.isCenter_host()) {
            PBCRAWCertSynManager synmanager;
            if (desthost != null && desthost.getWeb_type() == 1) {
                synmanager = PBCRAWCertSynManagerFactory.getSynManager();
                CertTask task = null;
                task = CertTask.getInstance(null, (String)listName, (String)certDN, (String)"syndeleteresource", (boolean)SynConfig.isCenter_host(), (PBCRAWCert)cert);
                task.setSrcOftask(1);
                task.setSrcOfhost(desthost);
                synmanager.realTimeSyn((Task)task);
            } else {
                synmanager = PBCRAWCertSynManagerFactory.getSynManager();
                CertTask task = null;
                task = CertTask.getInstance(null, (String)listName, (String)certDN, (String)"syndeleteresource", (boolean)SynConfig.isCenter_host(), (PBCRAWCert)cert);
                task.setSrcOftask(0);
                synmanager.realTimeSyn((Task)task);
            }
        }
        query.setType(4002);
        query.addCondition("resource", (Object)cert);
        try {
            if (certlist.deleteResource((ResourceDeleter)query)) {
                SynLogger.log((String)("SYNDeleteCertProcessor certificate(" + certDN + ") successed"));
                certlist.log("Certificate [ " + certDN + " ] deleted by SYN.");
            } else {
                SynLogger.log((String)("SYN delete certificate( " + certDN + " ) failed file not exists."));
            }
        }
        catch (Exception e) {
            SynLogger.log((String)("SYN delete certificate( " + certDN + " ) failed " + -100053 + " " + e.toString()));
            SynLogger.log((Throwable)e);
            res.setResult(-100053);
            res.setErrMsg(e.toString());
            return res;
        }
        return res;
    }
}

