/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.base.processors;

import cn.com.infosec.netsign.base.AbstractMessage;
import cn.com.infosec.netsign.base.AdminMessage;
import cn.com.infosec.netsign.base.ErrorInfoRes;
import cn.com.infosec.netsign.base.Processor;
import cn.com.infosec.netsign.base.processors.ProcessorException;
import cn.com.infosec.netsign.base.processors.util.MessageConvertor;
import cn.com.infosec.netsign.base.processors.util.ProcessUtil;
import cn.com.infosec.netsign.logger.ConsoleLogger;
import cn.com.infosec.netsign.manager.LogManager;
import cn.com.infosec.netsign.manager.NetSignServerGroup;

public class RemoveServerProcessor
implements Processor {
    private int id = 1;

    public AbstractMessage process(AbstractMessage request) throws ProcessorException {
        AdminMessage res = ProcessUtil.createAdminMessage(request);
        AdminMessage req = MessageConvertor.convertAdminMessage(request, res);
        if (res.getResult() < 0) {
            LogManager.getDebugLogger().Log(String.valueOf(this.id) + " " + res.getProcessor() + ": " + res.getResult() + ", " + res.getErrMsg());
            LogManager.getAccessLogger().Log(String.valueOf(this.id) + " RemoveServer failed");
            return res;
        }
        String id = MessageConvertor.convertServerId(req, res);
        if (res.getResult() < 0) {
            LogManager.getDebugLogger().Log(String.valueOf(id) + " " + res.getProcessor() + ": " + req.getString());
            LogManager.getDebugLogger().Log(String.valueOf(id) + " " + res.getProcessor() + ": " + res.getResult() + ", " + res.getErrMsg());
            LogManager.getAccessLogger().Log(String.valueOf(id) + " RemoveServer failed");
            return res;
        }
        try {
            NetSignServerGroup.removeServer(id);
        }
        catch (Throwable channelEx) {
            ConsoleLogger.logException((Throwable)channelEx);
            res.setResult(-100022);
            res.setErrMsg(String.valueOf(ErrorInfoRes.getErrorInfo(-100022)) + ": " + channelEx.getMessage());
            LogManager.getDebugLogger().Log(String.valueOf(id) + " " + res.getProcessor() + ": " + req.getString());
            LogManager.getDebugLogger().Log(String.valueOf(id) + " " + res.getProcessor() + ": " + res.getResult() + ", " + res.getErrMsg());
            LogManager.getAccessLogger().Log(String.valueOf(id) + " RemoveServer failed");
            return res;
        }
        LogManager.getAccessLogger().Log(String.valueOf(id) + " RemoveServer success");
        return res;
    }
}

