/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.base.processors;

import cn.com.infosec.netsign.base.AbstractMessage;
import cn.com.infosec.netsign.base.AdminMessage;
import cn.com.infosec.netsign.base.ErrorInfoRes;
import cn.com.infosec.netsign.base.Processor;
import cn.com.infosec.netsign.base.processors.ProcessorException;
import cn.com.infosec.netsign.base.processors.util.MessageConvertor;
import cn.com.infosec.netsign.base.processors.util.ProcessUtil;
import cn.com.infosec.netsign.frame.config.Service;
import cn.com.infosec.netsign.logger.ConsoleLogger;
import cn.com.infosec.netsign.manager.LogManager;
import cn.com.infosec.netsign.manager.NetSignServerGroup;

public class ModifyServerProcessor
implements Processor {
    private int id = 1;

    public AbstractMessage process(AbstractMessage request) throws ProcessorException {
        AdminMessage res = ProcessUtil.createAdminMessage(request);
        AdminMessage req = MessageConvertor.convertAdminMessage(request, res);
        if (res.getResult() < 0) {
            LogManager.getDebugLogger().Log(String.valueOf(this.id) + " " + res.getProcessor() + ": " + res.getResult() + ", " + res.getErrMsg());
            LogManager.getAccessLogger().Log(String.valueOf(this.id) + " ModifyServer failed");
            return res;
        }
        Service config = null;
        try {
            config = (Service)req.getContent();
            ConsoleLogger.logString((String)"get the Service config");
        }
        catch (ClassCastException clsEx) {
            ConsoleLogger.logException((Throwable)clsEx);
            res.setResult(-100010);
            res.setErrMsg(String.valueOf(ErrorInfoRes.getErrorInfo(-100010)) + ": " + req.getContent().toString());
            LogManager.getDebugLogger().Log(String.valueOf(this.id) + " " + res.getProcessor() + ": " + req.getString());
            LogManager.getDebugLogger().Log(String.valueOf(this.id) + " " + res.getProcessor() + ": " + res.getResult() + ", " + res.getErrMsg());
            LogManager.getAccessLogger().Log(String.valueOf(this.id) + " ModifyServer failed");
            return res;
        }
        try {
            NetSignServerGroup.modifyServer(config);
            ConsoleLogger.logString((String)"restart the service");
        }
        catch (Throwable channelEx) {
            ConsoleLogger.logException((Throwable)channelEx);
            res.setResult(-100023);
            res.setErrMsg(String.valueOf(ErrorInfoRes.getErrorInfo(-100023)) + ": " + channelEx.getMessage());
            LogManager.getDebugLogger().Log(String.valueOf(this.id) + " " + res.getProcessor() + ": " + req.getString());
            LogManager.getDebugLogger().Log(String.valueOf(this.id) + " " + res.getProcessor() + ": " + res.getResult() + ", " + res.getErrMsg());
            LogManager.getAccessLogger().Log(String.valueOf(this.id) + " ModifyServer failed");
            return res;
        }
        LogManager.getAccessLogger().Log(String.valueOf(this.id) + " ModifyServer success");
        return res;
    }
}

