/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.base.processors;

import cn.com.infosec.isfw2.sfw.Request;
import cn.com.infosec.isfw2.sfw.Response;
import cn.com.infosec.netsign.base.AbstractMessage;
import cn.com.infosec.netsign.base.ErrorInfoRes;
import cn.com.infosec.netsign.base.NSMessage;
import cn.com.infosec.netsign.base.NetSignX509Certificate;
import cn.com.infosec.netsign.base.channels.ServerChannel;
import cn.com.infosec.netsign.base.processors.util.ProcessUtil;
import cn.com.infosec.netsign.base.util.NetSignImpl;
import cn.com.infosec.netsign.base.util.ServerKeyStore;
import cn.com.infosec.netsign.frame.config.ExtendedConfig;
import cn.com.infosec.netsign.isfwimpl.NetSignProcessor;
import cn.com.infosec.netsign.isfwimpl.NetSignRequest;
import cn.com.infosec.netsign.isfwimpl.NetSignResponse;
import cn.com.infosec.oscca.sm2.SM2Certificate;
import cn.com.infosec.oscca.sm2.SM2PrivateKey;
import java.security.PrivateKey;

public class MakeMSEnvelopedMSGProcessor
implements NetSignProcessor {
    private ServerChannel channel = null;

    public MakeMSEnvelopedMSGProcessor() {
    }

    public void setChannel(ServerChannel channel) {
        if (this.channel != channel) {
            this.channel = channel;
        }
    }

    private NetSignX509Certificate getEncCert(NSMessage request, AbstractMessage response) {
        NetSignX509Certificate cert = null;
        if (request.isTransCert()) {
            cert = NetSignX509Certificate.getInstance(request.getCert());
            if (cert == null) {
                cert = this.channel.getEnvelopeCert();
            }
        } else {
            cert = this.channel.getEnvelopeCert(request.getEncCertDN());
        }
        return cert;
    }

    private byte[] composeEnvelopedMsg(byte[] plainText, NetSignX509Certificate encCert, ServerKeyStore keyStore, String symmetricalAlg, String digestAlg, AbstractMessage response) {
        byte[] envelopeData = null;
        NetSignImpl impl = new NetSignImpl();
        if (this.channel.isUsedHardware()) {
            try {
                PrivateKey tmpprikey = keyStore.getPrivateKey();
                byte[] signedTemp = null;
                signedTemp = tmpprikey instanceof SM2PrivateKey ? impl.GenerateSingleSignedMsg(plainText, (SM2PrivateKey)tmpprikey, (SM2Certificate)keyStore.getCertChain()[0], keyStore.getCertChainEncoded(), keyStore.getIsAndsns(), digestAlg, false, ExtendedConfig.isSM2SignUsingQ7()) : impl.GenerateHardSignedMsg(plainText, keyStore.getLabel(), keyStore.getCertChain(), digestAlg, false);
                envelopeData = impl.composeHardSingleEnvelopedMsg(signedTemp, encCert.getCert(), symmetricalAlg);
            }
            catch (Exception ex) {
                ProcessUtil.throwDetailException(ex, response);
            }
        } else {
            try {
                PrivateKey tmpprikey = keyStore.getPrivateKey();
                byte[] signedTemp = null;
                signedTemp = tmpprikey instanceof SM2PrivateKey ? impl.GenerateSingleSignedMsg(plainText, (SM2PrivateKey)tmpprikey, (SM2Certificate)keyStore.getCertChain()[0], keyStore.getCertChainEncoded(), keyStore.getIsAndsns(), digestAlg, false, ExtendedConfig.isSM2SignUsingQ7()) : impl.GenerateSingleSignedMsg(plainText, keyStore.getPrivateKey(), keyStore.getCertChain(), keyStore.getCertChainEncoded(), keyStore.getIsAndsns(), digestAlg, false, ExtendedConfig.getSignProvider(), ExtendedConfig.isRSASignUsingQ7());
                envelopeData = impl.composeSingleEnvelopedMsg(signedTemp, encCert.getCert(), symmetricalAlg, ExtendedConfig.getEncryptProvider(), encCert.getPublicKey());
            }
            catch (Exception ex) {
                ProcessUtil.throwDetailException(ex, response);
            }
        }
        return envelopeData;
    }

    public MakeMSEnvelopedMSGProcessor(ServerChannel channel) {
        this.channel = channel;
    }

    public Response process(Request req) {
        NetSignRequest nsreq = (NetSignRequest)req;
        NSMessage request = nsreq.getNSMessage();
        String failedMsg = String.valueOf(this.channel.getId()) + " " + request.getAddress() + " MakeMSEnvelope failed:";
        NSMessage res = ProcessUtil.createNSMessage(request);
        byte[] plainText = request.getPlainText();
        plainText = ProcessUtil.disassemble(plainText, this.channel.isCryptoCommunicate(), this.channel.getCryptoUtil(), request, res);
        if (res.getResult() < 0) {
            ProcessUtil.log(this.channel.getDebugLogger(), this.channel.getId(), request, res);
            ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(failedMsg) + res.getResult(), this.channel.getLogLevel(), nsreq, res);
            return NetSignResponse.createNetSignResponse(res, nsreq);
        }
        ServerKeyStore keyStore = this.channel.getSignKeyStore(request.getSignCertDN());
        if (keyStore == null) {
            res.setResult(-100204);
            res.setErrMsg(ErrorInfoRes.getErrorInfo(-100204));
            ProcessUtil.log(this.channel.getDebugLogger(), this.channel.getId(), request, res);
            ProcessUtil.accessLog(this.channel.getAccessLogger(), failedMsg, this.channel.getLogLevel(), nsreq, res);
            return NetSignResponse.createNetSignResponse(res, nsreq);
        }
        NetSignX509Certificate enccert = this.getEncCert(request, res);
        if (enccert == null) {
            res.setResult(-100203);
            res.setErrMsg(ErrorInfoRes.getErrorInfo(-100203));
            ProcessUtil.log(this.channel.getDebugLogger(), this.channel.getId(), request, res);
            ProcessUtil.accessLog(this.channel.getAccessLogger(), failedMsg, this.channel.getLogLevel(), nsreq, res);
            return NetSignResponse.createNetSignResponse(res, nsreq);
        }
        byte[] envelopeData = this.composeEnvelopedMsg(plainText, enccert, keyStore, ProcessUtil.getSymmetricalAlgorithm(request, this.channel), ProcessUtil.getDigestAlgoritim(request, this.channel, keyStore), res);
        if (res.getResult() < 0) {
            ProcessUtil.log(this.channel.getDebugLogger(), this.channel.getId(), request, res);
            ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(failedMsg) + res.getResult(), this.channel.getLogLevel(), nsreq, res);
            return NetSignResponse.createNetSignResponse(res, nsreq);
        }
        envelopeData = ProcessUtil.assembleOnlyZip(envelopeData, request, res);
        if (res.getResult() > 0) {
            res.setCryptoText(envelopeData);
            ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(this.channel.getId()) + " " + request.getAddress() + " MakeMSEnvelope success", this.channel.getLogLevel(), nsreq, res);
        } else {
            ProcessUtil.log(this.channel.getDebugLogger(), this.channel.getId(), request, res);
            ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(failedMsg) + res.getResult(), this.channel.getLogLevel(), nsreq, res);
        }
        return NetSignResponse.createNetSignResponse(res, nsreq);
    }
}

