/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.base.processors;

import cn.com.infosec.netsign.base.AbstractMessage;
import cn.com.infosec.netsign.base.AdminMessage;
import cn.com.infosec.netsign.base.Processor;
import cn.com.infosec.netsign.base.config.SystemInfoImpl;
import cn.com.infosec.netsign.base.processors.ProcessorException;
import cn.com.infosec.netsign.base.processors.util.MessageConvertor;
import cn.com.infosec.netsign.base.processors.util.ProcessUtil;
import cn.com.infosec.netsign.logger.ConsoleLogger;
import cn.com.infosec.netsign.manager.LogManager;

public class GetSystemInfoProcessor
implements Processor {
    private int id = 2;

    public AbstractMessage process(AbstractMessage request) throws ProcessorException {
        AdminMessage res = ProcessUtil.createAdminMessage(request);
        AdminMessage req = MessageConvertor.convertAdminMessage(request, res);
        if (res.getResult() < 0) {
            LogManager.getDebugLogger().Log(String.valueOf(this.id) + " " + res.getProcessor() + ": " + res.getResult() + ", " + res.getErrMsg());
            LogManager.getAccessLogger().Log(String.valueOf(this.id) + " GetSysInfo failed");
            return res;
        }
        SystemInfoImpl sysinfo = null;
        try {
            sysinfo = new SystemInfoImpl();
        }
        catch (Throwable ex) {
            ConsoleLogger.logException((Throwable)ex);
            res.setResult(-100027);
            res.setErrMsg(ex.getMessage());
            LogManager.getDebugLogger().Log(String.valueOf(this.id) + " " + res.getProcessor() + ": " + req.getString());
            LogManager.getDebugLogger().Log(String.valueOf(this.id) + " " + res.getProcessor() + ": " + res.getResult() + ", " + res.getErrMsg());
            LogManager.getAccessLogger().Log(String.valueOf(this.id) + " GetSysInfo failed");
            return res;
        }
        res.setContent(sysinfo);
        LogManager.getAccessLogger().Log(String.valueOf(this.id) + " GetSysInfo success");
        return res;
    }
}

