/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.base.processors;

import cn.com.infosec.isfw2.sfw.Request;
import cn.com.infosec.isfw2.sfw.Response;
import cn.com.infosec.netsign.base.ErrorInfoRes;
import cn.com.infosec.netsign.base.NSMessage;
import cn.com.infosec.netsign.base.channels.ServerChannel;
import cn.com.infosec.netsign.base.processors.util.ProcessUtil;
import cn.com.infosec.netsign.isfwimpl.NetSignProcessor;
import cn.com.infosec.netsign.isfwimpl.NetSignRequest;
import cn.com.infosec.netsign.isfwimpl.NetSignResponse;
import cn.com.infosec.netsign.resources.rawcert.PBCRAWCert;
import cn.com.infosec.netsign.resources.rawcert.PBCRAWCertResourceList;

public class GetRAWCertListProcessor
implements NetSignProcessor {
    private ServerChannel channel;

    public GetRAWCertListProcessor(ServerChannel channel) {
        this.channel = channel;
    }

    public GetRAWCertListProcessor() {
    }

    public void setChannel(ServerChannel channel) {
        if (this.channel != channel) {
            this.channel = channel;
        }
    }

    public Response process(Request req) {
        NetSignRequest nsreq = (NetSignRequest)req;
        NSMessage request = nsreq.getNSMessage();
        NSMessage res = ProcessUtil.createNSMessage(request);
        String dn = request.getSignCertDN();
        if (dn == null || dn.equals("")) {
            dn = "all";
        }
        String failedMsg = String.valueOf(this.channel.getId()) + " " + request.getAddress() + " GetRAWCertList by " + dn + " failed:";
        PBCRAWCertResourceList certlist = (PBCRAWCertResourceList)ProcessUtil.getResourceList(this.channel, request.getResourceName());
        if (certlist == null) {
            res.setResult(-100280);
            res.setErrMsg("No certificate list found by " + request.getResourceName());
            ProcessUtil.log(this.channel.getDebugLogger(), this.channel.getId(), request, res);
            ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(this.channel.getId()) + " " + request.getAddress() + " " + failedMsg + ":" + res.getResult(), this.channel.getLogLevel(), nsreq, res);
            return NetSignResponse.createNetSignResponse(res, nsreq);
        }
        if (dn.equals("all")) {
            if (certlist.size() > 0) {
                StringBuffer buf = new StringBuffer();
                int i = 0;
                int length = certlist.size();
                while (i < length) {
                    PBCRAWCert cert = (PBCRAWCert)certlist.get(i);
                    if (cert.getCertDN() != null) {
                        buf.append(String.valueOf(cert.getCertDN()) + "|");
                    }
                    ++i;
                }
                res.setSignCertDN(buf.toString());
            } else {
                res.setSignCertDN("");
            }
        } else {
            PBCRAWCert cert = ProcessUtil.getPBCRAWCert(dn, certlist);
            if (cert == null || cert.getCert() == null) {
                res.setResult(-100224);
                res.setErrMsg(ErrorInfoRes.getErrorInfo(-100224));
                ProcessUtil.log(this.channel.getDebugLogger(), this.channel.getId(), request, res);
                ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(failedMsg) + -100224, this.channel.getLogLevel(), nsreq, res);
                return NetSignResponse.createNetSignResponse(res, nsreq);
            }
            res.setSignCertDN(dn);
        }
        ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(this.channel.getId()) + " GetRAWCertListProcessor get rawcert list successed.", this.channel.getLogLevel(), nsreq, res);
        return NetSignResponse.createNetSignResponse(res, nsreq);
    }
}

