/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.base.processors;

import cn.com.infosec.isfw2.sfw.Request;
import cn.com.infosec.isfw2.sfw.Response;
import cn.com.infosec.netsign.base.AbstractMessage;
import cn.com.infosec.netsign.base.ErrorInfoRes;
import cn.com.infosec.netsign.base.NSMessage;
import cn.com.infosec.netsign.base.NSMessageOpt;
import cn.com.infosec.netsign.base.channels.ServerChannel;
import cn.com.infosec.netsign.base.processors.util.ProcessUtil;
import cn.com.infosec.netsign.isfwimpl.NetSignProcessor;
import cn.com.infosec.netsign.isfwimpl.NetSignRequest;
import cn.com.infosec.netsign.isfwimpl.NetSignResponse;
import cn.com.infosec.netsign.resources.rawcert.PBCRAWCert;
import cn.com.infosec.netsign.resources.rawcert.PBCRAWCertResourceList;

public class GetRAWCertDetailProcessor
implements NetSignProcessor {
    private ServerChannel channel;

    public GetRAWCertDetailProcessor(ServerChannel channel) {
        this.channel = channel;
    }

    public GetRAWCertDetailProcessor() {
    }

    public void setChannel(ServerChannel channel) {
        if (this.channel != channel) {
            this.channel = channel;
        }
    }

    private void setNoCertError(AbstractMessage res, String dn) {
        res.setResult(-100224);
        res.setErrMsg(String.valueOf(ErrorInfoRes.getErrorInfo(-100224)) + ": " + dn);
    }

    public Response process(Request req) {
        NetSignRequest nsreq = (NetSignRequest)req;
        NSMessage request = nsreq.getNSMessage();
        String failedMsg = String.valueOf(this.channel.getId()) + " " + request.getAddress() + " GetRAWCertDetail failed";
        NSMessageOpt res = ProcessUtil.createNSMessageOpt(request);
        PBCRAWCertResourceList certlist = (PBCRAWCertResourceList)ProcessUtil.getResourceList(this.channel, request.getResourceName());
        if (certlist == null) {
            res.setResult(-100280);
            res.setErrMsg("No certificate list found by " + request.getResourceName());
            ProcessUtil.log(this.channel.getDebugLogger(), this.channel.getId(), request, res);
            ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(this.channel.getId()) + " " + request.getAddress() + " " + failedMsg + ":" + res.getResult(), this.channel.getLogLevel(), nsreq, res);
            return NetSignResponse.createNetSignResponse(res, nsreq);
        }
        PBCRAWCert cert = null;
        String certDN = request.getSignCertDN();
        if (certDN != null) {
            cert = ProcessUtil.getPBCRAWCert(certDN, certlist);
        }
        if (cert.getCert() == null) {
            this.setNoCertError(res, certDN);
            ProcessUtil.log(this.channel.getDebugLogger(), this.channel.getId(), request, res);
            ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(this.channel.getId()) + " " + request.getAddress() + " " + failedMsg + ":" + res.getResult(), this.channel.getLogLevel(), nsreq, res);
            return NetSignResponse.createNetSignResponse(res, nsreq);
        }
        res.setSignCertDN(cert.getCertDN());
        res.setSignSerNumber(cert.getSerialNumber());
        res.setSignIssuerSubject(cert.getIssuerDN());
        res.setSignStartTime(String.valueOf(Long.parseLong(cert.getNotBefore()) / 1000L));
        res.setSignEndTime(String.valueOf(Long.parseLong(cert.getNotAfter()) / 1000L));
        ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(this.channel.getId()) + " GetRAWCertDetailProcessor get cert DN :" + cert.getCertDN() + " detail successed.", this.channel.getLogLevel(), nsreq, res);
        return NetSignResponse.createNetSignResponse(res, nsreq);
    }
}

