/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.base.processors;

import cn.com.infosec.netsign.base.AbstractMessage;
import cn.com.infosec.netsign.base.AdminMessage;
import cn.com.infosec.netsign.base.Processor;
import cn.com.infosec.netsign.base.processors.ProcessorException;
import cn.com.infosec.netsign.base.processors.util.MessageConvertor;
import cn.com.infosec.netsign.base.processors.util.ProcessUtil;
import cn.com.infosec.netsign.logger.ConsoleLogger;
import cn.com.infosec.netsign.resources.ResourceDeleter;
import cn.com.infosec.netsign.resources.ResourceListFilter;
import cn.com.infosec.netsign.resources.ResourceManager;
import cn.com.infosec.netsign.resources.ResourcePool;
import cn.com.infosec.netsign.resources.rawcert.PBCRAWCert;
import cn.com.infosec.netsign.resources.rawcert.PBCRAWCertProxy;
import cn.com.infosec.netsign.resources.rawcert.PBCRAWCertProxyFactory;
import cn.com.infosec.netsign.resources.rawcert.PBCRAWCertResourceList;
import cn.com.infosec.netsign.synfwimpl.handle.PBCRAWCertSynManager;
import cn.com.infosec.netsign.synfwimpl.handle.PBCRAWCertSynManagerFactory;
import cn.com.infosec.netsign.synfwimpl.jmx.CertTask;
import cn.com.infosec.synfw.config.SynConfig;
import cn.com.infosec.synfw.jmx.Task;
import java.util.HashMap;

public class DeleteBankInfoProcessor
implements Processor {
    private PBCRAWCertResourceList certList = null;

    public AbstractMessage process(AbstractMessage request) throws ProcessorException {
        AdminMessage res = ProcessUtil.createAdminMessage(request);
        AdminMessage req = MessageConvertor.convertAdminMessage(request, res);
        ResourcePool rp = ResourceManager.getAllResourceList();
        HashMap content = (HashMap)req.getContent();
        String listName = (String)content.get("listname");
        PBCRAWCertProxy query = PBCRAWCertProxyFactory.getFindResourceListByName((String)listName);
        this.certList = (PBCRAWCertResourceList)rp.getResourceList((ResourceListFilter)query);
        if (this.certList == null) {
            res.setResult(-100280);
            res.setErrMsg("Can not find resource list by name:" + listName);
            this.certList.log("AdminUplloadCertProcessor can not file resource list by name:" + listName);
            return res;
        }
        String bankID = (String)content.get("bankId");
        PBCRAWCert cert = new PBCRAWCert();
        String certDN = null;
        if (bankID != null && (cert = ProcessUtil.getPBCRAWCert(bankID, this.certList)) != null) {
            certDN = cert.getCertDN();
        }
        cert.addModifyTime();
        if (certDN != null && SynConfig.getHostslist().size() > 0) {
            PBCRAWCertSynManager synmanager = PBCRAWCertSynManagerFactory.getSynManager();
            CertTask task = CertTask.getInstance((String)bankID, (String)this.certList.getName(), (String)certDN, (String)"syndeleteresource", (boolean)SynConfig.isCenter_host(), (PBCRAWCert)cert);
            synmanager.realTimeSyn((Task)task);
        }
        query.setType(4001);
        query.addCondition("subjectorbankcode", (Object)bankID);
        try {
            if (!this.certList.deleteResource((ResourceDeleter)query)) {
                this.certList.log("DeleteBankInfoProcessor can not delete bankinfo by " + bankID);
            } else {
                this.certList.log("DeleteBankInfoProcessor delete bankinfo by " + bankID + " successed");
            }
        }
        catch (Exception e) {
            ConsoleLogger.logException((Throwable)e);
            res.setResult(-100281);
            res.setErrMsg("Delete bankinfo by " + bankID + " failed " + e.toString());
            this.certList.log("DeleteBankInfoProcessor Delete bankinfo by " + bankID + " failed " + e.toString());
            return res;
        }
        return res;
    }
}

