/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.base.processors;

import cn.com.infosec.crypto.CipherParameters;
import cn.com.infosec.crypto.params.KeyParameter;
import cn.com.infosec.isfw2.sfw.Request;
import cn.com.infosec.isfw2.sfw.Response;
import cn.com.infosec.netsign.base.ErrorInfoRes;
import cn.com.infosec.netsign.base.NSMessage;
import cn.com.infosec.netsign.base.NSMessageOpt;
import cn.com.infosec.netsign.base.channels.ServerChannel;
import cn.com.infosec.netsign.base.processors.util.ProcessUtil;
import cn.com.infosec.netsign.base.util.ServerKeyStore;
import cn.com.infosec.netsign.base.util.TrustConfig;
import cn.com.infosec.netsign.cavium.jce.DESedeEngine;
import cn.com.infosec.netsign.crypto.util.CryptoUtil;
import cn.com.infosec.netsign.frame.config.ExtendedConfig;
import cn.com.infosec.netsign.isfwimpl.NetSignProcessor;
import cn.com.infosec.netsign.isfwimpl.NetSignRequest;
import cn.com.infosec.netsign.isfwimpl.NetSignResponse;
import cn.com.infosec.netsign.logger.ConsoleLogger;
import cn.com.infosec.pkcs.FX509Certificate;
import java.io.ByteArrayInputStream;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;

public class DecryptZTCMessageProcessor
implements NetSignProcessor {
    private ServerChannel channel;
    private String failedMsg;

    public DecryptZTCMessageProcessor() {
    }

    public DecryptZTCMessageProcessor(ServerChannel channel) {
        this.channel = channel;
    }

    public void setChannel(ServerChannel channel) {
        if (this.channel != channel) {
            this.channel = channel;
        }
    }

    public Response process(Request req) {
        NetSignRequest nsreq = (NetSignRequest)req;
        NSMessage request = nsreq.getNSMessage();
        this.failedMsg = String.valueOf(this.channel.getId()) + " " + request.getAddress() + " DecryptZTCMessageProcessor failed:";
        NSMessageOpt res = ProcessUtil.createNSMessageOpt(request);
        if (res.getResult() < 0) {
            ProcessUtil.log(this.channel.getDebugLogger(), this.channel.getId(), request, res);
            ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(this.failedMsg) + res.getResult(), this.channel.getLogLevel(), nsreq, res);
            return NetSignResponse.createNetSignResponse(res, nsreq);
        }
        byte[] cryptoText = request.getCryptoText();
        this.decryptAndVerifyZTCMessage(cryptoText, request, res);
        if (res.getResult() < 0) {
            ProcessUtil.log(this.channel.getDebugLogger(), this.channel.getId(), request, res);
            ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(this.failedMsg) + res.getResult(), this.channel.getLogLevel(), nsreq, res);
            return NetSignResponse.createNetSignResponse(res, nsreq);
        }
        ProcessUtil.accessLog(this.channel.getAccessLogger(), "DecryptZTCMessageProcessor successed", this.channel.getLogLevel(), nsreq, res);
        return NetSignResponse.createNetSignResponse(res, nsreq);
    }

    private void decryptAndVerifyZTCMessage(byte[] message, NSMessage req, NSMessageOpt res) {
        byte[] encKey = new byte[128];
        System.arraycopy(message, 0, encKey, 0, 128);
        ServerKeyStore sks = this.channel.getSignKeyStore(req.getEncCertDN());
        if (sks == null) {
            this.handleError(-100203, res);
            return;
        }
        if ((encKey = this.deSessionKey(encKey, sks.getPrivateKey(), res)) == null) {
            this.handleError(-100211, res);
            return;
        }
        byte[] e2 = new byte[message.length - 128 - 4];
        System.arraycopy(message, 132, e2, 0, e2.length);
        e2 = this.deE2(e2, encKey);
        CryptoUtil.debug((String)"e2", (byte[])e2);
        if (e2 == null) {
            this.handleError(-100110, res);
            return;
        }
        byte[] radom = new byte[8];
        System.arraycopy(e2, 0, radom, 0, 8);
        res.setCryptoText(radom);
        byte[] sha1Radom1 = this.sha1Radom(radom);
        byte[] signedRadom = new byte[128];
        System.arraycopy(e2, 8, signedRadom, 0, 128);
        byte[] certLengthBytes = new byte[4];
        System.arraycopy(e2, 136, certLengthBytes, 0, 4);
        int certLength = CryptoUtil.bytes2Int((byte[])certLengthBytes, (boolean)true);
        if (certLength < 0 || certLength > e2.length - 140) {
            this.handleError(-100110, res);
            return;
        }
        byte[] userCertBytes = new byte[certLength];
        System.arraycopy(e2, 140, userCertBytes, 0, certLength);
        X509Certificate userCert = this.genCert(userCertBytes, res);
        if (userCert == null) {
            this.handleError(-100205, res);
            return;
        }
        int result = this.verifyCert(userCert, userCertBytes, res);
        if (result != 0) {
            this.handleError(result, res);
            return;
        }
        byte[] sha1Radom2 = this.deSha1Radom((RSAPublicKey)userCert.getPublicKey(), signedRadom);
        if (sha1Radom2 == null) {
            this.handleError(-100104, res);
            return;
        }
        if (!CryptoUtil.compereBytes((byte[])sha1Radom1, (byte[])sha1Radom2)) {
            this.handleError(-100104, res);
            return;
        }
    }

    private byte[] deSha1Radom(RSAPublicKey pubKey, byte[] signedRadom) {
        byte[] sha1RadomTmp = null;
        try {
            Cipher c = Cipher.getInstance("RSA/ECB/PKCS1Padding", ExtendedConfig.getDecryptProvider());
            c.init(2, pubKey);
            sha1RadomTmp = c.doFinal(signedRadom);
        }
        catch (Exception ex) {
            ConsoleLogger.logException((Throwable)ex);
        }
        return sha1RadomTmp;
    }

    private int verifyCert(X509Certificate userCert, byte[] userCertBs, NSMessageOpt res) {
        TrustConfig tcg = (TrustConfig)this.channel.getTrustConfigs().get(userCert.getIssuerDN().getName());
        if (tcg == null) {
            return -100105;
        }
        try {
            byte[] tbs = FX509Certificate.getTbsCertificate((byte[])userCertBs);
            tcg.VerifyCert(userCert, tbs, this.channel.getService().isCheckValidity(), ExtendedConfig.getDecryptProvider(), userCert.getNotBefore().getTime(), userCert.getNotAfter().getTime());
            if (tcg.isOCSPEnabled()) {
                tcg.VerifyOCSP(userCert);
            } else if (tcg.isCrlEnabled()) {
                tcg.VerifyCRL(userCert);
            }
            return 0;
        }
        catch (Exception e) {
            ProcessUtil.throwDetailException(e, res);
            return res.getResult();
        }
    }

    private X509Certificate genCert(byte[] userCertBytes, NSMessageOpt res) {
        res.setPlainText(userCertBytes);
        ByteArrayInputStream certin = new ByteArrayInputStream(userCertBytes);
        X509Certificate userCert = null;
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509", "INFOSEC");
            userCert = (X509Certificate)cf.generateCertificate(certin);
            certin.close();
        }
        catch (Exception e) {
            ConsoleLogger.logException((Throwable)e);
        }
        return userCert;
    }

    private byte[] sha1Radom(byte[] radom) {
        byte[] sha1Radom = null;
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA1", "INFOSEC");
            sha1Radom = digest.digest(radom);
        }
        catch (Exception e) {
            ConsoleLogger.logException((Throwable)e);
        }
        return sha1Radom;
    }

    private byte[] deE2(byte[] encE2, byte[] key) {
        byte[] e2 = null;
        try {
            Cipher c = Cipher.getInstance("DESede/ECB/NoPadding", "INFOSEC");
            DESedeKeySpec encKeySpec = new DESedeKeySpec(key);
            SecretKeyFactory skf = SecretKeyFactory.getInstance("DESede", "INFOSEC");
            SecretKey desKey = skf.generateSecret(encKeySpec);
            c.init(2, desKey);
            e2 = c.doFinal(encE2);
        }
        catch (Exception e) {
            ConsoleLogger.logException((Throwable)e);
        }
        return e2;
    }

    private byte[] deE2bak(byte[] encE2, byte[] key) {
        byte[] e2 = null;
        try {
            DESedeEngine engine = new DESedeEngine();
            DESedeKeySpec encKeySpec = new DESedeKeySpec(key);
            SecretKeyFactory skf = SecretKeyFactory.getInstance("DESede", "INFOSEC");
            SecretKey desKey = skf.generateSecret(encKeySpec);
            engine.init(false, (CipherParameters)new KeyParameter(desKey.getEncoded()));
            byte[] out = new byte[encE2.length];
            engine.processBlock(encE2, 0, out, 0);
            return out;
        }
        catch (Exception e) {
            ConsoleLogger.logException((Throwable)e);
            return e2;
        }
    }

    private byte[] deSessionKey(byte[] encKey, PrivateKey priKey, NSMessageOpt res) {
        byte[] key = null;
        try {
            Cipher c = Cipher.getInstance("RSA/ECB/PKCS1Padding", ExtendedConfig.getDecryptProvider());
            c.init(2, priKey);
            key = c.doFinal(encKey);
            res.setEncKey(key);
            byte[] temp = new byte[24];
            System.arraycopy(key, 0, temp, 0, 16);
            System.arraycopy(key, 0, temp, 16, 8);
            key = temp;
        }
        catch (Exception ex) {
            ConsoleLogger.logException((Throwable)ex);
        }
        return key;
    }

    private void handleError(int error, NSMessageOpt res) {
        res.setResult(error);
        res.setErrMsg(ErrorInfoRes.getErrorInfo(error));
    }
}

