/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.base.processors;

import cn.com.infosec.isfw2.sfw.Request;
import cn.com.infosec.isfw2.sfw.Response;
import cn.com.infosec.netsign.base.AbstractMessage;
import cn.com.infosec.netsign.base.ErrorInfoRes;
import cn.com.infosec.netsign.base.NSMessage;
import cn.com.infosec.netsign.base.channels.ServerChannel;
import cn.com.infosec.netsign.base.processors.util.ProcessUtil;
import cn.com.infosec.netsign.base.util.ServerKeyStore;
import cn.com.infosec.netsign.base.util.Utils;
import cn.com.infosec.netsign.crypto.algorithm.DigestAlgorithm;
import cn.com.infosec.netsign.crypto.util.AlgorithmUtil;
import cn.com.infosec.netsign.crypto.util.Base64;
import cn.com.infosec.netsign.crypto.util.SoftCryptoImpl;
import cn.com.infosec.netsign.frame.config.ExtendedConfig;
import cn.com.infosec.netsign.isfwimpl.NetSignProcessor;
import cn.com.infosec.netsign.isfwimpl.NetSignRequest;
import cn.com.infosec.netsign.isfwimpl.NetSignResponse;
import cn.com.infosec.netsign.manager.CryptoManager;
import cn.com.infosec.oscca.SDFJNI;
import cn.com.infosec.oscca.sm2.SM2PrivateKey;
import cn.com.infosec.oscca.sm2.SM2PublicKey;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;

public class CPICRAWSignProcessor
implements NetSignProcessor {
    private ServerChannel channel;

    public CPICRAWSignProcessor() {
    }

    public CPICRAWSignProcessor(ServerChannel channel) {
        this.channel = channel;
    }

    public void setChannel(ServerChannel channel) {
        if (this.channel != channel) {
            this.channel = channel;
        }
    }

    private static byte[] generateSignMsg(byte[] plainText, ServerKeyStore keyStore, String digestAlg, AbstractMessage res, boolean usedHardWare, String provider) {
        byte[] signedMsg;
        block12: {
            signedMsg = null;
            if (keyStore == null) {
                res.setResult(-100204);
                res.setErrMsg(ErrorInfoRes.getErrorInfo(-100204));
                return signedMsg;
            }
            if (usedHardWare) {
                try {
                    if (digestAlg.startsWith("1.2.156.197.1.401") || digestAlg.startsWith("SM3")) {
                        signedMsg = SDFJNI.SM2SignWithExternalKey((byte[])plainText, (String)digestAlg, (byte[])((SM2PrivateKey)keyStore.getPrivateKey()).getD(), (SM2PublicKey)((SM2PublicKey)keyStore.getPublicKey()), (byte[])Utils.getOSCCApucID(2, null));
                        break block12;
                    }
                    DigestAlgorithm digestam = AlgorithmUtil.getDigestAlgByName((String)digestAlg);
                    if (digestam == null) {
                        throw new NoSuchAlgorithmException("The DigestAlgorithm " + digestAlg + " Can not been Supported");
                    }
                    signedMsg = CryptoManager.getHardCryptoImpl().SignWithAlg(keyStore.getLabel(), plainText, digestam.getValue());
                }
                catch (Exception ex) {
                    ProcessUtil.throwDetailException(ex, res);
                }
            } else {
                try {
                    if (digestAlg.startsWith("1.2.156.197.1.401") || digestAlg.startsWith("SM3")) {
                        signedMsg = SDFJNI.SM2SignWithExternalKey((byte[])plainText, (String)digestAlg, (byte[])((SM2PrivateKey)keyStore.getPrivateKey()).getD(), (SM2PublicKey)((SM2PublicKey)keyStore.getPublicKey()), (byte[])Utils.getOSCCApucID(2, null));
                    } else {
                        DigestAlgorithm digestam = AlgorithmUtil.getDigestAlgByName((String)digestAlg);
                        if (digestam == null) {
                            throw new NoSuchAlgorithmException("The DigestAlgorithm " + digestAlg + " Can not been Supported");
                        }
                        signedMsg = SoftCryptoImpl.sign((PrivateKey)keyStore.getPrivateKey(), (byte[])plainText, (String)digestAlg, (String)provider);
                    }
                }
                catch (Exception ex) {
                    ProcessUtil.throwDetailException(ex, res);
                }
            }
        }
        return signedMsg;
    }

    public Response process(Request req) {
        NetSignRequest nsreq = (NetSignRequest)req;
        NSMessage request = nsreq.getNSMessage();
        String failedMsg = String.valueOf(this.channel.getId()) + " " + request.getAddress() + " CPICRAWSign failed:";
        NSMessage res = ProcessUtil.createNSMessage(request);
        byte[] plainText = request.getPlainText();
        if (plainText == null || plainText.length == 0) {
            res.setResult(-100208);
            res.setErrMsg(ErrorInfoRes.getErrorInfo(-100208));
            ProcessUtil.log(this.channel.getDebugLogger(), this.channel.getId(), request, res);
            ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(failedMsg) + res.getResult(), this.channel.getLogLevel(), nsreq, res);
            return NetSignResponse.createNetSignResponse(res, nsreq);
        }
        String certDN = request.getSignCertDN();
        ServerKeyStore ks = this.channel.getSignKeyStore(certDN);
        if (ks == null) {
            res.setResult(-100204);
            res.setErrMsg("CPICRAWSignProcessor Can not find signcert by " + certDN);
            ProcessUtil.log(this.channel.getDebugLogger(), this.channel.getId(), request, res);
            ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(failedMsg) + res.getResult(), this.channel.getLogLevel(), nsreq, res);
            return NetSignResponse.createNetSignResponse(res, nsreq);
        }
        String digestAlg = ProcessUtil.getDigestAlgoritim(request, this.channel, ks);
        byte[] signedMsg = CPICRAWSignProcessor.generateSignMsg(plainText, this.channel.getSignKeyStore(certDN), digestAlg, res, this.channel.isUsedHardware(), ExtendedConfig.getSignProvider());
        if (res.getResult() < 0) {
            ProcessUtil.log(this.channel.getDebugLogger(), this.channel.getId(), request, res);
            ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(failedMsg) + res.getResult(), this.channel.getLogLevel(), nsreq, res);
            return NetSignResponse.createNetSignResponse(res, nsreq);
        }
        String serialNumber = ks.getSerialNumber().toLowerCase();
        serialNumber = serialNumber.length() % 2 == 0 ? serialNumber : "0" + serialNumber;
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append(Base64.encode((byte[])signedMsg)).append("#");
        byte[] bs = new byte[serialNumber.length() + 1 + plainText.length];
        System.arraycopy(serialNumber.getBytes(), 0, bs, 0, serialNumber.length());
        bs[serialNumber.length()] = 35;
        System.arraycopy(plainText, 0, bs, serialNumber.length() + 1, plainText.length);
        sBuilder.append(Base64.encode((byte[])bs));
        res.setCryptoText(sBuilder.toString().getBytes());
        ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(this.channel.getId()) + " " + request.getAddress() + " CPICRAWSign success", this.channel.getLogLevel(), nsreq, res);
        return NetSignResponse.createNetSignResponse(res, nsreq);
    }
}

