/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.base.processors;

import cn.com.infosec.isfw2.sfw.Request;
import cn.com.infosec.isfw2.sfw.Response;
import cn.com.infosec.netsign.base.AbstractMessage;
import cn.com.infosec.netsign.base.NSMessage;
import cn.com.infosec.netsign.base.NSMessageOpt;
import cn.com.infosec.netsign.base.channels.ServerChannel;
import cn.com.infosec.netsign.base.processors.util.ProcessUtil;
import cn.com.infosec.netsign.base.util.NetSignImpl;
import cn.com.infosec.netsign.frame.config.ExtendedConfig;
import cn.com.infosec.netsign.isfwimpl.NetSignProcessor;
import cn.com.infosec.netsign.isfwimpl.NetSignRequest;
import cn.com.infosec.netsign.isfwimpl.NetSignResponse;

public class AttachedAfterwardsVerifyProcessor
implements NetSignProcessor {
    private ServerChannel channel;
    private String provider;

    public AttachedAfterwardsVerifyProcessor() {
    }

    public void setChannel(ServerChannel channel) {
        if (this.channel != channel) {
            this.channel = channel;
        }
        this.provider = ExtendedConfig.getVerifyProvider();
    }

    private NetSignImpl verifySignedMsg(byte[] cryptoText, AbstractMessage res, String digestAlg) {
        NetSignImpl impl = new NetSignImpl();
        try {
            impl.afterwardsVerifySingleSignedMsg(cryptoText, null, this.channel.getTrustConfigs(), this.provider, digestAlg);
        }
        catch (Exception ex) {
            ProcessUtil.throwDetailException(ex, res);
        }
        return impl;
    }

    public AttachedAfterwardsVerifyProcessor(ServerChannel channel) {
        this.provider = "INFOSEC";
        this.channel = channel;
        this.provider = ExtendedConfig.getVerifyProvider();
    }

    public Response process(Request req) {
        NetSignRequest nsreq = (NetSignRequest)req;
        NSMessage request = nsreq.getNSMessage();
        String failedMsg = String.valueOf(this.channel.getId()) + " " + request.getAddress() + " AttachedAfterwardsVerify failed:";
        NSMessageOpt res = ProcessUtil.createNSMessageOpt(request);
        if (res.getResult() < 0) {
            ProcessUtil.log(this.channel.getDebugLogger(), this.channel.getId(), request, res);
            ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(failedMsg) + res.getResult(), this.channel.getLogLevel(), nsreq, res);
            return NetSignResponse.createNetSignResponse(res, nsreq);
        }
        byte[] cryptoText = request.getCryptoText();
        cryptoText = ProcessUtil.disassemble(cryptoText, this.channel.isCryptoCommunicate(), this.channel.getCryptoUtil(), request, res);
        if (res.getResult() < 0) {
            ProcessUtil.log(this.channel.getDebugLogger(), this.channel.getId(), request, res);
            ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(failedMsg) + res.getResult(), this.channel.getLogLevel(), nsreq, res);
            return NetSignResponse.createNetSignResponse(res, nsreq);
        }
        String digestAlg = request.getDigestAlg();
        NetSignImpl impl = this.verifySignedMsg(cryptoText, res, digestAlg);
        if (res.getResult() < 0) {
            ProcessUtil.log(this.channel.getDebugLogger(), this.channel.getId(), request, res);
            ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(failedMsg) + res.getResult(), this.channel.getLogLevel(), nsreq, res);
            return NetSignResponse.createNetSignResponse(res, nsreq);
        }
        byte[] plainText = impl.getContentData();
        plainText = ProcessUtil.assemble(plainText, this.channel.getCryptoUtil(), request, res);
        if (res.getResult() < 0) {
            ProcessUtil.log(this.channel.getDebugLogger(), this.channel.getId(), request, res);
            ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(failedMsg) + res.getResult(), this.channel.getLogLevel(), nsreq, res);
            return NetSignResponse.createNetSignResponse(res, nsreq);
        }
        if (ExtendedConfig.isReturnVerifyResult()) {
            res.setDigestAlg(impl.getDigestAlg());
            res.setPlainText(plainText);
            ProcessUtil.addSignCertInfo(impl.getSignCertInfo(), res);
            ProcessUtil.addSignCert(request.isTransCert(), impl.getSignCert(), res);
        }
        ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(this.channel.getId()) + " " + request.getAddress() + " AttachedAfterwardsVerify success", this.channel.getLogLevel(), nsreq, res);
        return NetSignResponse.createNetSignResponse(res, nsreq);
    }
}

