/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.base.processors;

import cn.com.infosec.netsign.base.AbstractMessage;
import cn.com.infosec.netsign.base.AdminMessage;
import cn.com.infosec.netsign.base.Processor;
import cn.com.infosec.netsign.base.processors.ProcessorException;
import cn.com.infosec.netsign.base.processors.util.FileUtil;
import cn.com.infosec.netsign.base.processors.util.MessageConvertor;
import cn.com.infosec.netsign.base.processors.util.ProcessUtil;
import cn.com.infosec.netsign.logger.ConsoleLogger;
import cn.com.infosec.netsign.pbc.PartnerRowInfo;
import cn.com.infosec.netsign.pbc.PartnerRowInfoFile;
import cn.com.infosec.netsign.resources.ResourceListFilter;
import cn.com.infosec.netsign.resources.ResourceManager;
import cn.com.infosec.netsign.resources.ResourcePool;
import cn.com.infosec.netsign.resources.ResourceSetter;
import cn.com.infosec.netsign.resources.rawcert.PBCRAWCert;
import cn.com.infosec.netsign.resources.rawcert.PBCRAWCertProxy;
import cn.com.infosec.netsign.resources.rawcert.PBCRAWCertResourceList;
import org.apache.log4j.Logger;

public class AdminBatchUploadRowProcessor
implements Processor {
    private PBCRAWCertResourceList certList = null;

    public AbstractMessage process(AbstractMessage request) throws ProcessorException {
        AdminMessage res = ProcessUtil.createAdminMessage(request);
        AdminMessage req = MessageConvertor.convertAdminMessage(request, res);
        ResourcePool rp = ResourceManager.getAllResourceList();
        String listName = (String)req.getContent();
        PBCRAWCertProxy query = new PBCRAWCertProxy();
        query.setType(2001);
        query.addCondition("name", (Object)listName);
        this.certList = (PBCRAWCertResourceList)rp.getResourceList((ResourceListFilter)query);
        if (this.certList == null) {
            res.setResult(-100280);
            res.setErrMsg("Can not find resource list by name:" + listName);
            return res;
        }
        this.certList.log("AdminBatchUploadRowProcessor Handling CCMSZDT0401 start ...");
        this.certList.log("AdminBatchUploadRowProcessor Parsing CCMSZDT0401 ...");
        PartnerRowInfoFile pbif = null;
        try {
            pbif = PartnerRowInfoFile.parse((String)"/tmp/CCMSZDT0401.XML", (Logger)this.certList.getLogger());
        }
        catch (Exception e) {
            ConsoleLogger.logException((Throwable)e);
            res.setResult(-100051);
            res.setErrMsg("Parse pbc CCMSZDT0401.XML file failed," + e.toString());
            this.certList.log("AdminBatchUploadRowProcessor Parse pbc CCMSZDT0401.XML file failed," + e.toString());
            return res;
        }
        if (pbif == null) {
            res.setResult(-100051);
            res.setErrMsg("Parse pbc CCMSZDT0401.XML file failed, file content illegally");
            this.certList.log("AdminBatchUploadRowProcessor Parse pbc CCMSZDT0401.XML file failed, file content illegally");
            return res;
        }
        this.certList.log("AdminBatchUploadRowProcessor Parse CCMSZDT0401 finished");
        this.certList.log("AdminBatchUploadRowProcessor Updating bankinfo ...");
        int successCount = 0;
        int errorCount = 0;
        query.setType(3002);
        int i = 0;
        int size = pbif.size();
        while (i < size) {
            PartnerRowInfo pbi = pbif.get(i);
            String bankName = "";
            String bankCode = "";
            bankName = pbi.getBankName();
            bankCode = pbi.getBankCode();
            if (bankName != null && !bankName.equals("") && bankCode != null && !bankCode.equals("")) {
                this.certList.log("AdminBatchUploadRowProcessor deal " + bankName + "[" + bankCode + "](" + (i + 1) + "/" + size + ")");
                PBCRAWCert cert = null;
                int j = 0;
                while (j < this.certList.size()) {
                    PBCRAWCert tmpCert = (PBCRAWCert)this.certList.get(j);
                    if (tmpCert.getBankCode().equals(bankCode)) {
                        cert = tmpCert;
                        break;
                    }
                    ++j;
                }
                if (cert == null) {
                    cert = new PBCRAWCert();
                }
                cert.setBankName(bankName);
                cert.setBankCode(bankCode);
                cert.setPath(this.certList.getPath());
                cert.setAgentSettBank(pbi.getAgentSettBank());
                cert.setBankCatalog(pbi.getBankCatalog());
                cert.setBankType(pbi.getBankType());
                cert.setCcpc(pbi.getCcpc());
                cert.setDebtorCity(pbi.getDebtorCity());
                cert.setDrecCode(pbi.getDrecCode());
                cert.setEffectDate(pbi.getEffectDate());
                cert.setExpDate(pbi.getExpDate());
                cert.setPbcCode(pbi.getPbcCode());
                cert.setSbstitnbk(pbi.getSbstitnbk());
                cert.setSuprList(pbi.getSuprList());
                cert.setSysCode(pbi.getSysCode());
                cert.setTel(pbi.getTel());
                query.addCondition("resource", (Object)cert);
                try {
                    this.certList.setResource((ResourceSetter)query);
                    ++successCount;
                }
                catch (Exception e) {
                    ++errorCount;
                    ConsoleLogger.logException((Throwable)e);
                }
            }
            ++i;
        }
        this.certList.log("AdminBatchUploadRowProcessor Update finished");
        this.certList.log("AdminBatchUploadRowProcessor saving config file...");
        try {
            this.certList.saveDetail();
            this.certList.log("AdminBatchUploadRowProcessor config file saved.");
        }
        catch (Exception e) {
            ConsoleLogger.logException((Throwable)e);
            res.setResult(-100221);
            res.setErrMsg("AdminBatchUploadRowProcessor Save config file failed");
            this.certList.log("AdminBatchUploadRowProcessor Save config file failed.");
            return res;
        }
        this.certList.log("AdminBatchUploadRowProcessor Save config finished");
        FileUtil.writeLogToTemp("\u4e0a\u4f20\u603b\u6570:" + pbif.size() + "&nbsp;&nbsp;&nbsp;\u6210\u529f\u6570:" + successCount + "&nbsp;&nbsp;&nbsp;\u5931\u8d25\u6570:" + errorCount, "401");
        this.certList.log("AdminBatchUploadRowProcessor Handle CCMSZDT0401 finished");
        return res;
    }
}

