/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.base.processors;

import cn.com.infosec.jce.PKCS7SignedDataFX;
import cn.com.infosec.netsign.base.AbstractMessage;
import cn.com.infosec.netsign.base.AdminMessage;
import cn.com.infosec.netsign.base.Processor;
import cn.com.infosec.netsign.base.processors.ProcessorException;
import cn.com.infosec.netsign.base.processors.util.MessageConvertor;
import cn.com.infosec.netsign.base.processors.util.ProcessUtil;
import cn.com.infosec.netsign.base.util.NetSignImpl;
import cn.com.infosec.netsign.frame.util.PBCUtil;
import cn.com.infosec.netsign.logger.ConsoleLogger;
import cn.com.infosec.netsign.pbc.PartnerCert;
import cn.com.infosec.netsign.pbc.PartnerCertsFile;
import cn.com.infosec.netsign.resources.ResourceListFilter;
import cn.com.infosec.netsign.resources.ResourceManager;
import cn.com.infosec.netsign.resources.ResourcePool;
import cn.com.infosec.netsign.resources.ResourceSetter;
import cn.com.infosec.netsign.resources.rawcert.PBCRAWCert;
import cn.com.infosec.netsign.resources.rawcert.PBCRAWCertProxy;
import cn.com.infosec.netsign.resources.rawcert.PBCRAWCertResourceList;
import java.security.cert.X509Certificate;
import org.apache.log4j.Logger;

public class AdminBatchUploadCertProcessor
implements Processor {
    private NetSignImpl impl = new NetSignImpl();
    private PBCRAWCertResourceList certList = null;

    public AbstractMessage process(AbstractMessage request) throws ProcessorException {
        AdminMessage res = ProcessUtil.createAdminMessage(request);
        AdminMessage req = MessageConvertor.convertAdminMessage(request, res);
        ResourcePool rp = ResourceManager.getAllResourceList();
        String listName = (String)req.getContent();
        PBCRAWCertProxy query = new PBCRAWCertProxy();
        query.setType(2001);
        query.addCondition("name", (Object)listName);
        int successCount = 0;
        int errorCount = 0;
        this.certList = (PBCRAWCertResourceList)rp.getResourceList((ResourceListFilter)query);
        this.certList.log("AdminBatchUploadCertProcessor deal BPSODT0601.dat file start...");
        if (this.certList == null) {
            res.setResult(-100280);
            res.setErrMsg("Can not find resource list by name:" + listName);
            return res;
        }
        PartnerCertsFile pcf = null;
        try {
            pcf = PartnerCertsFile.parse((String)"/tmp/IBPSODT0601.dat", (Logger)this.certList.getLogger());
        }
        catch (Exception e) {
            ConsoleLogger.logException((Throwable)e);
            res.setResult(-100051);
            res.setErrMsg("Parse IBPSODT0601 file failed " + e.toString());
            this.certList.log("AdminBatchUploadCertProcessor Parse IBPSODT0601 file failed " + e.toString());
            return res;
        }
        if (pcf == null) {
            res.setResult(-100051);
            res.setErrMsg("Parse IBPSODT0601 failed, file illegal content");
            this.certList.log("AdminBatchUploadCertProcessor Parse IBPSODT0601 failed, file illegal content");
            return res;
        }
        query.setType(3002);
        int i = 0;
        int size = pcf.size();
        while (i < size) {
            block16: {
                PartnerCert pc = pcf.get(i);
                this.certList.log("Check cert " + pc.getSubject());
                X509Certificate cert = null;
                try {
                    cert = this.getCert(pc.getDetached());
                }
                catch (Exception e) {
                    ConsoleLogger.logException((Throwable)e);
                    this.certList.log("AdminBatchUploadCertProcessor Parse certificate " + pc.getSubject() + " from DgtSgntr failed:" + e.toString());
                    ++errorCount;
                    break block16;
                }
                if (cert == null) {
                    this.certList.log("AdminBatchUploadCertProcessor Parse certificate " + pc.getSubject() + " from DgtSgntr failed: No sign cert in DgtSgntr");
                    ++errorCount;
                } else {
                    this.certList.log("Get certificate " + cert.getSubjectDN().getName());
                    if (!PBCUtil.subjectEquals((String)cert.getSubjectDN().getName(), (String)pc.getSubject())) {
                        this.certList.log("Subject of certificate:" + cert.getSubjectDN().getName() + " is not the subject shown in IBPSODT0601.dat:" + pc.getSubject());
                        ++errorCount;
                    } else {
                        try {
                            PBCRAWCert pcert = new PBCRAWCert();
                            pcert.setCert(cert);
                            pcert.setPath(this.certList.getPath());
                            query.addCondition("resource", (Object)pcert);
                            if (this.certList.setResource((ResourceSetter)query)) {
                                pcert.save();
                                ++successCount;
                            }
                        }
                        catch (Exception e) {
                            ++errorCount;
                            ConsoleLogger.logException((Throwable)e);
                        }
                    }
                }
            }
            ++i;
        }
        try {
            this.certList.saveDetail();
            this.certList.log("AdminBatchUploadCertProcessor bankinfo.conf saved.");
        }
        catch (Exception e) {
            ConsoleLogger.logException((Throwable)e);
            res.setResult(-100221);
            res.setErrMsg("Save bank info failed");
            this.certList.log("AdminBatchUploadCertProcessor Save bank info failed");
            return res;
        }
        this.certList.log("AdminBatchUploadCertProcessor upload IBPSODT0601 file finished");
        this.certList.log("\u4e0a\u4f20\u603b\u6570:" + pcf.size() + "&nbsp;&nbsp;&nbsp;\u6210\u529f\u6570:" + successCount + "&nbsp;&nbsp;&nbsp;\u5931\u8d25\u6570:" + errorCount);
        return res;
    }

    private X509Certificate getCert(byte[] detached) throws Exception {
        PKCS7SignedDataFX p7 = new PKCS7SignedDataFX(detached);
        return p7.getSigningCertificate();
    }
}

