/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.base.processors;

import cn.com.infosec.netsign.base.AbstractMessage;
import cn.com.infosec.netsign.base.AdminMessage;
import cn.com.infosec.netsign.base.Processor;
import cn.com.infosec.netsign.base.processors.ProcessorException;
import cn.com.infosec.netsign.base.processors.util.FileUtil;
import cn.com.infosec.netsign.base.processors.util.MessageConvertor;
import cn.com.infosec.netsign.base.processors.util.ProcessUtil;
import cn.com.infosec.netsign.logger.ConsoleLogger;
import cn.com.infosec.netsign.pbc.PartnerBankInfo;
import cn.com.infosec.netsign.pbc.PartnerBankInfoFile;
import cn.com.infosec.netsign.resources.ResourceListFilter;
import cn.com.infosec.netsign.resources.ResourceManager;
import cn.com.infosec.netsign.resources.ResourcePool;
import cn.com.infosec.netsign.resources.ResourceSetter;
import cn.com.infosec.netsign.resources.rawcert.PBCRAWCert;
import cn.com.infosec.netsign.resources.rawcert.PBCRAWCertProxy;
import cn.com.infosec.netsign.resources.rawcert.PBCRAWCertResourceList;
import org.apache.log4j.Logger;

public class AdminBatchUploadBankNameProcessor
implements Processor {
    private PBCRAWCertResourceList certList = null;

    public AbstractMessage process(AbstractMessage request) throws ProcessorException {
        AdminMessage res = ProcessUtil.createAdminMessage(request);
        AdminMessage req = MessageConvertor.convertAdminMessage(request, res);
        ResourcePool rp = ResourceManager.getAllResourceList();
        String listName = (String)req.getContent();
        PBCRAWCertProxy query = new PBCRAWCertProxy();
        query.setType(2001);
        query.addCondition("name", (Object)listName);
        this.certList = (PBCRAWCertResourceList)rp.getResourceList((ResourceListFilter)query);
        int successCount = 0;
        int errorCount = 0;
        if (this.certList == null) {
            res.setResult(-100280);
            res.setErrMsg("Can not find resource list by name:" + listName);
            return res;
        }
        PartnerBankInfoFile pbif = null;
        try {
            pbif = PartnerBankInfoFile.parse((String)"/tmp/IBPSODT0402.dat", (Logger)this.certList.getLogger());
        }
        catch (Exception e) {
            ConsoleLogger.logException((Throwable)e);
            res.setResult(-100051);
            res.setErrMsg("Parse pbc IBPSODT0402.dat file failed," + e.toString());
            this.certList.log("AdminBatchUploadBankNameProcessor Parse pbc IBPSODT0402.dat file failed," + e.toString());
            return res;
        }
        if (pbif == null) {
            res.setResult(-100051);
            res.setErrMsg("Parse pbc IBPSODT0402.dat file failed, file content illegally");
            this.certList.log("AdminBatchUploadBankNameProcessor Parse pbc IBPSODT0402.dat file failed, file content illegally");
            return res;
        }
        query.setType(3002);
        int i = 0;
        int size = pbif.size();
        while (i < size) {
            PartnerBankInfo pbi = pbif.get(i);
            String bankName = "";
            String bankCode = "";
            bankName = pbi.getBankName();
            bankCode = pbi.getBankCode();
            if (bankName == null || bankName.equals("")) {
                ++errorCount;
            } else if (bankCode == null || bankCode.equals("")) {
                ++errorCount;
            } else {
                PBCRAWCert cert = new PBCRAWCert();
                cert.setBankName(bankName);
                cert.setBankCode(bankCode);
                cert.setPath(this.certList.getPath());
                query.addCondition("resource", (Object)cert);
                try {
                    this.certList.setResource((ResourceSetter)query);
                    ++successCount;
                }
                catch (Exception e) {
                    ++errorCount;
                    ConsoleLogger.logException((Throwable)e);
                }
            }
            ++i;
        }
        try {
            this.certList.saveDetail();
            this.certList.log("AdminBatchUploadBankNameProcessor detail.conf saved.");
        }
        catch (Exception e) {
            ConsoleLogger.logException((Throwable)e);
            res.setResult(-100221);
            res.setErrMsg("AdminBatchUploadBankNameProcessor Save bank info failed");
            this.certList.log("AdminBatchUploadBankNameProcessor Save bank info failed.");
            return res;
        }
        res.setContent(this.certList);
        FileUtil.writeLogToTemp("\u4e0a\u4f20\u603b\u6570:" + pbif.size() + "&nbsp;&nbsp;&nbsp;\u6210\u529f\u6570:" + successCount + "&nbsp;&nbsp;&nbsp;\u5931\u8d25\u6570:" + errorCount, "pbc402");
        return res;
    }
}

