/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.base.processors;

import cn.com.infosec.netsign.base.AbstractMessage;
import cn.com.infosec.netsign.base.AdminMessage;
import cn.com.infosec.netsign.base.ErrorInfoRes;
import cn.com.infosec.netsign.base.Processor;
import cn.com.infosec.netsign.base.processors.ProcessorException;
import cn.com.infosec.netsign.base.processors.util.MessageConvertor;
import cn.com.infosec.netsign.base.processors.util.ProcessUtil;
import cn.com.infosec.netsign.frame.config.DownloadCRLService;
import cn.com.infosec.netsign.logger.ConsoleLogger;
import cn.com.infosec.netsign.manager.DCServerManager;
import cn.com.infosec.netsign.manager.LogManager;

public class AddNewDCServerProcessor
implements Processor {
    private int id = 4;

    public AbstractMessage process(AbstractMessage request) throws ProcessorException {
        AdminMessage res = ProcessUtil.createAdminMessage(request);
        AdminMessage req = MessageConvertor.convertAdminMessage(request, res);
        if (res.getResult() < 0) {
            LogManager.getDebugLogger().Log(String.valueOf(this.id) + " " + res.getProcessor() + ": " + res.getResult() + ", " + res.getErrMsg());
            LogManager.getAccessLogger().Log(String.valueOf(this.id) + " AddDCServer failed");
            return res;
        }
        DownloadCRLService config = null;
        try {
            config = (DownloadCRLService)req.getContent();
        }
        catch (ClassCastException clsEx) {
            ConsoleLogger.logException((Throwable)clsEx);
            res.setResult(-100010);
            res.setErrMsg(String.valueOf(ErrorInfoRes.getErrorInfo(-100010)) + ": " + req.getContent().toString());
            LogManager.getDebugLogger().Log(String.valueOf(this.id) + " " + res.getProcessor() + ": " + req.getString());
            LogManager.getDebugLogger().Log(String.valueOf(this.id) + " " + res.getProcessor() + ": " + res.getResult() + ", " + res.getErrMsg());
            LogManager.getAccessLogger().Log(String.valueOf(this.id) + " AddDCServer failed");
            return res;
        }
        try {
            DCServerManager.addServer(config);
        }
        catch (Throwable dcEx) {
            ConsoleLogger.logException((Throwable)dcEx);
            res.setResult(-100028);
            res.setErrMsg(String.valueOf(ErrorInfoRes.getErrorInfo(-100028)) + ": " + config.getName() + " " + dcEx.getMessage());
            LogManager.getDebugLogger().Log(String.valueOf(this.id) + " " + res.getProcessor() + ": " + req.getString());
            LogManager.getDebugLogger().Log(String.valueOf(this.id) + " " + res.getProcessor() + ": " + res.getResult() + ", " + res.getErrMsg());
            LogManager.getAccessLogger().Log(String.valueOf(this.id) + " AddDCServer failed");
            return res;
        }
        LogManager.getAccessLogger().Log(String.valueOf(this.id) + " AddDCServer success");
        return res;
    }
}

