/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.base.processors;

import cn.com.infosec.isfw2.sfw.Request;
import cn.com.infosec.isfw2.sfw.Response;
import cn.com.infosec.netsign.base.NSMessage;
import cn.com.infosec.netsign.base.PDFImage;
import cn.com.infosec.netsign.base.PDFPosition;
import cn.com.infosec.netsign.base.PDFRequest;
import cn.com.infosec.netsign.base.channels.ServerChannel;
import cn.com.infosec.netsign.base.processors.util.PDFUtil;
import cn.com.infosec.netsign.base.processors.util.ProcessUtil;
import cn.com.infosec.netsign.isfwimpl.NetSignProcessor;
import cn.com.infosec.netsign.isfwimpl.NetSignRequest;
import cn.com.infosec.netsign.isfwimpl.NetSignResponse;
import cn.com.infosec.netsign.logger.ConsoleLogger;
import com.itextpdf.text.pdf.PdfStamper;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;

public class AddImage2PDFProcessor
implements NetSignProcessor {
    private ServerChannel channel;

    public AddImage2PDFProcessor() {
    }

    public void setChannel(ServerChannel channel) {
        if (this.channel != channel) {
            this.channel = channel;
        }
    }

    public AddImage2PDFProcessor(ServerChannel channel) {
        this.channel = channel;
    }

    public Response process(Request req) {
        NetSignRequest nsreq = (NetSignRequest)req;
        NSMessage request = nsreq.getNSMessage();
        String failedMsg = String.valueOf(this.channel.getId()) + " " + request.getAddress() + " AddImage2PDF failed:";
        NSMessage res = ProcessUtil.createNSMessage(request);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] plainText = request.getPlainText();
        plainText = ProcessUtil.disassemble(plainText, this.channel.isCryptoCommunicate(), this.channel.getCryptoUtil(), request, res);
        if (res.getResult() < 0) {
            ProcessUtil.log(this.channel.getDebugLogger(), this.channel.getId(), request, res);
            ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(failedMsg) + res.getResult(), this.channel.getLogLevel(), nsreq, res);
            return NetSignResponse.createNetSignResponse(res, nsreq);
        }
        byte[] passwd = request.getPdfpasswd();
        try {
            ArrayList pdfImages = request.getPdfImages();
            if (pdfImages != null && pdfImages.size() > 0) {
                PdfStamper stamp = PDFUtil.generatePdfStamper(plainText, passwd, out);
                int i = 0;
                int length = pdfImages.size();
                while (i < length) {
                    PDFRequest prq = (PDFRequest)pdfImages.get(i);
                    PDFPosition pdfPos_i = prq.getPdfPos();
                    PDFImage pdfImg = (PDFImage)prq.getPdfObj();
                    PDFUtil.addImg2PDF(stamp, pdfImg, pdfPos_i);
                    ++i;
                }
                plainText = PDFUtil.closePdf(stamp, out);
            }
        }
        catch (Exception e) {
            ConsoleLogger.logException((Throwable)e);
            ProcessUtil.throwDetailException(e, res);
            ProcessUtil.log(this.channel.getDebugLogger(), this.channel.getId(), request, res);
            ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(failedMsg) + res.getResult(), this.channel.getLogLevel(), nsreq, res);
            return NetSignResponse.createNetSignResponse(res, nsreq);
        }
        res.setCryptoText(plainText);
        ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(this.channel.getId()) + " " + request.getAddress() + " AddImage2PDF success", this.channel.getLogLevel(), nsreq, res);
        return NetSignResponse.createNetSignResponse(res, nsreq);
    }
}

