/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.base;

import java.math.BigInteger;

public class PDFVerifyResult {
    private String fieldName;
    private int returnCode = 1;
    private String issuerSubject;
    private BigInteger sn;
    private String subject;
    private long notBefore;
    private long notAfter;
    private String b64cert;

    public String getB64cert() {
        return this.b64cert;
    }

    public void setB64cert(String b64cert) {
        this.b64cert = b64cert;
    }

    public static PDFVerifyResult parse(String str) {
        PDFVerifyResult pvr = new PDFVerifyResult();
        String[] pieces = str.split(";");
        if (!pieces[0].equals(" ")) {
            pvr.setFieldName(pieces[0]);
        }
        if (!pieces[1].equals(" ")) {
            pvr.setReturnCode(Integer.parseInt(pieces[1]));
        }
        if (!pieces[2].equals(" ")) {
            pvr.setIssuerSubject(pieces[2]);
        }
        if (!pieces[3].equals(" ")) {
            pvr.setSubject(pieces[3]);
        }
        try {
            BigInteger bi = new BigInteger(pieces[4], 16);
            pvr.setSn(bi);
        }
        catch (Exception exception) {
            // empty catch block
        }
        pvr.setNotBefore(Long.parseLong(pieces[5]));
        pvr.setNotAfter(Long.parseLong(pieces[6]));
        if (!pieces[7].equals(" ")) {
            pvr.setB64cert(pieces[7]);
        }
        return pvr;
    }

    public String toString() {
        String s = ";";
        StringBuffer buf = new StringBuffer();
        if (this.fieldName != null) {
            buf.append(this.fieldName);
        } else {
            buf.append(" ");
        }
        buf.append(s);
        buf.append(this.returnCode);
        buf.append(s);
        if (this.issuerSubject != null) {
            buf.append(this.issuerSubject);
        } else {
            buf.append(" ");
        }
        buf.append(s);
        if (this.subject != null) {
            buf.append(this.subject);
        } else {
            buf.append(" ");
        }
        buf.append(s);
        if (this.sn != null) {
            buf.append(this.sn.toString(16));
        } else {
            buf.append("0");
        }
        buf.append(s);
        buf.append(this.notBefore).append(s).append(this.notAfter).append(s);
        if (this.b64cert != null) {
            buf.append(this.b64cert);
        } else {
            buf.append(" ");
        }
        return buf.toString();
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    public void setReturnCode(int returnCode) {
        this.returnCode = returnCode;
    }

    public String getIssuerSubject() {
        return this.issuerSubject;
    }

    public void setIssuerSubject(String issuerSubject) {
        this.issuerSubject = issuerSubject;
    }

    public BigInteger getSn() {
        return this.sn != null ? this.sn : BigInteger.ZERO;
    }

    public void setSn(BigInteger sn) {
        this.sn = sn;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public long getNotBefore() {
        return this.notBefore;
    }

    public void setNotBefore(long notBefore) {
        this.notBefore = notBefore;
    }

    public long getNotAfter() {
        return this.notAfter;
    }

    public void setNotAfter(long notAfter) {
        this.notAfter = notAfter;
    }
}

