/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.base;

import cn.com.infosec.netsign.base.PDFBookmarkPos;
import cn.com.infosec.netsign.base.PDFPosition;
import cn.com.infosec.netsign.base.PDFTextPos;
import cn.com.infosec.netsign.base.util.MyTextRenderListener;
import cn.com.infosec.netsign.logger.ConsoleLogger;
import com.itextpdf.text.pdf.IntHashtable;
import com.itextpdf.text.pdf.PRTokeniser;
import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.SimpleBookmark;
import com.itextpdf.text.pdf.parser.PdfContentStreamProcessor;
import com.itextpdf.text.pdf.parser.RenderListener;
import java.awt.Point;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class PDFPositionParser {
    public static ArrayList parse(PDFPosition pos, PdfReader reader) {
        ArrayList<PDFPosition> list = new ArrayList<PDFPosition>();
        switch (pos.getType()) {
            case 2: {
                PDFPositionParser.parseBookMark(list, reader, pos.getBookmark(), 0, 0, 0);
                break;
            }
            case 3: {
                PDFPositionParser.parseText(list, reader, pos.getText(), pos.getWidth(), pos.getHeight(), pos.getRelativePos());
                break;
            }
            case 1: {
                list.add(pos);
            }
        }
        return list;
    }

    private static void parseText(ArrayList textPosList, PdfReader reader, String text, int width, int height, int relativePos) {
        PDFTextPos textPos = new PDFTextPos();
        String encodeText = PDFPositionParser.encodeUCS2(text);
        int numPages = reader.getNumberOfPages();
        int i = 1;
        boolean bool = false;
        while (i <= numPages) {
            bool = PDFPositionParser.locateCoordinateOfText(reader, i, encodeText, textPos);
            if (bool) break;
            ++i;
        }
        if (!bool) {
            try {
                throw new Exception("There is NOT a text with coordinates named  ' " + text + " ' ", new Throwable("No found such text with coordinates in.this.pdf.document"));
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        switch (relativePos) {
            case 1: {
                textPos.setY1(textPos.getY1() - height / 2);
                textPos.setX2(textPos.getX1() + width);
                textPos.setY2(textPos.getY1() + height);
                break;
            }
            case 2: {
                textPos.setY1(textPos.getY1() - height);
                textPos.setX2(textPos.getX1() + width);
                textPos.setY2(textPos.getY1() + height);
                break;
            }
            case 3: {
                textPos.setX1(textPos.getX1() - width / 2);
                textPos.setY1(textPos.getY1() - height);
                textPos.setX2(textPos.getX1() + width);
                textPos.setY2(textPos.getY1() + height);
                break;
            }
            case 4: {
                textPos.setX1(textPos.getX1() - width);
                textPos.setY1(textPos.getY1() - height);
                textPos.setX2(textPos.getX1() + width);
                textPos.setY2(textPos.getY1() + height);
                break;
            }
            case 5: {
                textPos.setX1(textPos.getX1() - width);
                textPos.setY1(textPos.getY1() - height / 2);
                textPos.setX2(textPos.getX1() + width);
                textPos.setY2(textPos.getY1() + height);
                break;
            }
            case 6: {
                textPos.setX1(textPos.getX1() - width);
                textPos.setX2(textPos.getX1() + width);
                textPos.setY2(textPos.getY1() + height);
                break;
            }
            case 7: {
                textPos.setX1(textPos.getX1() - width / 2);
                textPos.setX2(textPos.getX1() + width);
                textPos.setY2(textPos.getY1() + height);
                break;
            }
            case 8: {
                textPos.setX2(textPos.getX1() + width);
                textPos.setY2(textPos.getY1() + height);
                break;
            }
            case 9: {
                textPos.setX1(textPos.getX1() - width / 2);
                textPos.setY1(textPos.getY1() - height / 2);
                textPos.setX2(textPos.getX1() + width);
                textPos.setY2(textPos.getY1() + height);
            }
        }
        textPosList.add(textPos);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean locateCoordinateOfText(PdfReader reader, int page, String text, PDFTextPos textPos) {
        byte[] streamBytes = null;
        try {
            streamBytes = reader.getPageContent(page);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        PRTokeniser tokenizer = new PRTokeniser(streamBytes);
        ArrayList points = new ArrayList();
        int w_Order = 0;
        int w_Page = 0;
        int w_X = 0;
        int w_Y = 0;
        boolean found = false;
        try {
            block7: {
                while (tokenizer.nextToken()) {
                    if (found) {
                        return false;
                    }
                    if (tokenizer.getTokenType() != PRTokeniser.TokenType.STRING) continue;
                    ++w_Order;
                    String str = tokenizer.getStringValue();
                    String str_needToTrans = PDFPositionParser.stringToHex(str);
                    if (!str_needToTrans.equalsIgnoreCase(text)) {
                        continue;
                    }
                    break block7;
                }
                return false;
            }
            MyTextRenderListener listener = new MyTextRenderListener(reader);
            PdfContentStreamProcessor processor = new PdfContentStreamProcessor((RenderListener)listener);
            PdfDictionary pageDic = reader.getPageN(page);
            PdfDictionary resourcesDic = pageDic.getAsDict(PdfName.RESOURCES);
            processor.processContent(streamBytes, resourcesDic);
            points = listener.coordinateOfAllText();
            w_Page = page;
            w_X = (int)((Point)points.get(w_Order - 1)).getX();
            w_Y = (int)((Point)points.get(w_Order - 1)).getY();
            found = true;
            textPos.setPage(page);
            textPos.setX1(w_X);
            textPos.setY1(w_Y);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    private static String stringToHex(String str) {
        char[] strChar = str.toCharArray();
        StringBuilder str_needtoTrans = new StringBuilder();
        int j = 0;
        while (j < strChar.length) {
            str_needtoTrans.append(Integer.toString((strChar[j] & 0xFF) + 256, 16).substring(1));
            ++j;
        }
        return str_needtoTrans.toString();
    }

    private String decodeUCS2(String src) {
        byte[] bytes = new byte[src.length() / 2];
        int i = 0;
        while (i < src.length()) {
            bytes[i / 2] = (byte)Integer.parseInt(src.substring(i, i + 2), 16);
            i += 2;
        }
        String reValue = null;
        try {
            reValue = new String(bytes, "UTF-16BE");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return reValue;
    }

    static String encodeUCS2(String src) {
        byte[] bytes = null;
        try {
            bytes = src.getBytes("UTF-16BE");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        StringBuffer reValue = new StringBuffer();
        StringBuffer tem = new StringBuffer();
        int i = 0;
        while (i < bytes.length) {
            tem.delete(0, tem.length());
            tem.append(Integer.toHexString(bytes[i] & 0xFF));
            if (tem.length() == 1) {
                tem.insert(0, '0');
            }
            reValue.append(tem);
            ++i;
        }
        return reValue.toString().toUpperCase();
    }

    private static void parseBookMark(ArrayList bookmarkPosList, PdfReader reader, String bookmark, int width, int height, int relativaPos) {
        List list = SimpleBookmark.getBookmark((PdfReader)reader);
        try {
            PDFPositionParser.findBookmark(reader, list, bookmark, bookmarkPosList);
        }
        catch (Exception e) {
            e.printStackTrace();
            ConsoleLogger.logException((Throwable)new Exception("No found such bookmark in.this.pdf.document"), (String)("There is NOT a bookmark named  ' " + bookmark + " ' "));
        }
    }

    private static void findBookmark(PdfReader reader, List bookmarkList, String bookmark, ArrayList bookmarkPosList) throws Exception {
        boolean isFound = false;
        Iterator i = bookmarkList.iterator();
        while (i.hasNext()) {
            isFound = PDFPositionParser.locateBookmark(reader, (HashMap)i.next(), bookmark, bookmarkPosList);
            if (isFound) break;
        }
        if (!isFound) {
            throw new Exception();
        }
    }

    private static boolean locateBookmark(PdfReader reader, HashMap outlines, String bookmark, ArrayList bookmarkPosList) throws Exception {
        if (outlines.get("Title").equals(bookmark)) {
            if (outlines.get("Page") != null) {
                String dest = outlines.get("Page").toString();
                String[] dests = dest.split(" ");
                if (dests[1].equalsIgnoreCase("Fit")) {
                    PDFPositionParser.getCoordinate(reader, dests, 1, bookmarkPosList);
                } else if (dests[1].equalsIgnoreCase("FitR")) {
                    PDFPositionParser.getCoordinate(reader, dests, 2, bookmarkPosList);
                } else if (dests[1].equalsIgnoreCase("XYZ")) {
                    PDFPositionParser.getCoordinate(reader, dests, 3, bookmarkPosList);
                } else if (dests[1].equalsIgnoreCase("FitV")) {
                    ArrayList kids = (ArrayList)outlines.get("Kids");
                    if (kids == null) {
                        return false;
                    }
                    Iterator i = kids.iterator();
                    while (i.hasNext()) {
                        outlines = (HashMap)i.next();
                        PDFPositionParser.locateBookmark(reader, outlines, outlines.get("Title").toString(), bookmarkPosList);
                    }
                } else {
                    ConsoleLogger.logException((Throwable)new Throwable("No found such bookmark suit to loacate in.this.pdf.document"), (String)"The bookmark be NOT suitable for position");
                }
            } else {
                HashMap map = reader.getNamedDestination();
                PdfObject dest = (PdfObject)map.get(outlines.get("Named"));
                IntHashtable pages = new IntHashtable();
                int numPages = reader.getNumberOfPages();
                int k = 1;
                while (k <= numPages) {
                    pages.put(reader.getPageOrigRef(k).getNumber(), k);
                    reader.releasePage(k);
                    ++k;
                }
                String destination = map.get(outlines.get("Named")).toString().replaceAll(",", "").replaceAll("/", "");
                String[] destination_split = destination.split(" ");
                String dest_temp = destination_split[0].substring(1);
                int page_objnum = Integer.parseInt(dest_temp);
                int page = pages.get(page_objnum);
                String destination_new = destination.replaceAll("[\\x00-\\x7F]*[R]", String.valueOf(page)).replaceAll("]", "");
                String[] split_dest_new = destination_new.split(" ");
                PDFPositionParser.getCoordinate(reader, split_dest_new, 3, bookmarkPosList);
            }
            return true;
        }
        return false;
    }

    private static void getCoordinate(PdfReader reader, String[] dests, int bookmarkType, ArrayList bookmarkPosList) {
        PDFBookmarkPos bookmarkPos = new PDFBookmarkPos();
        if (bookmarkType == 2) {
            bookmarkPos.setPage(Integer.parseInt(dests[0]));
            bookmarkPos.setX1(Integer.parseInt(dests[2]));
            bookmarkPos.setY1(Integer.parseInt(dests[3]));
            bookmarkPos.setX2(Integer.parseInt(dests[4]));
            bookmarkPos.setY2(Integer.parseInt(dests[5]));
        } else if (bookmarkType == 3) {
            bookmarkPos.setPage(Integer.parseInt(dests[0]));
            bookmarkPos.setX1(Integer.parseInt(dests[2]));
            bookmarkPos.setY2(Integer.parseInt(dests[3]));
            PdfDictionary p = reader.getPageN(bookmarkPos.getPage());
            PdfObject po = p.get(new PdfName("MediaBox"));
            PdfArray pa = (PdfArray)po;
            bookmarkPos.setX2(pa.getAsNumber(pa.size() - 2).intValue());
            bookmarkPos.setY1(0);
        } else if (bookmarkType == 1) {
            bookmarkPos.setPage(Integer.parseInt(dests[0]));
            bookmarkPos.setX1(0);
            bookmarkPos.setY1(0);
            PdfDictionary p = reader.getPageN(bookmarkPos.getPage());
            PdfObject po = p.get(new PdfName("MediaBox"));
            PdfArray pa = (PdfArray)po;
            bookmarkPos.setX2(pa.getAsNumber(pa.size() - 2).intValue());
            bookmarkPos.setY2(pa.getAsNumber(pa.size() - 1).intValue());
        }
        bookmarkPosList.add(bookmarkPos);
    }
}

