/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.base;

import cn.com.infosec.netsign.base.PDFBookmarkPos;
import cn.com.infosec.netsign.base.PDFDirectPos;
import cn.com.infosec.netsign.base.PDFImage;
import cn.com.infosec.netsign.base.PDFPosition;
import cn.com.infosec.netsign.base.PDFRequest;
import cn.com.infosec.netsign.base.PDFSignElements;
import cn.com.infosec.netsign.base.PDFTextPos;
import java.util.ArrayList;

public class PDFParameters {
    private byte[] pdf = null;
    private byte[] pdfPassword = null;
    private ArrayList pdfRectangles = null;
    private ArrayList pdfImages = null;

    public ArrayList getRectangles() {
        return this.pdfRectangles;
    }

    public ArrayList getImages() {
        return this.pdfImages;
    }

    public void clearPdfRectangles() {
        if (this.pdfRectangles != null) {
            this.pdfRectangles = new ArrayList();
        }
    }

    public void clearPdfImages() {
        if (this.pdfImages != null) {
            this.pdfImages = new ArrayList();
        }
    }

    public void setPdf(byte[] pdf) {
        this.pdf = pdf;
    }

    public byte[] getPdf() {
        return this.pdf;
    }

    public byte[] getOwnerPassword() {
        return this.pdfPassword;
    }

    public void setOwnerPassword(byte[] passwd) {
        this.pdfPassword = passwd;
    }

    public void addImage(byte[] image, int width, int height, int pageNum, int x, int y) {
        if (image == null || image.length == 0) {
            return;
        }
        PDFImage pImg = new PDFImage();
        PDFDirectPos directPos = new PDFDirectPos();
        pImg.setImage(image);
        directPos.setType(1);
        directPos.setPage(pageNum);
        directPos.setX1(x);
        directPos.setY1(y);
        directPos.setX2(x + width);
        directPos.setY2(y + height);
        this.addRequest2AddImage(directPos, pImg);
    }

    public void addImageByBookmarkPos(byte[] image, String bookmark) {
        PDFImage pImg = new PDFImage();
        PDFBookmarkPos bookmarkPos = new PDFBookmarkPos();
        pImg.setImage(image);
        bookmarkPos.setType(2);
        bookmarkPos.setBookmark(bookmark);
        this.addRequest2AddImage(bookmarkPos, pImg);
    }

    public void addImageByTextpos(byte[] image, String text, int width, int height, int relativePos) {
        PDFImage pImg = new PDFImage();
        PDFTextPos textPos = new PDFTextPos();
        pImg.setImage(image);
        textPos.setType(3);
        textPos.setText(text);
        textPos.setWidth(width);
        textPos.setHeight(height);
        textPos.setRelativePos(relativePos);
        this.addRequest2AddImage(textPos, pImg);
    }

    public void addRectangle2Sign(int x1, int y1, int x2, int y2, int page, String fieldName, String stamp, String signSubject) {
        PDFSignElements pse = new PDFSignElements();
        PDFDirectPos directPos = new PDFDirectPos();
        directPos.setType(1);
        ((PDFPosition)directPos).setX1(x1);
        ((PDFPosition)directPos).setY1(y1);
        ((PDFPosition)directPos).setX2(x2);
        ((PDFPosition)directPos).setY2(y2);
        ((PDFPosition)directPos).setPage(page);
        pse.setFieldName(fieldName);
        pse.setStamp(stamp);
        pse.setSignSubject(signSubject);
        this.addRequest2Sign(directPos, pse);
    }

    public void addRectangleByBookmark2Sign(String bookmark, String fieldName, String stamp, String signSubject) {
        PDFSignElements pse = new PDFSignElements();
        PDFBookmarkPos bookmarkPos = new PDFBookmarkPos();
        bookmarkPos.setType(2);
        ((PDFPosition)bookmarkPos).setBookmark(bookmark);
        pse.setFieldName(fieldName);
        pse.setStamp(stamp);
        pse.setSignSubject(signSubject);
        this.addRequest2Sign(bookmarkPos, pse);
    }

    public void addRectangleByText2Sign(String text, int width, int height, int relativePos, String fieldName, String stamp, String signSubject) {
        PDFSignElements pse = new PDFSignElements();
        PDFTextPos textPos = new PDFTextPos();
        textPos.setType(3);
        ((PDFPosition)textPos).setText(text);
        ((PDFPosition)textPos).setRelativePos(relativePos);
        ((PDFPosition)textPos).setWidth(width);
        ((PDFPosition)textPos).setHeight(height);
        pse.setFieldName(fieldName);
        pse.setStamp(stamp);
        pse.setSignSubject(signSubject);
        this.addRequest2Sign(textPos, pse);
    }

    public void addSignature(String fieldName, String signSubject) {
        PDFSignElements pse = new PDFSignElements();
        PDFDirectPos directPos = new PDFDirectPos();
        directPos.setType(1);
        ((PDFPosition)directPos).setPage(1);
        pse.setFieldName(fieldName);
        pse.setSignSubject(signSubject);
        this.addRequest2Sign(directPos, pse);
    }

    public void addRequest2Sign(PDFPosition pdfPos, PDFSignElements pdfSign) {
        PDFRequest prq = new PDFRequest();
        prq.setPdfPos(pdfPos);
        prq.setPdfObj(pdfSign);
        if (this.pdfRectangles == null) {
            this.pdfRectangles = new ArrayList();
        }
        this.pdfRectangles.add(prq);
    }

    public void addRequest2AddImage(PDFPosition pdfPos, PDFImage pdfImage) {
        PDFRequest prq = new PDFRequest();
        prq.setPdfPos(pdfPos);
        prq.setPdfObj(pdfImage);
        if (this.pdfImages == null) {
            this.pdfImages = new ArrayList();
        }
        this.pdfImages.add(prq);
    }

    public void addRectangle2Sign(int x1, int y1, int x2, int y2, int page, String fieldName, String stamp, String signSubject, String digestAlg) {
        PDFSignElements pse = new PDFSignElements();
        PDFDirectPos directPos = new PDFDirectPos();
        directPos.setType(1);
        ((PDFPosition)directPos).setX1(x1);
        ((PDFPosition)directPos).setY1(y1);
        ((PDFPosition)directPos).setX2(x2);
        ((PDFPosition)directPos).setY2(y2);
        ((PDFPosition)directPos).setPage(page);
        pse.setFieldName(fieldName);
        pse.setStamp(stamp);
        pse.setSignSubject(signSubject);
        this.addRequest2Sign(directPos, pse, digestAlg);
    }

    public void addRectangleByBookmark2Sign(String bookmark, String fieldName, String stamp, String signSubject, String digestAlg) {
        PDFSignElements pse = new PDFSignElements();
        PDFBookmarkPos bookmarkPos = new PDFBookmarkPos();
        bookmarkPos.setType(2);
        ((PDFPosition)bookmarkPos).setBookmark(bookmark);
        pse.setFieldName(fieldName);
        pse.setStamp(stamp);
        pse.setSignSubject(signSubject);
        this.addRequest2Sign(bookmarkPos, pse, digestAlg);
    }

    public void addRectangleByText2Sign(String text, int width, int height, int relativePos, String fieldName, String stamp, String signSubject, String digestAlg) {
        PDFSignElements pse = new PDFSignElements();
        PDFTextPos textPos = new PDFTextPos();
        textPos.setType(3);
        ((PDFPosition)textPos).setText(text);
        ((PDFPosition)textPos).setRelativePos(relativePos);
        ((PDFPosition)textPos).setWidth(width);
        ((PDFPosition)textPos).setHeight(height);
        pse.setFieldName(fieldName);
        pse.setStamp(stamp);
        pse.setSignSubject(signSubject);
        this.addRequest2Sign(textPos, pse, digestAlg);
    }

    public void addRequest2Sign(PDFPosition pdfPos, PDFSignElements pdfSign, String digestAlg) {
        PDFRequest prq = new PDFRequest();
        prq.setPdfPos(pdfPos);
        prq.setPdfObj(pdfSign);
        prq.setPdfDigestAlg(digestAlg);
        if (this.pdfRectangles == null) {
            this.pdfRectangles = new ArrayList();
        }
        this.pdfRectangles.add(prq);
    }
}

