/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.base;

import cn.com.infosec.netsign.base.util.NetSignImpl;
import cn.com.infosec.netsign.logger.ConsoleLogger;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;

public class NetSignX509Certificate {
    private PublicKey pubk;
    private PrivateKey prik;
    private BigInteger sn;
    private Principal issuer;
    private String issuerStr;
    private Principal dn;
    private String subjectStr;
    private X509Certificate cert;
    private String keyLable;
    private long notBefore;
    private long notAfter;

    private NetSignX509Certificate(X509Certificate cert, PublicKey pubk, PrivateKey prik, String keyLable) {
        this.pubk = pubk;
        this.sn = cert.getSerialNumber();
        this.issuer = cert.getIssuerDN();
        this.issuerStr = this.issuer.getName();
        this.dn = cert.getSubjectDN();
        this.subjectStr = this.dn.getName();
        this.cert = cert;
        this.prik = prik;
        this.keyLable = keyLable;
        this.notBefore = cert.getNotBefore().getTime();
        this.notAfter = cert.getNotAfter().getTime();
    }

    public long getNotAfter() {
        return this.notAfter;
    }

    public long getNotBefore() {
        return this.notBefore;
    }

    public String getKeyLable() {
        return this.keyLable;
    }

    public PrivateKey getPrivateKey() {
        return this.prik;
    }

    public String getSubjectDNStr() {
        return this.subjectStr;
    }

    public String getIssuerDNStr() {
        return this.issuerStr;
    }

    public X509Certificate getCert() {
        return this.cert;
    }

    public Principal getSubjectDN() {
        return this.dn;
    }

    private void setPublicKey(PublicKey pubk) {
        this.pubk = pubk;
    }

    public PublicKey getPublicKey() {
        return this.pubk;
    }

    public BigInteger getSerialNumber() {
        return this.sn;
    }

    public Principal getIssuerDN() {
        return this.issuer;
    }

    public void checkValidity() throws CertificateNotYetValidException, CertificateExpiredException {
        this.cert.checkValidity();
    }

    public static NetSignX509Certificate getInstance(X509Certificate cert) {
        if (cert == null) {
            return null;
        }
        return new NetSignX509Certificate(cert, cert.getPublicKey(), null, null);
    }

    public static NetSignX509Certificate getInstance(X509Certificate cert, PrivateKey prik, String keyLable, String provider) throws Exception {
        if (provider.equals("DatechCrypto")) {
            return NetSignX509Certificate.generate4Datech(cert, keyLable);
        }
        return NetSignX509Certificate.generate(cert, prik, keyLable);
    }

    private static NetSignX509Certificate generate(X509Certificate cert, PrivateKey prik, String keylable) throws Exception {
        return new NetSignX509Certificate(cert, cert.getPublicKey(), prik, keylable);
    }

    private static NetSignX509Certificate generate4Infosec(X509Certificate cert) throws Exception {
        return new NetSignX509Certificate(cert, cert.getPublicKey(), null, null);
    }

    private static NetSignX509Certificate generate4Datech(X509Certificate cert, String keyLable) throws Exception {
        NetSignX509Certificate nscert = NetSignX509Certificate.generate4Infosec(cert);
        try {
            KeyPair kp = NetSignImpl.generateDatechKeyPair(keyLable);
            nscert.setPublicKey(kp.getPublic());
        }
        catch (Exception e) {
            ConsoleLogger.logException((Throwable)e);
        }
        return nscert;
    }

    public boolean equals(Object anObj) {
        if (anObj == null) {
            return false;
        }
        if (anObj instanceof NetSignX509Certificate) {
            NetSignX509Certificate nscert = (NetSignX509Certificate)anObj;
            if (this == nscert) {
                return true;
            }
            if (this.cert == null && nscert.cert != null) {
                return false;
            }
            if (this.cert != null && !this.cert.equals(nscert.cert)) {
                return false;
            }
            if (this.pubk == null && nscert.pubk != null) {
                return false;
            }
            return this.pubk == null || this.pubk.equals(nscert.pubk);
        }
        return false;
    }
}

