/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.base;

import cn.com.infosec.netsign.logger.ConsoleLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.Date;

public class NetSignInputStream {
    private InputStream in;
    private String fileName;
    private File file;
    private static Date now = new Date();
    private static SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");

    private NetSignInputStream() {
    }

    public static NetSignInputStream createNetSignInputStream(File file) {
        NetSignInputStream nsin = new NetSignInputStream();
        nsin.fileName = file.getName();
        return nsin;
    }

    public static NetSignInputStream createNetSignInputStream(InputStream in) {
        NetSignInputStream nsin = new NetSignInputStream();
        nsin.in = in;
        now.setTime(System.currentTimeMillis());
        SecureRandom random = new SecureRandom();
        byte[] bs = new byte[8];
        random.nextBytes(bs);
        nsin.fileName = String.valueOf(format.format(now)) + "_" + new BigInteger(bs).abs().toString(10);
        return nsin;
    }

    public InputStream getInputStream() {
        if (this.in == null && this.file != null) {
            try {
                this.in = new FileInputStream(this.file);
            }
            catch (Exception e) {
                ConsoleLogger.logException((Throwable)e);
            }
        }
        return this.in;
    }

    public String getFileName() {
        return this.fileName;
    }
}

