/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.base;

import cn.com.infosec.netsign.base.DownLoadCRLException;
import cn.com.infosec.netsign.base.NetSignX509CRL;
import cn.com.infosec.netsign.frame.config.ExtendedConfig;
import cn.com.infosec.netsign.logger.ConsoleLogger;
import java.io.File;
import java.security.cert.CertificateFactory;
import java.util.Date;
import java.util.Map;

public class CRLUpdater
implements Runnable {
    private Map crllist = null;
    private boolean shutdown = false;
    private int interval = 0;
    private String crlpath;
    private boolean useCRLDP = true;
    private CertificateFactory crlFact = null;
    private Thread catchCleaner;
    private Thread realTimeUpdate;
    private String LOAD_MODE;

    public CRLUpdater(Map crllist, String crlpath, int interval, boolean useCRLDP) {
        this.crllist = crllist;
        this.interval = interval;
        this.crlpath = crlpath;
        this.useCRLDP = useCRLDP;
        try {
            this.crlFact = CertificateFactory.getInstance("X.509", "INFOSEC");
        }
        catch (Exception e) {
            ConsoleLogger.logException((Throwable)e);
        }
        this.LOAD_MODE = useCRLDP ? ExtendedConfig.getCRLLoadMode() : "all";
        if (this.LOAD_MODE.equals("realtime")) {
            this.catchCleaner = new Thread(new CatchCleaner());
            this.catchCleaner.setName("crl_catch_cleaner_for_" + crlpath);
            this.catchCleaner.start();
        }
        if (this.LOAD_MODE.equals("all") && useCRLDP) {
            this.realTimeUpdate = new Thread(new crllistWatcher());
            this.realTimeUpdate.setName("crl_list_watcher_for_" + crlpath);
            this.realTimeUpdate.start();
        }
    }

    public NetSignX509CRL getCRL(String crldp) {
        if (!crldp.endsWith(".crl")) {
            crldp = String.valueOf(crldp) + ".crl";
        }
        NetSignX509CRL crl = (NetSignX509CRL)this.crllist.get(crldp);
        if (this.LOAD_MODE.equals("all")) {
            return crl;
        }
        if (crl != null) {
            if (crl.checkValidity()) {
                return crl;
            }
            if (System.currentTimeMillis() - crl.getLastCheckTime() <= ExtendedConfig.getReloadCRLInterval()) {
                return crl;
            }
            crl.setLastCheckTime(System.currentTimeMillis());
            File f = new File(String.valueOf(this.crlpath) + "/" + crldp);
            if (!f.exists()) {
                return crl;
            }
            if (!crl.isNewFile(f)) {
                return crl;
            }
            NetSignX509CRL tmp = this.loadCRL(f);
            if (tmp != null) {
                return tmp;
            }
            return crl;
        }
        File f = new File(String.valueOf(this.crlpath) + "/" + crldp);
        if (!f.exists()) {
            return null;
        }
        crl = this.loadCRL(f);
        if (crl != null) {
            return crl;
        }
        return null;
    }

    private synchronized NetSignX509CRL loadCRL(File crl) {
        NetSignX509CRL nscrl = (NetSignX509CRL)this.crllist.get(crl.getName());
        if (nscrl != null && nscrl.checkValidity()) {
            return nscrl;
        }
        try {
            if (nscrl == null) {
                nscrl = NetSignX509CRL.getInstance(crl, this.crlFact);
                if (nscrl != null) {
                    this.crllist.put(crl.getName(), nscrl);
                }
            } else if (nscrl.isNewFile(crl) && (nscrl = NetSignX509CRL.getInstance(crl, this.crlFact)) != null) {
                this.crllist.put(crl.getName(), nscrl);
            }
            return nscrl;
        }
        catch (Exception e) {
            ConsoleLogger.logException((Throwable)e, (String)("Load crl " + crl.getAbsolutePath() + " failed"));
            return null;
        }
    }

    public void shutdown() {
        this.shutdown = true;
    }

    public static void main(String[] args) {
    }

    public void run() {
        while (!this.shutdown) {
            long start = System.currentTimeMillis();
            try {
                this.updateCRLs();
            }
            catch (DownLoadCRLException e) {
                ConsoleLogger.logException((Throwable)e);
            }
            catch (Exception e) {
                ConsoleLogger.logException((Throwable)e);
            }
            long end = System.currentTimeMillis();
            long sleep = (long)this.interval - (end - start);
            sleep = sleep < 0L ? 0L : sleep;
            try {
                Thread.sleep(sleep);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.interval > 0) continue;
        }
    }

    protected void updateCRLs() throws DownLoadCRLException {
        File f = new File(this.crlpath);
        File[] ftmp = f.listFiles();
        if (ftmp != null) {
            ConsoleLogger.logStringForce((String)("Update crl files in " + f.getName() + " start...\nTotal files:" + ftmp.length));
            try {
                NetSignX509CRL netsignCRL = new NetSignX509CRL();
                long now = System.currentTimeMillis();
                long sumSN = 0L;
                int i = 0;
                while (i < ftmp.length) {
                    try {
                        if (this.useCRLDP) {
                            netsignCRL = this.loadCRL(ftmp[i]);
                            if (netsignCRL != null) {
                                sumSN += (long)netsignCRL.size();
                                this.crllist.put(ftmp[i].getName().toLowerCase(), netsignCRL);
                            }
                        } else {
                            netsignCRL.addCRL(ftmp[i], this.crlFact);
                        }
                        if ((i + 1) % 100 == 0) {
                            ConsoleLogger.logString((String)(String.valueOf(i) + " crl files loaded. Using " + (System.currentTimeMillis() - now) / 1000L + " seconds."));
                        }
                    }
                    catch (Exception ex) {
                        ConsoleLogger.logException((Throwable)ex, (String)("load crl " + ftmp[i].getName() + " failed."));
                    }
                    ++i;
                }
                if (!this.useCRLDP) {
                    netsignCRL.sort();
                    this.crllist.put("nocrldp", netsignCRL);
                    sumSN = netsignCRL.size();
                }
                ConsoleLogger.logStringForce((String)("Update crl files in " + f.getName() + " finished.\nTotal certificate revoked:" + sumSN));
            }
            catch (Exception e) {
                ConsoleLogger.logException((Throwable)e);
            }
        } else {
            ConsoleLogger.logStringForce((String)("Update crl files in " + f.getName() + " start...\nTotal files:" + 0));
        }
    }

    class CatchCleaner
    implements Runnable {
        CatchCleaner() {
        }

        public void run() {
            int[] cleanTimes = ExtendedConfig.getCrlCleanTimes();
            while (!CRLUpdater.this.shutdown) {
                try {
                    Thread.sleep(3600000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                int h = new Date().getHours();
                int i = 0;
                int length = cleanTimes.length;
                while (i < length) {
                    if (cleanTimes[i] == h) {
                        this.clear(0);
                    }
                    ++i;
                }
            }
        }

        private void clear(int times) {
            try {
                if (times < 100) {
                    CRLUpdater.this.crllist.clear();
                    ConsoleLogger.logString((String)("Clear crl catch " + CRLUpdater.this.crlpath + " finished."));
                } else {
                    ConsoleLogger.logString((String)("Clear crl catch " + CRLUpdater.this.crlpath + " failed."));
                }
            }
            catch (Throwable e) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.clear(times + 1);
            }
        }
    }

    class crllistWatcher
    implements Runnable {
        crllistWatcher() {
        }

        public void run() {
            while (!CRLUpdater.this.shutdown) {
                try {
                    Thread.sleep(1800000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                String[] keys = CRLUpdater.this.crllist.keySet().toArray(new String[0]);
                int i = 0;
                int length = keys.length;
                while (i < length) {
                    try {
                        NetSignX509CRL crl = (NetSignX509CRL)CRLUpdater.this.crllist.get(keys[i]);
                        if (!crl.checkValidity()) {
                            File f = new File(crl.getFileName());
                            CRLUpdater.this.loadCRL(f);
                        }
                    }
                    catch (Exception e) {
                        ConsoleLogger.logException((Throwable)e);
                    }
                    ++i;
                }
            }
        }
    }
}

