/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.web;

import com.fr.base.FRContext;
import com.fr.base.TemplateUtils;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import com.fr.js.ChartHyperlink;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.util.HashMap;

public abstract class ChartHyperRelateLink
extends ChartHyperlink {
    private static final long serialVersionUID = -3703142761449130123L;
    private String relateCCName;

    public abstract boolean isRealtedCell();

    public boolean isRealeted() {
        return true;
    }

    public void setRelateCCName(String string) {
        this.relateCCName = string;
    }

    public String getRelateCCName() {
        return this.relateCCName;
    }

    public String getChartOpCmd() {
        return "relate_chart";
    }

    protected String actionJS(Repository repository) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string = String.format("%s__%s__", this.isRealtedCell() ? "Cells" : "Float", this.getRelateCCName());
        hashMap.put("chartID", string);
        try {
            hashMap.put("para", this.createParaJSON(repository).toString());
        }
        catch (Exception exception) {
            FRLogger.getLogger().error("Error in Relate Chart Para");
        }
        try {
            return TemplateUtils.renderParameter4Tpl((String)TemplateUtils.readTemplate2String((String)"/com/fr/chart/web/chartRelatelinkJS.tpl", (String)"UTF-8"), hashMap);
        }
        catch (Exception exception) {
            FRLogger.getLogger().error("Error in HyperlinkJS.");
            return "";
        }
    }

    public JSONObject createJSONObject(Repository repository) throws JSONException {
        JSONObject jSONObject = super.createJSONObject(repository);
        jSONObject.put("isCell", this.isRealtedCell());
        jSONObject.put("relateName", (Object)this.getRelateCCName());
        return jSONObject;
    }

    protected String getHyperlinkType() {
        return "chartRelate";
    }

    protected JSONObject createPara(Repository repository) throws JSONException {
        JSONObject jSONObject = JSONObject.create();
        try {
            this.putExtendParameters(repository, jSONObject, false);
            this.para2JSON(jSONObject, false);
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage());
        }
        return jSONObject;
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = null;
            if ("realateName".equals(xMLableReader.getTagName())) {
                this.setRelateCCName(xMLableReader.getAttrAsString("realateValue", ""));
            } else if ("RelatedChart".equals(xMLableReader.getTagName()) && ((string = xMLableReader.getAttrAsString("", null)) != null || (string = xMLableReader.getAttrAsString("", null)) != null)) {
                this.setRelateCCName(string);
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("JavaScript").attr("class", ((Object)((Object)this)).getClass().getName());
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("realateName").attr("realateValue", this.relateCCName).end();
        xMLPrintWriter.end();
    }

    public boolean equals(Object object) {
        return object instanceof ChartHyperRelateLink && super.equals(object) && ComparatorUtils.equals((String)((ChartHyperRelateLink)((Object)object)).relateCCName, (String)this.relateCCName);
    }
}

