/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.base.DoubleDimension2D;
import com.fr.chart.base.AttrContents;
import com.fr.chart.base.ChartBaseUtils;
import com.fr.chart.base.GlyphUtils;
import com.fr.chart.base.TextAttr;
import com.fr.chart.chartglyph.TextGlyph;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;

public class TitleGlyph
extends TextGlyph {
    public static final double GAP = 4.0;
    private static final long serialVersionUID = 3091140904198337958L;
    private static final double MAX_TITLE_HEIGHT_PERCENT = 0.2;

    public TitleGlyph(String string, TextAttr textAttr) {
        super(string, textAttr);
    }

    public TitleGlyph() {
    }

    public void layoutTitleAndRefreshChartBounds(Rectangle2D rectangle2D, double d, double d2, int n) {
        Dimension2D dimension2D = this.preferredDimension(n, rectangle2D.getWidth(), rectangle2D.getHeight());
        double d3 = 0.0;
        d3 = this.getPosition() == 2 ? rectangle2D.getX() : (this.getPosition() == 4 ? rectangle2D.getX() + rectangle2D.getWidth() - dimension2D.getWidth() : rectangle2D.getX() + (rectangle2D.getWidth() - dimension2D.getWidth()) / 2.0);
        Rectangle2D.Double double_ = new Rectangle2D.Double(d3, rectangle2D.getY(), dimension2D.getWidth(), dimension2D.getHeight());
        this.setBounds(ChartBaseUtils.rectangle2RoundRectangle((Rectangle2D)double_, this.isRoundBorder()));
        rectangle2D.setRect(rectangle2D.getX(), rectangle2D.getY() + dimension2D.getHeight() + d, rectangle2D.getWidth(), rectangle2D.getHeight() - dimension2D.getHeight() - d2);
    }

    public Dimension2D preferredDimension(int n, double d, double d2) {
        String string = this.dealStringAutoWrap(this.text, this.textAttr, n, d - 8.0);
        Dimension2D dimension2D = GlyphUtils.calculateTextDimensionWithNoRotation(string, this.textAttr, n);
        return new DoubleDimension2D(Math.min(dimension2D.getWidth() + 8.0, d), Math.min(dimension2D.getHeight() + 8.0, d2 * 0.2));
    }

    public void draw(Graphics graphics, int n) {
        if (this.getBounds() == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Shape shape = graphics2D.getClip();
        graphics2D.translate(this.getBounds().getX(), this.getBounds().getY());
        this.drawBackground(graphics2D, n);
        graphics2D.clip(new Rectangle2D.Double(0.0, 0.0, this.getBounds().getWidth(), this.getBounds().getHeight() - 4.0));
        this.drawText(graphics2D, n);
        graphics2D.setClip(shape);
        graphics2D.translate(-this.getBounds().getX(), -this.getBounds().getY());
    }

    protected void drawText(Graphics2D graphics2D, int n) {
        Rectangle2D rectangle2D = this.getTextBoundsWithOutGap(this.getBounds());
        if (rectangle2D != null) {
            String string = this.dealStringAutoWrap(this.text, this.textAttr, n, rectangle2D.getWidth());
            String string2 = GlyphUtils.changeAllReline2Normal(string);
            String[] stringArray = string2.split(AttrContents.RelineSeparation);
            double d = stringArray.length > 0 ? GlyphUtils.calculateTextDimensionWithNoRotation(stringArray[0], this.textAttr, n).getHeight() : 0.0;
            int n2 = stringArray.length;
            for (int i = 0; i < n2; ++i) {
                Dimension2D dimension2D = GlyphUtils.calculateTextDimensionWithRotation(stringArray[i], this.textAttr, n);
                double d2 = this.getHorizontalLabelX(rectangle2D, dimension2D);
                double d3 = 4.0 + d * (double)i;
                Rectangle2D.Double double_ = new Rectangle2D.Double(d2, d3, dimension2D.getWidth(), dimension2D.getHeight());
                GlyphUtils.drawStrings(graphics2D, stringArray[i], this.textAttr, double_, n);
            }
        }
    }

    protected String dealStringAutoWrap(String string, TextAttr textAttr, int n, double d) {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            stringBuffer2.append(c);
            Dimension2D dimension2D = GlyphUtils.calculateTextDimensionWithNoRotation(stringBuffer2.toString(), textAttr, n);
            if (!(dimension2D.getWidth() > d) || c == '\\') continue;
            stringBuffer.append(stringBuffer2.substring(0, stringBuffer2.length() - 1) + "\n");
            stringBuffer2.delete(0, stringBuffer2.length() - 1);
        }
        stringBuffer.append(stringBuffer2);
        return stringBuffer.toString();
    }

    protected double getHorizontalLabelX(Rectangle2D rectangle2D, Dimension2D dimension2D) {
        return super.getHorizontalLabelX(rectangle2D, dimension2D) + 4.0;
    }

    private Rectangle2D getTextBoundsWithOutGap(Rectangle2D rectangle2D) {
        if (this.notEnoughBounds4Text(rectangle2D)) {
            return null;
        }
        return new Rectangle2D.Double(rectangle2D.getX() + 4.0, rectangle2D.getY() + 4.0, rectangle2D.getWidth() - 8.0, rectangle2D.getHeight() - 8.0);
    }

    private boolean notEnoughBounds4Text(Rectangle2D rectangle2D) {
        return rectangle2D == null || Math.abs(rectangle2D.getWidth()) < Math.abs(4.0) * 2.0 || Math.abs(rectangle2D.getHeight()) < Math.abs(4.0) * 2.0;
    }
}

