/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartattr;

import com.fr.base.chart.chartdata.ChartData;
import com.fr.chart.base.ChartBaseUtils;
import com.fr.chart.base.ChartFunctionProcessor;
import com.fr.chart.base.ChartTypeValueCollection;
import com.fr.chart.base.ChartUtils;
import com.fr.chart.chartattr.CategoryAxis;
import com.fr.chart.chartattr.CategoryPlot;
import com.fr.chart.chartattr.ChartXMLCompatibleUtils;
import com.fr.chart.chartattr.Plot;
import com.fr.chart.chartdata.NormalChartData;
import com.fr.chart.chartglyph.DataSeries;
import com.fr.chart.chartglyph.LineMarkerIcon;
import com.fr.chart.chartglyph.LinePlotGlyph;
import com.fr.chart.chartglyph.PlotGlyph;
import com.fr.general.ComparatorUtils;
import com.fr.general.DateUtils;
import com.fr.general.Inter;
import com.fr.stable.fun.FunctionProcessor;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.awt.Color;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinePlot
extends CategoryPlot {
    private static final long serialVersionUID = 8277372084403680598L;
    private static final int LINE_CHART = 0;
    private static final Object[] LINE_SERIES_NAME = new Object[]{"N", "C"};
    private static final Object[][] LINE_VALUE = new Object[][]{{"5", "40", "18", "14", "70", "85"}, {"36", "75", "53", "57", "40", "45"}};
    private boolean isCurve = false;

    public LinePlot() {
        this.setStacked(false);
    }

    @Override
    public boolean isSupportTrendLine() {
        return !this.isStacked();
    }

    @Override
    public boolean isSupportMoreCate() {
        return true;
    }

    @Override
    public boolean isSupportZoomCategoryAxis() {
        return true;
    }

    @Override
    public boolean isSupportAxisReverse() {
        return true;
    }

    @Override
    public boolean isSupportSeriesDrag() {
        return true;
    }

    @Override
    public PlotGlyph createPlotGlyph(ChartData chartData) {
        LinePlotGlyph linePlotGlyph = new LinePlotGlyph();
        this.sortChartData(chartData);
        this.install4PlotGlyph(linePlotGlyph, chartData);
        this.installAxisGlyph(linePlotGlyph, chartData);
        linePlotGlyph.getxAxisGlyph().setDrawBetweenTick(true);
        return linePlotGlyph;
    }

    private void sortChartData(ChartData chartData) {
        CategoryAxis categoryAxis = (CategoryAxis)this.getxAxis();
        if (chartData != null && categoryAxis.isDate()) {
            int n;
            NormalChartData normalChartData = (NormalChartData)chartData;
            Object[] objectArray = normalChartData.getCategory_array();
            int[] nArray = new int[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                nArray[i] = (int)ChartBaseUtils.date2Int(DateUtils.object2Date((Object)objectArray[i], (boolean)true), categoryAxis.getMainType());
            }
            int[] nArray2 = new int[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                n = 0;
                int n2 = nArray[i];
                for (int j = 0; j < nArray.length; ++j) {
                    if (n2 <= nArray[j]) continue;
                    ++n;
                }
                nArray2[i] = n;
            }
            Object[][] objectArray2 = normalChartData.getSeries_value_2D();
            for (n = 0; n < objectArray2.length; ++n) {
                Object[] objectArray3 = objectArray2[n];
                objectArray2[n] = this.getOrderedValues(objectArray3, nArray2);
            }
            normalChartData.setCategory_array(this.getOrderedValues(objectArray, nArray2));
        }
    }

    private Object[] getOrderedValues(Object[] objectArray, int[] nArray) {
        Object[] objectArray2 = new Object[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray2[nArray[i]] = objectArray[i];
        }
        return objectArray2;
    }

    public void install4PlotGlyph(LinePlotGlyph linePlotGlyph, ChartData chartData) {
        super.install4PlotGlyph(linePlotGlyph, chartData);
        linePlotGlyph.setCurve(this.isCurve);
    }

    public void setCurve(boolean bl) {
        this.isCurve = bl;
    }

    public boolean isCurve() {
        return this.isCurve;
    }

    @Override
    protected LineMarkerIcon getLegendMarkerIcon(DataSeries dataSeries, Color[] colorArray) {
        return this.getLegendMarkerIcon4Line(dataSeries, colorArray);
    }

    public String getPlotName() {
        boolean bl = this.getConditionCollection() == null ? false : this.getConditionCollection().isDefaultNullMarker();
        String string = Inter.getLocText((String)"I-LineStyle_Line");
        if (bl) {
            string = Inter.getLocText((String[])new String[]{"Data", "Marker"}) + string;
        }
        if (this.isStacked()) {
            string = Inter.getLocText((String)"FR-Chart-Type_Stacked") + string;
        }
        if (this.getyAxis().isPercentage()) {
            string = Inter.getLocText((String)"Chart-Use_Percent") + string;
        }
        return string;
    }

    @Override
    public boolean match4GUI(Plot plot) {
        if (plot == null) {
            return false;
        }
        return plot instanceof LinePlot && super.match4GUI(plot);
    }

    @Override
    public boolean matchPlotType(Plot plot) {
        return plot instanceof LinePlot;
    }

    @Override
    public ChartData defaultChartData() {
        CategoryAxis categoryAxis = (CategoryAxis)this.getxAxis();
        return categoryAxis.isDate() ? new NormalChartData(ChartUtils.LONG_CATEGORY_DATE, LINE_SERIES_NAME, LINE_VALUE) : new NormalChartData(ChartUtils.LONG_CATEGORY_STRING, LINE_SERIES_NAME, LINE_VALUE);
    }

    @Override
    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("Show".equals(string)) {
                this.setCurve(xMLableReader.getAttrAsBoolean("Curve", false));
                if (!xMLableReader.getAttrAsBoolean("showLine", true)) {
                    ChartXMLCompatibleUtils.changeAttrNone(this.getConditionCollection(), true);
                }
                if (!xMLableReader.getAttrAsBoolean("showMarker", true)) {
                    ChartXMLCompatibleUtils.changeAttrNone(this.getConditionCollection(), false);
                }
            }
            if (this.getyAxis() != null) {
                this.getyAxis().setPercentage(false);
            }
            this.setStacked(false);
        }
    }

    @Override
    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("CategoryPlot");
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("Show").attr("Curve", this.isCurve).end();
        xMLPrintWriter.end();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        LinePlot linePlot = (LinePlot)super.clone();
        return linePlot;
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof LinePlot && super.equals(object) && ((LinePlot)object).isCurve() == this.isCurve;
    }

    @Override
    public String getPlotSmallIconPath() {
        return "com/fr/design/images/toolbar/line/0";
    }

    @Override
    public ChartTypeValueCollection getPlotType() {
        return ChartTypeValueCollection.LINE;
    }

    @Override
    public int getDetailType() {
        return 0;
    }

    @Override
    protected boolean isSupportAxisLabelWrapShow() {
        return true;
    }

    @Override
    public boolean isSupportTooltipSeriesType() {
        return true;
    }

    @Override
    public boolean accept(Class<? extends Plot> clazz) {
        return ComparatorUtils.equals(LinePlot.class, clazz);
    }

    @Override
    public String getPlotID() {
        return "FineReportLineChart";
    }

    @Override
    public FunctionProcessor getFunctionToRecord() {
        return ChartFunctionProcessor.LINE_CHART;
    }
}

