/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartattr;

import com.fr.base.ScreenResolution;
import com.fr.base.Utils;
import com.fr.base.background.ColorBackground;
import com.fr.base.chart.chartdata.ChartData;
import com.fr.chart.base.AttrColor;
import com.fr.chart.base.ChartAxisPosition;
import com.fr.chart.base.ChartFunctionProcessor;
import com.fr.chart.base.ChartTypeValueCollection;
import com.fr.chart.chartattr.ChartXMLUtils;
import com.fr.chart.chartattr.Plot;
import com.fr.chart.chartattr.XYPlot;
import com.fr.chart.chartdata.BubbleChartData;
import com.fr.chart.chartglyph.BubblePlotGlyph;
import com.fr.chart.chartglyph.CircleFilledMarker;
import com.fr.chart.chartglyph.DataPoint4Bubble;
import com.fr.chart.chartglyph.DataSeries;
import com.fr.chart.chartglyph.LegendItem;
import com.fr.chart.chartglyph.LineMarkerIcon;
import com.fr.chart.chartglyph.PlotGlyph;
import com.fr.general.Background;
import com.fr.general.Inter;
import com.fr.stable.fun.FunctionProcessor;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.awt.Color;

public class BubblePlot
extends XYPlot {
    public static final String XML_TAG = "BubblePlot";
    public static final int BUBBLE_WIDTH = 1;
    public static final int BUBBLE_AREA = 2;
    private static final long serialVersionUID = 4947317115978934717L;
    private static final double MORETHANMIN = 10.0;
    private double maxBubblePixel = 100.0;
    private int seriesEqualsBubbleInWidthOrArea = 1;
    private boolean isShowNegativeBubble = true;
    private static final String[] BUBBLECATENAME = new String[]{"A", "B", "C", "D", "E", "F", "G"};
    private static final String[][] XVALUE = new String[][]{{"8"}, {"11"}, {"16"}, {"13"}, {"4"}, {"9"}, {"5"}};
    private static final String[][] YVALUE = new String[][]{{"17"}, {"28"}, {"14"}, {"20"}, {"12"}, {"6"}, {"23"}};
    private static final String[][] SIZE = new String[][]{{"13"}, {"26"}, {"10"}, {"28"}, {"27"}, {"16"}, {"30"}};
    public static final BubbleChartData BUBBLE_CHART_DATA = new BubbleChartData(BUBBLECATENAME, XVALUE, YVALUE, SIZE);

    public void setMaxBubblePixel(double d) {
        this.maxBubblePixel = d;
    }

    public double getMaxBubblePixel() {
        return this.maxBubblePixel;
    }

    public void setSeriesEqualsBubbleInWidthOrArea(int n) {
        this.seriesEqualsBubbleInWidthOrArea = n;
    }

    public int getSeriesEqualsBubbleInWidthOrArea() {
        return this.seriesEqualsBubbleInWidthOrArea;
    }

    public void setShowNegativeBubble(boolean bl) {
        this.isShowNegativeBubble = bl;
    }

    public boolean isShowNegativeBubble() {
        return this.isShowNegativeBubble;
    }

    public ChartData createNullChartData() {
        return new BubbleChartData(new String[]{""}, new String[][]{{""}}, new String[][]{{""}}, new String[][]{{""}});
    }

    public PlotGlyph createPlotGlyph(ChartData chartData) {
        BubblePlotGlyph bubblePlotGlyph = new BubblePlotGlyph();
        this.install4PlotGlyph(bubblePlotGlyph, chartData);
        this.installAxisGlyph(bubblePlotGlyph, chartData);
        return bubblePlotGlyph;
    }

    protected double getMarkerSize() {
        return this.getMaxBubblePixel();
    }

    public boolean isSupportSeriesDrag() {
        return true;
    }

    protected double getMaxValue4XValue(ChartData chartData) {
        BubbleChartData bubbleChartData = ChartXMLUtils.chartData4Bubble(chartData);
        double d = 0.0;
        for (int i = 0; i < bubbleChartData.getItemCount(); ++i) {
            for (int j = 0; j < bubbleChartData.getCategoryLabelCount(); ++j) {
                Number number = bubbleChartData.getX(i, j);
                if (number == null) continue;
                d = d > number.doubleValue() ? d : number.doubleValue();
            }
        }
        return d;
    }

    public double getMinValueFromData(ChartData chartData, boolean bl, ChartAxisPosition chartAxisPosition) {
        BubbleChartData bubbleChartData = ChartXMLUtils.chartData4Bubble(chartData);
        double d = 0.0;
        if (bl) {
            d = Double.MAX_VALUE;
        }
        for (int i = 0; i < chartData.getCategoryLabelCount(); ++i) {
            for (int j = 0; j < bubbleChartData.getItemCount(); ++j) {
                Number number = bubbleChartData.getY(j, i);
                if (number == null) continue;
                if (bl) {
                    double d2 = number.doubleValue();
                    if (!(d2 < d) || !(d2 < 1.0) || !(d2 > 0.0)) continue;
                    d = d2;
                    continue;
                }
                d = number.doubleValue() < d ? number.doubleValue() : d;
            }
        }
        if (d == Double.MAX_VALUE) {
            return 1.0;
        }
        return d;
    }

    public double getMaxValueFromData(ChartData chartData, ChartAxisPosition chartAxisPosition) {
        BubbleChartData bubbleChartData = ChartXMLUtils.chartData4Bubble(chartData);
        double d = 0.0;
        for (int i = 0; i < chartData.getCategoryLabelCount(); ++i) {
            for (int j = 0; j < bubbleChartData.getItemCount(); ++j) {
                Number number = bubbleChartData.getY(j, i);
                if (number == null) continue;
                d = number.doubleValue() > d ? number.doubleValue() : d;
            }
        }
        if (d == this.getMinValueFromData(chartData, false, chartAxisPosition)) {
            return d + 10.0;
        }
        return d;
    }

    protected void addSeries2PlotGlyph(PlotGlyph plotGlyph, ChartData chartData) {
        BubbleChartData bubbleChartData = ChartXMLUtils.chartData4Bubble(chartData);
        this.addSeriesByIndex(plotGlyph, bubbleChartData);
    }

    private void addSeriesByIndex(PlotGlyph plotGlyph, BubbleChartData bubbleChartData) {
        for (int i = 0; i < bubbleChartData.getItemCount(); ++i) {
            DataSeries dataSeries = this.createDataSeries(i);
            dataSeries.setSeriesName(Utils.objectToString((Object)bubbleChartData.getPresentItem(i)));
            plotGlyph.addSeries(dataSeries);
            for (int j = 0; j < bubbleChartData.getCategoryLabelCount(); ++j) {
                DataPoint4Bubble dataPoint4Bubble = new DataPoint4Bubble();
                dataPoint4Bubble.setCategoryIndex(j);
                dataPoint4Bubble.setSeriesIndex(i);
                if (i < bubbleChartData.getItemCount() && j < bubbleChartData.getCategoryLabelCount()) {
                    Number number = bubbleChartData.getX(i, j);
                    Number number2 = bubbleChartData.getY(i, j);
                    Number number3 = bubbleChartData.getSize(i, j);
                    dataPoint4Bubble.setX(number == null ? 0.0 : number.doubleValue());
                    dataPoint4Bubble.setValue(number2 == null ? 0.0 : number2.doubleValue());
                    dataPoint4Bubble.setSizeValue(number3 == null ? 0.0 : number3.doubleValue());
                    if (number == null || number2 == null || number3 == null) {
                        dataPoint4Bubble.setValueIsNull(true);
                    }
                }
                if (j < bubbleChartData.getCategoryLabelCount()) {
                    dataPoint4Bubble.setCategoryName(Utils.objectToString((Object)bubbleChartData.getCategoryPresentLabel(j)));
                    dataPoint4Bubble.setCategoryOriginalName(Utils.objectToString((Object)bubbleChartData.getCategoryOriginalLabel(j)));
                }
                if (i < bubbleChartData.getItemCount()) {
                    dataPoint4Bubble.setSeriesName(Utils.objectToString((Object)bubbleChartData.getPresentItem(i)));
                    dataPoint4Bubble.setSeriesOriginalName(Utils.objectToString((Object)bubbleChartData.getOriginalItem(i)));
                }
                dataSeries.addDataPoint(dataPoint4Bubble);
            }
        }
        this.createDataPointLabel(plotGlyph);
    }

    public void install4PlotGlyph(BubblePlotGlyph bubblePlotGlyph, ChartData chartData) {
        super.install4PlotGlyph(bubblePlotGlyph, chartData);
        bubblePlotGlyph.setMaxBubblePixel(this.maxBubblePixel);
        bubblePlotGlyph.setSeriesEqualsBubbleType(this.seriesEqualsBubbleInWidthOrArea);
        bubblePlotGlyph.setShowNegativeBubble(this.isShowNegativeBubble());
    }

    public LegendItem[] createLegendItems(PlotGlyph plotGlyph) {
        if (plotGlyph == null) {
            return new LegendItem[0];
        }
        return this.createLegendItems(plotGlyph, plotGlyph.getSeriesSize());
    }

    protected LineMarkerIcon getLegendMarkerIcon(DataSeries dataSeries, Color[] colorArray) {
        Object object;
        LineMarkerIcon lineMarkerIcon = new LineMarkerIcon();
        CircleFilledMarker circleFilledMarker = new CircleFilledMarker();
        if (this.getLegend() != null) {
            object = this.getLegend().getFRFont();
            int n = object.getShowSize(ScreenResolution.getScreenResolution());
            circleFilledMarker.setSize((double)n * 0.8);
        }
        object = (AttrColor)this.getConditionCollection().getDataSeriesCondition(AttrColor.class, dataSeries, colorArray);
        circleFilledMarker.setBackground((Background)ColorBackground.getInstance((Color)((AttrColor)object).getSeriesColor()));
        lineMarkerIcon.setMarker(circleFilledMarker);
        this.dealCondition(lineMarkerIcon, dataSeries, colorArray);
        return lineMarkerIcon;
    }

    public String getPlotDataPaneName() {
        return XML_TAG;
    }

    public String getPlotName() {
        return Inter.getLocText((String)"FR-Chart-Chart_BubbleChart");
    }

    public boolean matchPlotType(Plot plot) {
        return plot instanceof BubblePlot;
    }

    public ChartData defaultChartData() {
        return BUBBLE_CHART_DATA;
    }

    public boolean isSupportCategoryFilter() {
        return false;
    }

    public boolean isSupportValuePercent() {
        return false;
    }

    public boolean equals(Object object) {
        return object instanceof BubblePlot && super.equals(object) && ((BubblePlot)object).getMaxBubblePixel() == this.maxBubblePixel && ((BubblePlot)object).getSeriesEqualsBubbleInWidthOrArea() == this.seriesEqualsBubbleInWidthOrArea && ((BubblePlot)object).isShowNegativeBubble() == this.isShowNegativeBubble;
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode() && (string = xMLableReader.getTagName()).equals("BubblePlotAttr")) {
            this.setMaxBubblePixel(xMLableReader.getAttrAsDouble("bubbleSize", 30.0));
            this.setSeriesEqualsBubbleInWidthOrArea(xMLableReader.getAttrAsInt("bubbleType", 1));
            this.setShowNegativeBubble(xMLableReader.getAttrAsBoolean("isNegative", true));
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("BubblePlotAttr").attr("bubbleSize", this.maxBubblePixel).attr("bubbleType", this.getSeriesEqualsBubbleInWidthOrArea()).attr("isNegative", this.isShowNegativeBubble).end();
        xMLPrintWriter.end();
    }

    public String getPlotSmallIconPath() {
        return "com/fr/design/images/toolbar/bubble/0";
    }

    public ChartTypeValueCollection getPlotType() {
        return ChartTypeValueCollection.BUBBLE;
    }

    public int getDetailType() {
        return 0;
    }

    public String getPlotID() {
        return "FineReportBubbleChart";
    }

    public FunctionProcessor getFunctionToRecord() {
        return ChartFunctionProcessor.BUBBLE_CHART;
    }
}

