/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.base;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class CannyTest
extends JComponent
implements MouseListener {
    final float ORIENT_SCALE = 40.0f;
    private int height;
    private int width;
    private int picsize;
    private int[] data;
    private int[] derivative_mag;
    private int[] magnitude;
    private int[] orientation;
    private Image sourceImage;
    private Image edgeImage;
    private int threshold1 = 50;
    private int threshold2 = 230;
    private int threshold;
    private int widGaussianKernel;
    private int startX = 300;
    private int startY = 200;

    public CannyTest() {
        this.setThreshold(128);
        this.setWidGaussianKernel(15);
        this.addMouseListener(this);
    }

    public void process() throws Exception {
        if (this.threshold < 0 || this.threshold > 255) {
            throw new Exception("The value of the threshold is out of its valid range.");
        }
        if (this.widGaussianKernel < 3 || this.widGaussianKernel > 40) {
            throw new Exception("The value of the widGaussianKernel is out of its valid range.");
        }
        this.width = this.sourceImage.getWidth(this);
        this.height = this.sourceImage.getHeight(this);
        this.picsize = this.width * this.height;
        this.data = new int[this.picsize];
        this.magnitude = new int[this.picsize];
        this.orientation = new int[this.picsize];
        float f = 1.0f;
        this.canny_core(f, this.widGaussianKernel);
        this.thresholding_tracker(this.threshold1, this.threshold2);
        for (int i = 0; i < this.picsize; ++i) {
            this.data[i] = this.data[i] > this.threshold ? -16777216 : -1;
        }
        this.edgeImage = this.pixels2image(this.data);
        this.data = null;
        this.magnitude = null;
        this.orientation = null;
    }

    private void canny_core(float f, int n) {
        int n2;
        int n3;
        int n4;
        float f2;
        int n5;
        int n6;
        float f3;
        int n7;
        boolean bl = false;
        boolean bl2 = false;
        this.derivative_mag = new int[this.picsize];
        float[] fArray = new float[n];
        float[] fArray2 = new float[n];
        float[] fArray3 = new float[n];
        this.data = CannyTest.image2pixels(this.sourceImage);
        for (n7 = 0; !(n7 >= n || (f3 = this.gaussian(n7, f)) <= 0.005f && n7 >= 2); ++n7) {
            float f4 = this.gaussian((float)n7 - 0.5f, f);
            float f5 = this.gaussian((float)n7 + 0.5f, f);
            float f6 = this.gaussian(n7, f * 0.5f);
            fArray[n7] = (f3 + f4 + f5) / 3.0f / (6.283185f * f * f);
            fArray2[n7] = f5 - f4;
            fArray3[n7] = 1.6f * f6 - f3;
        }
        int n8 = n7;
        float[] fArray4 = new float[this.picsize];
        float[] fArray5 = new float[this.picsize];
        int n9 = this.width - (n8 - 1);
        int n10 = this.width * (n8 - 1);
        int n11 = this.width * (this.height - (n8 - 1));
        for (int i = n8 - 1; i < n9; ++i) {
            for (n6 = n10; n6 < n11; n6 += this.width) {
                n5 = i + n6;
                float f7 = f2 = (float)this.data[n5] * fArray[0];
                n4 = 1;
                n3 = n5 - this.width;
                n2 = n5 + this.width;
                while (n4 < n8) {
                    f2 += fArray[n4] * (float)(this.data[n3] + this.data[n2]);
                    f7 += fArray[n4] * (float)(this.data[n5 - n4] + this.data[n5 + n4]);
                    ++n4;
                    n3 -= this.width;
                    n2 += this.width;
                }
                fArray4[n5] = f2;
                fArray5[n5] = f7;
            }
        }
        float[] fArray6 = new float[this.picsize];
        for (n6 = n8 - 1; n6 < n9; ++n6) {
            for (n5 = n10; n5 < n11; n5 += this.width) {
                f2 = 0.0f;
                int n12 = n6 + n5;
                for (n4 = 1; n4 < n8; ++n4) {
                    f2 += fArray2[n4] * (fArray4[n12 - n4] - fArray4[n12 + n4]);
                }
                fArray6[n12] = f2;
            }
        }
        fArray4 = null;
        float[] fArray7 = new float[this.picsize];
        for (n5 = n7; n5 < this.width - n7; ++n5) {
            for (int i = n10; i < n11; i += this.width) {
                float f8 = 0.0f;
                n4 = n5 + i;
                n3 = 1;
                n2 = this.width;
                while (n3 < n8) {
                    f8 += fArray2[n3] * (fArray5[n4 - n2] - fArray5[n4 + n2]);
                    ++n3;
                    n2 += this.width;
                }
                fArray7[n4] = f8;
            }
        }
        fArray5 = null;
        n9 = this.width - n8;
        n10 = this.width * n8;
        n11 = this.width * (this.height - n8);
        for (n5 = n8; n5 < n9; ++n5) {
            for (int i = n10; i < n11; i += this.width) {
                float f9;
                int n13 = n5 + i;
                n4 = n13 - this.width;
                n3 = n13 + this.width;
                n2 = n13 - 1;
                int n14 = n13 + 1;
                int n15 = n4 - 1;
                int n16 = n4 + 1;
                int n17 = n3 - 1;
                int n18 = n3 + 1;
                float f10 = fArray6[n13];
                float f11 = fArray7[n13];
                float f12 = this.hypotenuse(f10, f11);
                int n19 = (int)((double)f12 * 20.0);
                this.derivative_mag[n13] = n19 >= 256 ? 255 : n19;
                float f13 = this.hypotenuse(fArray6[n4], fArray7[n4]);
                float f14 = this.hypotenuse(fArray6[n3], fArray7[n3]);
                float f15 = this.hypotenuse(fArray6[n2], fArray7[n2]);
                float f16 = this.hypotenuse(fArray6[n14], fArray7[n14]);
                float f17 = this.hypotenuse(fArray6[n16], fArray7[n16]);
                float f18 = this.hypotenuse(fArray6[n18], fArray7[n18]);
                float f19 = this.hypotenuse(fArray6[n17], fArray7[n17]);
                float f20 = this.hypotenuse(fArray6[n15], fArray7[n15]);
                if (f10 * f11 <= 0.0f) {
                    if (Math.abs(f10) >= Math.abs(f11)) {
                        float f21;
                        f9 = Math.abs(f10 * f12);
                        if (!(f21 >= Math.abs(f11 * f17 - (f10 + f11) * f16)) || !(f9 > Math.abs(f11 * f19 - (f10 + f11) * f15))) continue;
                    } else {
                        float f22;
                        f9 = Math.abs(f11 * f12);
                        if (!(f22 >= Math.abs(f10 * f17 - (f11 + f10) * f13)) || !(f9 > Math.abs(f10 * f19 - (f11 + f10) * f14))) continue;
                    }
                } else if (Math.abs(f10) >= Math.abs(f11)) {
                    float f23;
                    f9 = Math.abs(f10 * f12);
                    if (!(f23 >= Math.abs(f11 * f18 + (f10 - f11) * f16)) || !(f9 > Math.abs(f11 * f20 + (f10 - f11) * f15))) continue;
                } else {
                    float f24;
                    f9 = Math.abs(f11 * f12);
                    if (!(f24 >= Math.abs(f10 * f18 + (f11 - f10) * f14)) || !(f9 > Math.abs(f10 * f20 + (f11 - f10) * f13))) continue;
                }
                this.magnitude[n13] = this.derivative_mag[n13];
                this.orientation[n13] = (int)(Math.atan2(f11, f10) * 40.0);
            }
        }
        this.derivative_mag = null;
        fArray6 = null;
        fArray7 = null;
    }

    private float hypotenuse(float f, float f2) {
        if (f == 0.0f && f2 == 0.0f) {
            return 0.0f;
        }
        return (float)Math.sqrt(f * f + f2 * f2);
    }

    private float gaussian(float f, float f2) {
        return (float)Math.exp(-f * f / (2.0f * f2 * f2));
    }

    private void thresholding_tracker(int n, int n2) {
        int n3;
        for (n3 = 0; n3 < this.picsize; ++n3) {
            this.data[n3] = 0;
        }
        for (n3 = 0; n3 < this.width; ++n3) {
            for (int i = 0; i < this.height; ++i) {
                if (this.magnitude[n3 + this.width * i] < n) continue;
                this.follow(n3, i, n2);
            }
        }
    }

    private boolean follow(int n, int n2, int n3) {
        int n4 = n + 1;
        int n5 = n - 1;
        int n6 = n2 + 1;
        int n7 = n2 - 1;
        int n8 = n + n2 * this.width;
        if (n6 >= this.height) {
            n6 = this.height - 1;
        }
        if (n7 < 0) {
            n7 = 0;
        }
        if (n4 >= this.width) {
            n4 = this.width - 1;
        }
        if (n5 < 0) {
            n5 = 0;
        }
        if (this.data[n8] == 0) {
            this.data[n8] = this.magnitude[n8];
            boolean bl = false;
            for (int i = n5; i <= n4; ++i) {
                for (int j = n7; j <= n6; ++j) {
                    int n9 = i + j * this.width;
                    if (j == n2 && i == n || this.magnitude[n9] < n3 || !this.follow(i, j, n3)) continue;
                    bl = true;
                    break;
                }
                if (!bl) break;
            }
            return true;
        }
        return false;
    }

    private Image pixels2image(int[] nArray) {
        MemoryImageSource memoryImageSource = new MemoryImageSource(this.width, this.height, ColorModel.getRGBdefault(), nArray, 0, this.width);
        return Toolkit.getDefaultToolkit().createImage(memoryImageSource);
    }

    public static int[] image2pixels(Image image) {
        int n;
        int n2;
        int n3;
        int n4 = image.getWidth(null);
        int n5 = image.getHeight(null);
        int n6 = n4 * n5;
        int[] nArray = new int[n6];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n4, n5, nArray, 0, n4);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        boolean bl = false;
        for (int i = 0; i < 16; ++i) {
            n3 = (nArray[i] & 0xFF0000) >> 16;
            n2 = (nArray[i] & 0xFF00) >> 8;
            n = nArray[i] & 0xFF;
            if (n3 == n2 && n2 == n) continue;
            bl = true;
            break;
        }
        if (bl) {
            for (n3 = 0; n3 < n6; ++n3) {
                n2 = (nArray[n3] & 0xFF0000) >> 16;
                n = (nArray[n3] & 0xFF00) >> 8;
                int n7 = nArray[n3] & 0xFF;
                nArray[n3] = (int)(0.298 * (double)n2 + 0.586 * (double)n + 0.113 * (double)n7);
            }
        } else {
            for (n3 = 0; n3 < n6; ++n3) {
                nArray[n3] = nArray[n3] & 0xFF;
            }
        }
        return nArray;
    }

    public void setSourceImage(Image image) {
        this.sourceImage = image;
    }

    public Image getEdgeImage() {
        return this.edgeImage;
    }

    public void setThreshold(int n) {
        this.threshold = n;
    }

    public void setWidGaussianKernel(int n) {
        this.widGaussianKernel = n;
    }

    public void paint(Graphics graphics) {
        graphics.drawImage(this.edgeImage, 0, 0, null);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setPaint(Color.blue);
        int n = this.startX;
        int n2 = this.startY;
    }

    public static void main(String[] stringArray) {
        try {
            CannyTest cannyTest = new CannyTest();
            String string = "/Users/jihua/Desktop/world.png";
            File file = new File(string);
            BufferedImage bufferedImage = ImageIO.read(file);
            cannyTest.setSourceImage(bufferedImage);
            try {
                cannyTest.process();
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
            }
            JFrame jFrame = new JFrame();
            JPanel jPanel = (JPanel)jFrame.getContentPane();
            jPanel.setLayout(new BorderLayout());
            jPanel.add((Component)cannyTest, "Center");
            jFrame.setSize(1400, 900);
            jFrame.setDefaultCloseOperation(3);
            jFrame.setTitle("Canny Test");
            jFrame.setVisible(true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() >= 2) {
            this.startX = mouseEvent.getX();
            this.startY = mouseEvent.getY();
            this.repaint();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }
}

