/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.management.MalformedObjectNameException;

public class ObjectName
implements Serializable {
    private static final long oldSerialVersionUID = -5467795090068647408L;
    private static final long newSerialVersionUID = 1081892073854801359L;
    private static final ObjectStreamField[] oldSerialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("domain", class$java$lang$String == null ? (class$java$lang$String = ObjectName.class$("java.lang.String")) : class$java$lang$String), new ObjectStreamField("propertyList", class$java$util$Hashtable == null ? (class$java$util$Hashtable = ObjectName.class$("java.util.Hashtable")) : class$java$util$Hashtable), new ObjectStreamField("propertyListString", class$java$lang$String == null ? (class$java$lang$String = ObjectName.class$("java.lang.String")) : class$java$lang$String), new ObjectStreamField("canonicalName", class$java$lang$String == null ? (class$java$lang$String = ObjectName.class$("java.lang.String")) : class$java$lang$String), new ObjectStreamField("pattern", Boolean.TYPE), new ObjectStreamField("propertyPattern", Boolean.TYPE)};
    private static final ObjectStreamField[] newSerialPersistentFields = new ObjectStreamField[0];
    private static final long serialVersionUID;
    private static final ObjectStreamField[] serialPersistentFields;
    private static boolean compat;
    private transient String domain = "";
    private transient Hashtable propertyList = new Hashtable(5);
    private transient String propertyListString = "";
    private transient String canonicalName = "";
    private transient boolean pattern = false;
    private transient boolean propertyPattern = false;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Hashtable;

    public ObjectName(String string) throws MalformedObjectNameException {
        this.construct(string);
    }

    public ObjectName(String string, String string2, String string3) throws MalformedObjectNameException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>(1);
        try {
            hashtable.put(string2, string3);
        }
        catch (NullPointerException nullPointerException) {
            throw new MalformedObjectNameException("ObjectName: Neither the key nor the value can be null");
        }
        this.construct(string, hashtable);
    }

    public ObjectName(String string, Hashtable hashtable) throws MalformedObjectNameException {
        if (hashtable == null) {
            throw new MalformedObjectNameException("ObjectName: Hashtable is null");
        }
        if (hashtable.isEmpty()) {
            throw new MalformedObjectNameException("ObjectName: Empty Hashtable");
        }
        this.construct(string, hashtable);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ObjectName)) {
            return false;
        }
        ObjectName objectName = (ObjectName)object;
        return this.canonicalName.equals(objectName.getCanonicalName());
    }

    public int hashCode() {
        return this.canonicalName.hashCode();
    }

    public String toString() {
        String string = this.propertyListString == null ? "" : this.propertyListString;
        String string2 = this.domain + ":" + (this.propertyPattern ? (string.length() == 0 ? "*" : "*,") : "") + string;
        return string2;
    }

    public boolean isPattern() {
        return this.pattern;
    }

    public String getCanonicalName() {
        return this.canonicalName;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getKeyProperty(String string) {
        return (String)this.propertyList.get(string);
    }

    public Hashtable getKeyPropertyList() {
        return (Hashtable)this.propertyList.clone();
    }

    public String getKeyPropertyListString() {
        return this.propertyListString;
    }

    public String getCanonicalKeyPropertyListString() {
        int n = this.domain.length() + 1;
        try {
            return this.canonicalName.substring(n, this.canonicalName.length());
        }
        catch (Exception exception) {
            return "";
        }
    }

    public boolean isPropertyPattern() {
        return this.propertyPattern;
    }

    private void initObjectName(String string, String string2, Hashtable hashtable, boolean bl) throws MalformedObjectNameException {
        if (string == null || hashtable == null) {
            throw new MalformedObjectNameException("ObjectName: Invalid object name");
        }
        if (!this.isDomain(string)) {
            throw new MalformedObjectNameException("ObjectName: Invalid domain -> " + string);
        }
        this.setDomain(string);
        if (string.indexOf("*") != -1 || string.indexOf("?") != -1) {
            this.pattern = true;
        }
        this.propertyListString = string2;
        this.propertyPattern = bl;
        if (this.propertyPattern) {
            this.pattern = true;
        }
        this.canonicalName = this.getCanonicalName(string, string2, hashtable);
    }

    private static final void addProperty(String string, String string2, Hashtable hashtable, StringBuffer stringBuffer) throws MalformedObjectNameException {
        if (hashtable.containsKey(string)) {
            throw new MalformedObjectNameException("ObjectName: key `" + string + "' already defined.");
        }
        hashtable.put(string, string2);
        if (stringBuffer.length() > 0) {
            stringBuffer.append(',');
        }
        stringBuffer.append(string);
        stringBuffer.append('=');
        stringBuffer.append(string2);
    }

    private static final int parseKey(char[] cArray, int n) throws MalformedObjectNameException {
        int n2 = n;
        int n3 = n;
        int n4 = cArray.length;
        block4: while (n2 < n4) {
            char c = cArray[n2++];
            switch (c) {
                case '*': 
                case ',': 
                case ':': 
                case '?': {
                    throw new MalformedObjectNameException("ObjectName: `" + c + "'" + " Invalid character in key");
                }
                case '=': {
                    n3 = n2 - 1;
                    break block4;
                }
                default: {
                    if (n2 < n4) continue block4;
                    n3 = n2;
                    break block4;
                }
            }
        }
        return n3;
    }

    /*
     * Unable to fully structure code
     */
    private static final int parseValue(char[] var0, int var1_1) throws MalformedObjectNameException {
        block8: {
            var2_2 = var1_1;
            var3_3 = var1_1;
            var4_4 = var0.length;
            var5_5 = var0[var1_1];
            if (var5_5 != '\"') ** GOTO lbl-1000
            if (++var2_2 != var4_4) ** GOTO lbl11
            throw new MalformedObjectNameException("ObjectName: Invalid quote.");
            while ((var6_6 = var0[var2_2++]) != '\"') {
                if (var2_2 == var4_4) {
                    throw new MalformedObjectNameException("ObjectName: Invalid quote.");
                }
lbl11:
                // 3 sources

                if (var2_2 < var4_4) continue;
            }
            var3_3 = var2_2;
            if (var2_2 < var4_4 && var0[var2_2++] != ',') {
                throw new MalformedObjectNameException("ObjectName: Invalid quote.");
lbl-1000:
                // 1 sources

                {
                    var6_7 = var0[var2_2++];
                    switch (var6_7) {
                        case '*': 
                        case ':': 
                        case '=': 
                        case '?': {
                            throw new MalformedObjectNameException("ObjectName: `" + var6_7 + "'" + " Invalid character in value");
                        }
                        case ',': {
                            var3_3 = var2_2 - 1;
                            break block5;
                        }
                        default: {
                            if (var2_2 < var4_4) continue block5;
                            var3_3 = var2_2;
                            break block5;
                        }
                    }
                }
            }
            break block8;
lbl-1000:
            // 2 sources

            {
                ** while (var2_2 < var4_4)
            }
        }
        return var3_3;
    }

    private void construct(String string) throws MalformedObjectNameException {
        int n;
        String string2 = "";
        boolean bl = false;
        if (string == null) {
            throw new MalformedObjectNameException("ObjectName: Name cannot be null");
        }
        if (string.equals("")) {
            string = "*:*";
        }
        if ((n = string.indexOf(":")) == -1) {
            throw new MalformedObjectNameException("ObjectName: domain part must be specified");
        }
        string2 = string.substring(0, n);
        String string3 = string.substring(n + 1, string.length());
        if (string3.length() == 0) {
            throw new MalformedObjectNameException("ObjectName: Key properties cannot be null");
        }
        char[] cArray = string3.toCharArray();
        int n2 = cArray.length;
        StringBuffer stringBuffer = new StringBuffer(n2);
        int n3 = 0;
        boolean bl2 = false;
        while (n3 < n2) {
            int n4;
            char c;
            if ((c = cArray[n4 = n3++]) == '*') {
                if (n3 != n2) {
                    if (cArray[n3] == ',') {
                        if (++n3 == n2) {
                            throw new MalformedObjectNameException("ObjectName: Invalid comma");
                        }
                    } else {
                        throw new MalformedObjectNameException("ObjectName: Invalid pattern");
                    }
                }
                bl = true;
                this.pattern = true;
                continue;
            }
            int n5 = ObjectName.parseKey(cArray, n4);
            if (n5 == n4) {
                throw new MalformedObjectNameException("ObjectName: Invalid key (empty)");
            }
            n3 = n5 + 1;
            if (n3 >= n2) {
                throw new MalformedObjectNameException("ObjectName: Invalid property list format: no value.");
            }
            int n6 = n3;
            int n7 = ObjectName.parseValue(cArray, n6);
            n3 = n7 + 1;
            if (n7 < n2) {
                if (cArray[n7] != ',') {
                    throw new MalformedObjectNameException("ObjectName: `,' expected");
                }
                if (n3 >= n2) {
                    throw new MalformedObjectNameException("ObjectName: Invalid comma");
                }
            }
            if (n7 == n6) {
                throw new MalformedObjectNameException("ObjectName: Invalid value (empty)");
            }
            String string4 = new String(cArray, n4, n5 - n4);
            String string5 = new String(cArray, n6, n7 - n6);
            ObjectName.addProperty(string4, string5, this.propertyList, stringBuffer);
        }
        this.initObjectName(string2, stringBuffer.toString(), this.propertyList, bl);
    }

    private void construct(String string, Hashtable hashtable) throws MalformedObjectNameException {
        if (string == null || hashtable == null) {
            throw new MalformedObjectNameException("ObjectName: Invalid object name");
        }
        int n = hashtable.size();
        Enumeration enumeration = hashtable.keys();
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            String string2;
            String string3;
            try {
                string3 = (String)enumeration.nextElement();
            }
            catch (Exception exception) {
                throw new MalformedObjectNameException("ObjectName: Invalid key");
            }
            try {
                string2 = (String)hashtable.get(string3);
            }
            catch (Exception exception) {
                throw new MalformedObjectNameException("ObjectName: Invalid key");
            }
            this.checkKey(string3);
            this.checkValue(string2);
            ObjectName.addProperty(string3, string2, this.propertyList, stringBuffer);
            ++n2;
        }
        this.initObjectName(string, stringBuffer.toString(), this.propertyList, false);
    }

    private void setDomain(String string) {
        this.domain = string;
    }

    private String getCanonicalName(String string, String string2, Hashtable hashtable) {
        int n = string2 == null ? 0 : string2.length();
        StringBuffer stringBuffer = new StringBuffer(n + string.length() + 1);
        stringBuffer.append(string);
        stringBuffer.append(':');
        if (hashtable == null) {
            return stringBuffer.toString();
        }
        int n2 = hashtable.size();
        if (n2 < 1) {
            return stringBuffer.toString();
        }
        if (n2 == 1 && string2 != null) {
            return stringBuffer.append(string2).toString();
        }
        Object[] objectArray = new String[n2];
        Enumeration enumeration = hashtable.keys();
        int n3 = 0;
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            String string4 = (String)hashtable.get(string3);
            objectArray[n3] = string3 + "=" + (string4 == null ? "" : string4);
            ++n3;
        }
        Arrays.sort(objectArray);
        int n4 = 0;
        while (n4 < n2) {
            stringBuffer.append((String)objectArray[n4]);
            if (++n4 >= n2) continue;
            stringBuffer.append(',');
        }
        return stringBuffer.toString();
    }

    private boolean isDomain(String string) {
        if (string == null) {
            return true;
        }
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2++];
            switch (c) {
                case ',': 
                case ':': 
                case '=': {
                    return false;
                }
            }
        }
        return true;
    }

    private String checkValue(String string) throws MalformedObjectNameException {
        if (string == null) {
            throw new MalformedObjectNameException("ObjectName: Invalid value (null).");
        }
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        if (n == 0) {
            throw new MalformedObjectNameException("ObjectName: Invalid value (empty).");
        }
        int n2 = ObjectName.parseValue(cArray, 0);
        if (n2 < n) {
            throw new MalformedObjectNameException("ObjectName: `" + cArray[n2] + "'" + " Invalid character in value");
        }
        return string;
    }

    private String checkKey(String string) throws MalformedObjectNameException {
        if (string == null) {
            throw new MalformedObjectNameException("ObjectName: Invalid key (null)");
        }
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        if (n == 0) {
            throw new MalformedObjectNameException("ObjectName: Invalid key (empty)");
        }
        int n2 = ObjectName.parseKey(cArray, 0);
        if (n2 < n) {
            throw new MalformedObjectNameException("ObjectName: `" + cArray[n2] + "'" + " Invalid character in value");
        }
        return string;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        if (compat) {
            objectInputStream.defaultReadObject();
        } else {
            objectInputStream.defaultReadObject();
            String string = (String)objectInputStream.readObject();
            this.canonicalName = "";
            this.propertyList = new Hashtable(5);
            this.propertyListString = "";
            try {
                this.construct(string);
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                throw new InvalidObjectException(malformedObjectNameException.toString());
            }
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (compat) {
            ObjectOutputStream.PutField putField = objectOutputStream.putFields();
            putField.put("domain", this.domain);
            putField.put("propertyList", this.propertyList);
            putField.put("propertyListString", this.propertyListString);
            putField.put("canonicalName", this.canonicalName);
            putField.put("pattern", this.pattern);
            putField.put("propertyPattern", this.propertyPattern);
            objectOutputStream.writeFields();
        } else {
            objectOutputStream.defaultWriteObject();
            String string = this.domain + ":" + this.propertyListString;
            if (this.propertyPattern) {
                string = this.propertyList.isEmpty() ? string + "*" : string + ",*";
            }
            objectOutputStream.writeObject(string);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        compat = false;
        String string = System.getProperty("jmx.serial.form");
        if (string != null && string.equals("1.0")) {
            compat = true;
        }
        if (compat) {
            serialPersistentFields = oldSerialPersistentFields;
            serialVersionUID = -5467795090068647408L;
        } else {
            serialPersistentFields = newSerialPersistentFields;
            serialVersionUID = 1081892073854801359L;
        }
    }
}

