/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;

public class FloodFiller {
    int maxStackSize = 500;
    int[] xstack = new int[this.maxStackSize];
    int[] ystack = new int[this.maxStackSize];
    int stackSize;
    ImageProcessor ip;
    int max;
    boolean isFloat;
    int count = 0;
    private List list = new ArrayList();

    public FloodFiller(ImageProcessor ip) {
        this.ip = ip;
        this.isFloat = ip instanceof FloatProcessor;
    }

    /*
     * Unable to fully structure code
     */
    public boolean fill(int x, int y) {
        width = this.ip.getWidth();
        height = this.ip.getHeight();
        color = this.ip.getPixel(x, y);
        this.fillLine(this.ip, x, x, y);
        newColor = this.ip.getPixel(x, y);
        this.ip.putPixel(x, y, color);
        if (color == newColor) {
            return false;
        }
        this.stackSize = 0;
        this.push(x, y);
        block0: while (true) {
            if ((x = this.popx()) == -1) {
                return true;
            }
            y = this.popy();
            if (this.ip.getPixel(x, y) != color) continue;
            x1 = x;
            x2 = x;
            while (this.ip.getPixel(x1, y) == color && x1 >= 0) {
                --x1;
            }
            ++x1;
            while (this.ip.getPixel(x2, y) == color && x2 < width) {
                ++x2;
            }
            this.fillLine(this.ip, x1, --x2, y);
            inScanLine = false;
            i = x1;
            while (i <= x2) {
                if (!inScanLine && y > 0 && this.ip.getPixel(i, y - 1) == color) {
                    this.push(i, y - 1);
                    inScanLine = true;
                } else if (inScanLine && y > 0 && this.ip.getPixel(i, y - 1) != color) {
                    inScanLine = false;
                }
                ++i;
            }
            inScanLine = false;
            i = x1;
            while (true) {
                if (i <= x2) ** break;
                continue block0;
                if (!inScanLine && y < height - 1 && this.ip.getPixel(i, y + 1) == color) {
                    this.push(i, y + 1);
                    inScanLine = true;
                } else if (inScanLine && y < height - 1 && this.ip.getPixel(i, y + 1) != color) {
                    inScanLine = false;
                }
                ++i;
            }
            break;
        }
    }

    public boolean fill8(int x, int y) {
        int width = this.ip.getWidth();
        int height = this.ip.getHeight();
        int color = this.ip.getPixel(x, y);
        int wm1 = width - 1;
        int hm1 = height - 1;
        this.list.clear();
        this.fillLine(this.ip, x, x, y);
        int newColor = this.ip.getPixel(x, y);
        this.ip.putPixel(x, y, color);
        if (color == newColor) {
            return false;
        }
        this.stackSize = 0;
        this.push(x, y);
        block0: while ((x = this.popx()) != -1) {
            y = this.popy();
            int x1 = x;
            int x2 = x;
            if (this.ip.getPixel(x1, y) == color) {
                while (this.ip.getPixel(x1, y) == color && x1 >= 0) {
                    --x1;
                }
                ++x1;
                while (this.ip.getPixel(x2, y) == color && x2 < width) {
                    ++x2;
                }
                this.fillLine(this.ip, x1, --x2, y);
            }
            if (y > 0) {
                if (x1 > 0 && this.ip.getPixel(x1 - 1, y - 1) == color) {
                    this.push(x1 - 1, y - 1);
                }
                if (x2 < wm1 && this.ip.getPixel(x2 + 1, y - 1) == color) {
                    this.push(x2 + 1, y - 1);
                }
            }
            if (y < hm1) {
                if (x1 > 0 && this.ip.getPixel(x1 - 1, y + 1) == color) {
                    this.push(x1 - 1, y + 1);
                }
                if (x2 < wm1 && this.ip.getPixel(x2 + 1, y + 1) == color) {
                    this.push(x2 + 1, y + 1);
                }
            }
            boolean inScanLine = false;
            int i = x1;
            while (i <= x2) {
                if (!inScanLine && y > 0 && this.ip.getPixel(i, y - 1) == color) {
                    this.push(i, y - 1);
                    inScanLine = true;
                } else if (inScanLine && y > 0 && this.ip.getPixel(i, y - 1) != color) {
                    inScanLine = false;
                }
                ++i;
            }
            inScanLine = false;
            i = x1;
            while (true) {
                if (i > x2) continue block0;
                if (!inScanLine && y < hm1 && this.ip.getPixel(i, y + 1) == color) {
                    this.push(i, y + 1);
                    inScanLine = true;
                } else if (inScanLine && y < hm1 && this.ip.getPixel(i, y + 1) != color) {
                    inScanLine = false;
                }
                ++i;
            }
            break;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public void particleAnalyzerFill(int x, int y, double level1, double level2, ImageProcessor mask, Rectangle bounds) {
        width = this.ip.getWidth();
        height = this.ip.getHeight();
        mask.setColor(0);
        mask.fill();
        mask.setColor(255);
        this.stackSize = 0;
        this.push(x, y);
        block0: while (true) {
            if ((x = this.popx()) == -1) {
                return;
            }
            y = this.popy();
            if (!this.inParticle(x, y, level1, level2)) continue;
            x1 = x;
            x2 = x;
            while (this.inParticle(x1, y, level1, level2) && x1 >= 0) {
                --x1;
            }
            ++x1;
            while (this.inParticle(x2, y, level1, level2) && x2 < width) {
                ++x2;
            }
            this.fillLine(mask, x1 - bounds.x, --x2 - bounds.x, y - bounds.y);
            this.fillLine(this.ip, x1, x2, y);
            inScanLine = false;
            if (x1 > 0) {
                --x1;
            }
            if (x2 < width - 1) {
                ++x2;
            }
            i = x1;
            while (i <= x2) {
                if (!inScanLine && y > 0 && this.inParticle(i, y - 1, level1, level2)) {
                    this.push(i, y - 1);
                    inScanLine = true;
                } else if (inScanLine && y > 0 && !this.inParticle(i, y - 1, level1, level2)) {
                    inScanLine = false;
                }
                ++i;
            }
            inScanLine = false;
            i = x1;
            while (true) {
                if (i <= x2) ** break;
                continue block0;
                if (!inScanLine && y < height - 1 && this.inParticle(i, y + 1, level1, level2)) {
                    this.push(i, y + 1);
                    inScanLine = true;
                } else if (inScanLine && y < height - 1 && !this.inParticle(i, y + 1, level1, level2)) {
                    inScanLine = false;
                }
                ++i;
            }
            break;
        }
    }

    final boolean inParticle(int x, int y, double level1, double level2) {
        if (this.isFloat) {
            return (double)this.ip.getPixelValue(x, y) >= level1 && (double)this.ip.getPixelValue(x, y) <= level2;
        }
        int v = this.ip.getPixel(x, y);
        return (double)v >= level1 && (double)v <= level2;
    }

    final void push(int x, int y) {
        ++this.stackSize;
        if (this.stackSize == this.maxStackSize) {
            int[] newXStack = new int[this.maxStackSize * 2];
            int[] newYStack = new int[this.maxStackSize * 2];
            System.arraycopy(this.xstack, 0, newXStack, 0, this.maxStackSize);
            System.arraycopy(this.ystack, 0, newYStack, 0, this.maxStackSize);
            this.xstack = newXStack;
            this.ystack = newYStack;
            this.maxStackSize *= 2;
        }
        this.xstack[this.stackSize - 1] = x;
        this.ystack[this.stackSize - 1] = y;
    }

    final int popx() {
        if (this.stackSize == 0) {
            return -1;
        }
        return this.xstack[this.stackSize - 1];
    }

    final int popy() {
        int value = this.ystack[this.stackSize - 1];
        --this.stackSize;
        return value;
    }

    final void fillLine(ImageProcessor ip, int x1, int x2, int y) {
        if (x1 > x2) {
            int t = x1;
            x1 = x2;
            x2 = t;
        }
        int x = x1;
        while (x <= x2) {
            ip.drawPixel(x, y);
            this.list.add(new Point2D.Double(x, y));
            ++x;
        }
    }

    public List getList() {
        return this.list;
    }
}

