/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.v2.org.apache.poi.sl.draw;

import com.fr.third.v2.org.apache.poi.sl.draw.DrawPictureShape;
import com.fr.third.v2.org.apache.poi.sl.draw.DrawShape;
import com.fr.third.v2.org.apache.poi.sl.draw.ImageRenderer;
import com.fr.third.v2.org.apache.poi.sl.draw.PathGradientPaint;
import com.fr.third.v2.org.apache.poi.sl.usermodel.ColorStyle;
import com.fr.third.v2.org.apache.poi.sl.usermodel.PaintStyle;
import com.fr.third.v2.org.apache.poi.sl.usermodel.PlaceableShape;
import com.fr.third.v2.org.apache.poi.util.POILogFactory;
import com.fr.third.v2.org.apache.poi.util.POILogger;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DrawPaint {
    private static final POILogger LOG = POILogFactory.getLogger(DrawPaint.class);
    private static final Color TRANSPARENT = new Color(1.0f, 1.0f, 1.0f, 0.0f);
    protected PlaceableShape<?, ?> shape;

    public DrawPaint(PlaceableShape<?, ?> shape) {
        this.shape = shape;
    }

    public static PaintStyle.SolidPaint createSolidPaint(Color color) {
        return color == null ? null : new SimpleSolidPaint(color);
    }

    public static PaintStyle.SolidPaint createSolidPaint(ColorStyle color) {
        return color == null ? null : new SimpleSolidPaint(color);
    }

    public Paint getPaint(Graphics2D graphics, PaintStyle paint) {
        if (paint instanceof PaintStyle.SolidPaint) {
            return this.getSolidPaint((PaintStyle.SolidPaint)paint, graphics);
        }
        if (paint instanceof PaintStyle.GradientPaint) {
            return this.getGradientPaint((PaintStyle.GradientPaint)paint, graphics);
        }
        if (paint instanceof PaintStyle.TexturePaint) {
            return this.getTexturePaint((PaintStyle.TexturePaint)paint, graphics);
        }
        return null;
    }

    protected Paint getSolidPaint(PaintStyle.SolidPaint fill, Graphics2D graphics) {
        return DrawPaint.applyColorTransform(fill.getSolidColor());
    }

    protected Paint getGradientPaint(PaintStyle.GradientPaint fill, Graphics2D graphics) {
        switch (fill.getGradientType()) {
            case linear: {
                return this.createLinearGradientPaint(fill, graphics);
            }
            case circular: {
                return this.createRadialGradientPaint(fill, graphics);
            }
            case shape: {
                return this.createPathGradientPaint(fill, graphics);
            }
        }
        throw new UnsupportedOperationException("gradient fill of type " + fill + " not supported.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Paint getTexturePaint(PaintStyle.TexturePaint fill, Graphics2D graphics) {
        BufferedImage image;
        InputStream is = fill.getImageData();
        if (is == null) {
            return null;
        }
        assert (graphics != null);
        ImageRenderer renderer = DrawPictureShape.getImageRenderer(graphics, fill.getContentType());
        try {
            try {
                renderer.loadImage(is, fill.getContentType());
            }
            finally {
                is.close();
            }
        }
        catch (IOException e) {
            LOG.log(7, new Object[]{"Can't load image data - using transparent color", e});
            return null;
        }
        int alpha = fill.getAlpha();
        if (0 <= alpha && alpha < 100000) {
            renderer.setAlpha((float)alpha / 100000.0f);
        }
        if ((image = renderer.getImage()) == null) {
            LOG.log(7, new Object[]{"Can't load image data"});
            return null;
        }
        Rectangle2D textAnchor = this.shape.getAnchor();
        TexturePaint paint = new TexturePaint(image, textAnchor);
        return paint;
    }

    public static Color applyColorTransform(ColorStyle color) {
        if (color == null || color.getColor() == null) {
            return TRANSPARENT;
        }
        Color result = color.getColor();
        double alpha = DrawPaint.getAlpha(result, color);
        double[] hsl = DrawPaint.RGB2HSL(result);
        DrawPaint.applyHslModOff(hsl, 0, color.getHueMod(), color.getHueOff());
        DrawPaint.applyHslModOff(hsl, 1, color.getSatMod(), color.getSatOff());
        DrawPaint.applyHslModOff(hsl, 2, color.getLumMod(), color.getLumOff());
        DrawPaint.applyShade(hsl, color);
        DrawPaint.applyTint(hsl, color);
        result = DrawPaint.HSL2RGB(hsl[0], hsl[1], hsl[2], alpha);
        return result;
    }

    private static double getAlpha(Color c, ColorStyle fc) {
        double alpha = (double)c.getAlpha() / 255.0;
        int fcAlpha = fc.getAlpha();
        if (fcAlpha != -1) {
            alpha *= (double)fcAlpha / 100000.0;
        }
        return Math.min(1.0, Math.max(0.0, alpha));
    }

    private static void applyHslModOff(double[] hsl, int hslPart, int mod, int off) {
        if (mod == -1) {
            mod = 100000;
        }
        if (off == -1) {
            off = 0;
        }
        if (mod != 100000 || off != 0) {
            double fOff = (double)off / 1000.0;
            double fMod = (double)mod / 100000.0;
            hsl[hslPart] = hsl[hslPart] * fMod + fOff;
        }
    }

    private static void applyShade(double[] hsl, ColorStyle fc) {
        int shade = fc.getShade();
        if (shade == -1) {
            return;
        }
        double fshade = (double)shade / 100000.0;
        hsl[2] = hsl[2] * fshade;
    }

    private static void applyTint(double[] hsl, ColorStyle fc) {
        int tint = fc.getTint();
        if (tint == -1) {
            return;
        }
        double ftint = (float)tint / 100000.0f;
        hsl[2] = hsl[2] * ftint + (100.0 - ftint * 100.0);
    }

    protected Paint createLinearGradientPaint(PaintStyle.GradientPaint fill, Graphics2D graphics) {
        double rotation;
        double angle = fill.getGradientAngle();
        Rectangle2D anchor = DrawShape.getAnchor(graphics, this.shape);
        AffineTransform at = AffineTransform.getRotateInstance(Math.toRadians(angle), anchor.getX() + anchor.getWidth() / 2.0, anchor.getY() + anchor.getHeight() / 2.0);
        double diagonal = Math.sqrt(anchor.getHeight() * anchor.getHeight() + anchor.getWidth() * anchor.getWidth());
        Point2D p1 = new Point2D.Double(anchor.getX() + anchor.getWidth() / 2.0 - diagonal / 2.0, anchor.getY() + anchor.getHeight() / 2.0);
        p1 = at.transform(p1, null);
        Point2D p2 = new Point2D.Double(anchor.getX() + anchor.getWidth(), anchor.getY() + anchor.getHeight() / 2.0);
        p2 = at.transform(p2, null);
        this.snapToAnchor(p1, anchor);
        this.snapToAnchor(p2, anchor);
        if (p1.equals(p2)) {
            return null;
        }
        float[] fractions = fill.getGradientFractions();
        Color[] colors = new Color[fractions.length];
        int i = 0;
        for (ColorStyle fc : fill.getGradientColors()) {
            colors[i++] = fc == null ? TRANSPARENT : DrawPaint.applyColorTransform(fc);
        }
        AffineTransform grAt = new AffineTransform();
        if (fill.isRotatedWithShape() && (rotation = this.shape.getRotation()) != 0.0) {
            double centerX = anchor.getX() + anchor.getWidth() / 2.0;
            double centerY = anchor.getY() + anchor.getHeight() / 2.0;
            grAt.translate(centerX, centerY);
            grAt.rotate(Math.toRadians(-rotation));
            grAt.translate(-centerX, -centerY);
        }
        return new LinearGradientPaint(p1, p2, fractions, colors, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, grAt);
    }

    protected Paint createRadialGradientPaint(PaintStyle.GradientPaint fill, Graphics2D graphics) {
        Rectangle2D anchor = DrawShape.getAnchor(graphics, this.shape);
        Point2D.Double pCenter = new Point2D.Double(anchor.getX() + anchor.getWidth() / 2.0, anchor.getY() + anchor.getHeight() / 2.0);
        float radius = (float)Math.max(anchor.getWidth(), anchor.getHeight());
        float[] fractions = fill.getGradientFractions();
        Color[] colors = new Color[fractions.length];
        int i = 0;
        for (ColorStyle fc : fill.getGradientColors()) {
            colors[i++] = DrawPaint.applyColorTransform(fc);
        }
        return new RadialGradientPaint(pCenter, radius, fractions, colors);
    }

    protected Paint createPathGradientPaint(PaintStyle.GradientPaint fill, Graphics2D graphics) {
        float[] fractions = fill.getGradientFractions();
        Color[] colors = new Color[fractions.length];
        int i = 0;
        for (ColorStyle fc : fill.getGradientColors()) {
            colors[i++] = DrawPaint.applyColorTransform(fc);
        }
        return new PathGradientPaint(colors, fractions);
    }

    protected void snapToAnchor(Point2D p, Rectangle2D anchor) {
        if (p.getX() < anchor.getX()) {
            p.setLocation(anchor.getX(), p.getY());
        } else if (p.getX() > anchor.getX() + anchor.getWidth()) {
            p.setLocation(anchor.getX() + anchor.getWidth(), p.getY());
        }
        if (p.getY() < anchor.getY()) {
            p.setLocation(p.getX(), anchor.getY());
        } else if (p.getY() > anchor.getY() + anchor.getHeight()) {
            p.setLocation(p.getX(), anchor.getY() + anchor.getHeight());
        }
    }

    private static Color HSL2RGB(double h, double s, double l, double alpha) {
        s = Math.max(0.0, Math.min(100.0, s));
        l = Math.max(0.0, Math.min(100.0, l));
        if (alpha < 0.0 || alpha > 1.0) {
            String message = "Color parameter outside of expected range - Alpha: " + alpha;
            throw new IllegalArgumentException(message);
        }
        h %= 360.0;
        double q = (l /= 100.0) < 0.5 ? l * (1.0 + s) : l + (s /= 100.0) - s * l;
        double p = 2.0 * l - q;
        double r = Math.max(0.0, DrawPaint.HUE2RGB(p, q, (h /= 360.0) + 0.3333333333333333));
        double g = Math.max(0.0, DrawPaint.HUE2RGB(p, q, h));
        double b = Math.max(0.0, DrawPaint.HUE2RGB(p, q, h - 0.3333333333333333));
        r = Math.min(r, 1.0);
        g = Math.min(g, 1.0);
        b = Math.min(b, 1.0);
        return new Color((float)r, (float)g, (float)b, (float)alpha);
    }

    private static double HUE2RGB(double p, double q, double h) {
        if (h < 0.0) {
            h += 1.0;
        }
        if (h > 1.0) {
            h -= 1.0;
        }
        if (6.0 * h < 1.0) {
            return p + (q - p) * 6.0 * h;
        }
        if (2.0 * h < 1.0) {
            return q;
        }
        if (3.0 * h < 2.0) {
            return p + (q - p) * 6.0 * (0.6666666666666666 - h);
        }
        return p;
    }

    private static double[] RGB2HSL(Color color) {
        float[] rgb = color.getRGBColorComponents(null);
        double r = rgb[0];
        double g = rgb[1];
        double b = rgb[2];
        double min = Math.min(r, Math.min(g, b));
        double max = Math.max(r, Math.max(g, b));
        double h = 0.0;
        if (max == min) {
            h = 0.0;
        } else if (max == r) {
            h = (60.0 * (g - b) / (max - min) + 360.0) % 360.0;
        } else if (max == g) {
            h = 60.0 * (b - r) / (max - min) + 120.0;
        } else if (max == b) {
            h = 60.0 * (r - g) / (max - min) + 240.0;
        }
        double l = (max + min) / 2.0;
        double s = 0.0;
        s = max == min ? 0.0 : (l <= 0.5 ? (max - min) / (max + min) : (max - min) / (2.0 - max - min));
        return new double[]{h, s * 100.0, l * 100.0};
    }

    private static class SimpleSolidPaint
    implements PaintStyle.SolidPaint {
        private final ColorStyle solidColor;

        SimpleSolidPaint(final Color color) {
            if (color == null) {
                throw new NullPointerException("Color needs to be specified");
            }
            this.solidColor = new ColorStyle(){

                public Color getColor() {
                    return new Color(color.getRed(), color.getGreen(), color.getBlue());
                }

                public int getAlpha() {
                    return (int)Math.round((double)color.getAlpha() * 100000.0 / 255.0);
                }

                public int getHueOff() {
                    return -1;
                }

                public int getHueMod() {
                    return -1;
                }

                public int getSatOff() {
                    return -1;
                }

                public int getSatMod() {
                    return -1;
                }

                public int getLumOff() {
                    return -1;
                }

                public int getLumMod() {
                    return -1;
                }

                public int getShade() {
                    return -1;
                }

                public int getTint() {
                    return -1;
                }
            };
        }

        SimpleSolidPaint(ColorStyle color) {
            if (color == null) {
                throw new NullPointerException("Color needs to be specified");
            }
            this.solidColor = color;
        }

        public ColorStyle getSolidColor() {
            return this.solidColor;
        }
    }
}

