/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.hsqldb.lib;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import java.util.StringTokenizer;

public class RCData {
    public static final String DEFAULT_JDBC_DRIVER = "com.fr.third.org.hsqldb.jdbcDriver";
    private String defaultJdbcDriverName = "com.fr.third.org.hsqldb.jdbcDriver";
    public String id = null;
    public String url = null;
    public String username = null;
    public String password = null;
    public String ti = null;
    public String driver = null;
    public String charset = null;
    public String truststore = null;
    public String libpath = null;

    public void setDefaultJdbcDriver(String defaultJdbcDriverName) {
        this.defaultJdbcDriverName = defaultJdbcDriverName;
    }

    public String getDefaultJdbcDriverName() {
        return this.defaultJdbcDriverName;
    }

    /*
     * WARNING - void declaration
     */
    public RCData(File file, String dbKey) throws Exception {
        String s;
        if (file == null) {
            throw new IllegalArgumentException("RC file name not specified");
        }
        if (!file.canRead()) {
            throw new IOException("Please set up authentication file '" + file + "'");
        }
        StringTokenizer tokenizer = null;
        boolean thisone = false;
        int linenum = 0;
        BufferedReader br = new BufferedReader(new FileReader(file));
        while ((s = br.readLine()) != null) {
            void var7_9;
            void var6_8;
            String value;
            String keyword;
            ++linenum;
            if ((s = s.trim()).length() == 0 || s.charAt(0) == '#') continue;
            tokenizer = new StringTokenizer(s);
            if (tokenizer.countTokens() == 1) {
                keyword = tokenizer.nextToken();
                value = "";
            } else if (tokenizer.countTokens() > 1) {
                keyword = tokenizer.nextToken();
                value = tokenizer.nextToken("").trim();
            } else {
                try {
                    br.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                throw new Exception("Corrupt line " + linenum + " in '" + file + "':  " + s);
            }
            if (dbKey == null) {
                if (!var6_8.equals("urlid")) continue;
                System.out.println((String)var7_9);
                continue;
            }
            if (var6_8.equals("urlid")) {
                if (var7_9.equals(dbKey)) {
                    if (this.id == null) {
                        this.id = dbKey;
                        thisone = true;
                        continue;
                    }
                    try {
                        br.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    throw new Exception("Key '" + dbKey + " redefined at" + " line " + linenum + " in '" + file);
                }
                thisone = false;
                continue;
            }
            if (!thisone) continue;
            if (var6_8.equals("url")) {
                this.url = var7_9;
                continue;
            }
            if (var6_8.equals("username")) {
                this.username = var7_9;
                continue;
            }
            if (var6_8.equals("driver")) {
                this.driver = var7_9;
                continue;
            }
            if (var6_8.equals("charset")) {
                this.charset = var7_9;
                continue;
            }
            if (var6_8.equals("truststore")) {
                this.truststore = var7_9;
                continue;
            }
            if (var6_8.equals("password")) {
                this.password = var7_9;
                continue;
            }
            if (var6_8.equals("transiso")) {
                this.ti = var7_9;
                continue;
            }
            if (var6_8.equals("libpath")) {
                this.libpath = var7_9;
                continue;
            }
            try {
                br.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            throw new Exception("Bad line " + linenum + " in '" + file + "':  " + s);
        }
        br.close();
        if (dbKey == null) {
            return;
        }
        if (this.url == null) {
            throw new Exception("url not set for '" + dbKey + "' in file '" + file + "'");
        }
        if (this.libpath != null) {
            throw new IllegalArgumentException("Sorry, 'libpath' not supported yet");
        }
    }

    public RCData(String id, String url, String username, String password, String driver, String charset, String truststore) throws Exception {
        this(id, url, username, password, driver, charset, truststore, null);
    }

    public RCData(String id, String url, String username, String password, String driver, String charset, String truststore, String libpath) throws Exception {
        this(id, url, username, password, driver, charset, truststore, libpath, null);
    }

    public RCData(String id, String url, String username, String password, String driver, String charset, String truststore, String libpath, String ti) throws Exception {
        this.id = id;
        this.url = url;
        this.username = username;
        this.password = password;
        this.ti = ti;
        this.driver = driver;
        this.charset = charset;
        this.truststore = truststore;
        this.libpath = libpath;
        if (libpath != null) {
            throw new IllegalArgumentException("Sorry, 'libpath' not supported yet");
        }
        if (id == null || url == null) {
            throw new Exception("id or url was not set");
        }
    }

    public Connection getConnection() throws ClassNotFoundException, SQLException, MalformedURLException {
        return this.getConnection(null, null, null);
    }

    public Connection getConnection(String curDriverIn, String curCharsetIn, String curTrustStoreIn) throws ClassNotFoundException, MalformedURLException, SQLException {
        Connection c;
        String curDriver = curDriverIn;
        String curCharset = curCharsetIn;
        String curTrustStore = curTrustStoreIn;
        Properties sysProps = System.getProperties();
        if (curDriver == null) {
            String string = curDriver = this.driver == null ? DEFAULT_JDBC_DRIVER : this.driver;
        }
        if (curCharset == null && this.charset != null) {
            curCharset = this.charset;
        }
        if (curTrustStore == null && this.truststore != null) {
            curTrustStore = this.truststore;
        }
        if (curCharset == null) {
            sysProps.remove("sqlfile.charset");
        } else {
            sysProps.put("sqlfile.charset", curCharset);
        }
        if (curTrustStore == null) {
            sysProps.remove("javax.net.ssl.trustStore");
        } else {
            sysProps.put("javax.net.ssl.trustStore", curTrustStore);
        }
        String urlString = null;
        try {
            urlString = RCData.expandSysPropVars(this.url);
        }
        catch (IllegalArgumentException iae) {
            throw new MalformedURLException(iae.getMessage() + " for URL '" + this.url + "'");
        }
        String userString = null;
        if (this.username != null) {
            try {
                userString = RCData.expandSysPropVars(this.username);
            }
            catch (IllegalArgumentException iae) {
                throw new MalformedURLException(iae.getMessage() + " for user name '" + this.username + "'");
            }
        }
        String passwordString = null;
        if (this.password != null) {
            try {
                passwordString = RCData.expandSysPropVars(this.password);
            }
            catch (IllegalArgumentException iae) {
                throw new MalformedURLException(iae.getMessage() + " for password");
            }
        }
        Class.forName(curDriver);
        Connection connection = c = userString == null ? DriverManager.getConnection(urlString) : DriverManager.getConnection(urlString, userString, passwordString);
        if (this.ti != null) {
            RCData.setTI(c, this.ti);
        }
        return c;
    }

    public static String expandSysPropVars(String inString) {
        int varEnd;
        int varOffset;
        String outString = new String(inString);
        while ((varOffset = outString.indexOf("${")) >= 0 && (varEnd = outString.indexOf(125, varOffset + 2)) >= 0) {
            String varName = outString.substring(varOffset + 2, varEnd);
            if (varName.length() < 1) {
                throw new IllegalArgumentException("Bad variable setting");
            }
            String varVal = System.getProperty(varName);
            if (varVal == null) {
                throw new IllegalArgumentException("No Java system property with name '" + varName + "'");
            }
            outString = outString.substring(0, varOffset) + varVal + outString.substring(varEnd + 1);
        }
        return outString;
    }

    public static void setTI(Connection c, String tiString) throws SQLException {
        int i = -1;
        if (tiString.equals("TRANSACTION_READ_UNCOMMITTED")) {
            i = 1;
        }
        if (tiString.equals("TRANSACTION_READ_COMMITTED")) {
            i = 2;
        }
        if (tiString.equals("TRANSACTION_REPEATABLE_READ")) {
            i = 4;
        }
        if (tiString.equals("TRANSACTION_SERIALIZABLE")) {
            i = 8;
        }
        if (tiString.equals("TRANSACTION_NONE")) {
            i = 0;
        }
        if (i < 0) {
            throw new SQLException("Trans. isol. value not supported by " + RCData.class.getName() + ": " + tiString);
        }
        c.setTransactionIsolation(i);
    }

    public static String tiToString(int ti) {
        switch (ti) {
            case 1: {
                return "TRANSACTION_READ_UNCOMMITTED";
            }
            case 2: {
                return "TRANSACTION_READ_COMMITTED";
            }
            case 4: {
                return "TRANSACTION_REPEATABLE_READ";
            }
            case 8: {
                return "TRANSACTION_SERIALIZABLE";
            }
            case 0: {
                return "TRANSACTION_NONE";
            }
        }
        return "Custom Transaction Isolation numerical value: " + ti;
    }
}

