/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.hsqldb;

import com.fr.third.org.hsqldb.Column;
import com.fr.third.org.hsqldb.Database;
import com.fr.third.org.hsqldb.Expression;
import com.fr.third.org.hsqldb.HsqlException;
import com.fr.third.org.hsqldb.HsqlNameManager;
import com.fr.third.org.hsqldb.Result;
import com.fr.third.org.hsqldb.Select;
import com.fr.third.org.hsqldb.Session;
import com.fr.third.org.hsqldb.SubQuery;
import com.fr.third.org.hsqldb.Table;
import com.fr.third.org.hsqldb.TableFilter;
import com.fr.third.org.hsqldb.Trace;

final class CompiledStatement {
    static final String PCOL_PREFIX = "@p";
    static final String RETURN_COLUMN_NAME = "@p0";
    static final int UNKNOWN = 0;
    static final int INSERT_VALUES = 1;
    static final int INSERT_SELECT = 2;
    static final int UPDATE = 3;
    static final int DELETE = 4;
    static final int SELECT = 5;
    static final int SELECT_INTO = 6;
    static final int CALL = 7;
    static final int DML = 7;
    static final int DQL = 8;
    static final int DDL = 9;
    int id;
    boolean isValid = true;
    Table targetTable;
    TableFilter targetFilter;
    Expression condition;
    int[] columnMap;
    Expression[] columnValues;
    boolean[] checkColumns;
    Expression expression;
    Select select;
    Expression[] parameters;
    int[] paramTypes;
    SubQuery[] subqueries;
    int type;
    String sql;
    final HsqlNameManager.HsqlName schemaHsqlName;
    private static final Result updateCountResult = new Result(1);

    CompiledStatement(HsqlNameManager.HsqlName schema) {
        this.parameters = new Expression[0];
        this.paramTypes = new int[0];
        this.subqueries = new SubQuery[0];
        this.type = 9;
        this.schemaHsqlName = schema;
    }

    CompiledStatement(Session session, Database database, HsqlNameManager.HsqlName schema, TableFilter targetFilter, Expression deleteCondition, SubQuery[] subqueries, Expression[] params) throws HsqlException {
        this.schemaHsqlName = schema;
        this.targetFilter = targetFilter;
        this.targetTable = targetFilter.filterTable;
        if (deleteCondition != null) {
            this.condition = new Expression(deleteCondition);
            this.condition.resolveTables(targetFilter);
            this.condition.resolveTypes(session);
            targetFilter.setConditions(session, this.condition);
        }
        this.setParameters(params);
        this.setSubqueries(subqueries);
        this.type = 4;
    }

    CompiledStatement(Session session, Database database, HsqlNameManager.HsqlName schema, TableFilter targetFilter, int[] columnMap, Expression[] columnValues, Expression updateCondition, SubQuery[] subqueries, Expression[] params) throws HsqlException {
        this.schemaHsqlName = schema;
        this.targetFilter = targetFilter;
        this.targetTable = targetFilter.filterTable;
        this.columnMap = columnMap;
        this.columnValues = columnValues;
        for (int i = 0; i < columnValues.length; ++i) {
            Expression cve = columnValues[i];
            if (cve.isParam()) {
                cve.setTableColumnAttributes(this.targetTable, columnMap[i]);
                continue;
            }
            cve.resolveTables(targetFilter);
            cve.resolveTypes(session);
        }
        if (updateCondition != null) {
            this.condition = new Expression(updateCondition);
            this.condition.resolveTables(targetFilter);
            this.condition.resolveTypes(session);
            targetFilter.setConditions(session, this.condition);
        }
        this.setParameters(params);
        this.setSubqueries(subqueries);
        this.type = 3;
    }

    CompiledStatement(HsqlNameManager.HsqlName schema, Table targetTable, int[] columnMap, Expression[] columnValues, boolean[] checkColumns, SubQuery[] subqueries, Expression[] params) throws HsqlException {
        this.schemaHsqlName = schema;
        this.targetTable = targetTable;
        this.columnMap = columnMap;
        this.checkColumns = checkColumns;
        this.columnValues = columnValues;
        for (int i = 0; i < columnValues.length; ++i) {
            Expression cve = columnValues[i];
            if (!cve.isParam()) continue;
            cve.setTableColumnAttributes(targetTable, columnMap[i]);
        }
        this.setParameters(params);
        this.setSubqueries(subqueries);
        this.type = 1;
    }

    CompiledStatement(Session session, Database database, HsqlNameManager.HsqlName schema, Table targetTable, int[] columnMap, boolean[] checkColumns, Select select, SubQuery[] subqueries, Expression[] params) throws HsqlException {
        this.schemaHsqlName = schema;
        this.targetTable = targetTable;
        this.columnMap = columnMap;
        this.checkColumns = checkColumns;
        this.select = select;
        this.resolveInsertParameterTypes();
        select.prepareResult(session);
        this.setParameters(params);
        this.setSubqueries(subqueries);
        this.type = 2;
    }

    CompiledStatement(Session session, Database database, HsqlNameManager.HsqlName schema, Select select, SubQuery[] subqueries, Expression[] params) throws HsqlException {
        this.schemaHsqlName = schema;
        this.select = select;
        for (int i = 0; i < select.iResultLen; ++i) {
            Expression colexpr = select.exprColumns[i];
            if (colexpr.getDataType() != 0) continue;
            colexpr.setDataType(12);
        }
        select.prepareResult(session);
        this.setParameters(params);
        this.setSubqueries(subqueries);
        this.type = 5;
    }

    CompiledStatement(Session session, Database database, HsqlNameManager.HsqlName schema, Expression expression, SubQuery[] subqueries, Expression[] params) throws HsqlException {
        this.schemaHsqlName = schema;
        this.expression = expression;
        expression.resolveTypes(session);
        expression.paramMode = 4;
        this.setParameters(params);
        this.setSubqueries(subqueries);
        this.type = 7;
    }

    private void resolveInsertParameterTypes() {
        for (int i = 0; i < this.select.iResultLen; ++i) {
            Expression colexpr = this.select.exprColumns[i];
            if (colexpr.getDataType() != 0) continue;
            Column col = this.targetTable.getColumn(this.columnMap[i]);
            colexpr.setDataType(col.getType());
        }
    }

    private void setParameters(Expression[] params) {
        this.parameters = params;
        int[] types = new int[this.parameters.length];
        for (int i = 0; i < this.parameters.length; ++i) {
            types[i] = this.parameters[i].getDataType();
        }
        this.paramTypes = types;
    }

    private void setSubqueries(SubQuery[] subqueries) {
        this.subqueries = subqueries;
    }

    void materializeSubQueries(Session session) throws HsqlException {
        for (int i = 0; i < this.subqueries.length; ++i) {
            SubQuery sq = this.subqueries[i];
            if (sq.isMaterialised || !sq.isResolved) continue;
            sq.populateTable(session);
            sq.isMaterialised = true;
        }
    }

    void dematerializeSubQueries(Session session) {
        if (this.subqueries == null) {
            return;
        }
        for (int i = 0; i < this.subqueries.length; ++i) {
            this.subqueries[i].table.clearAllRows(session);
            this.subqueries[i].isMaterialised = false;
        }
    }

    void clearVariables() {
        this.isValid = false;
        this.targetTable = null;
        this.targetFilter = null;
        this.condition = null;
        this.columnMap = null;
        this.columnValues = null;
        this.checkColumns = null;
        this.expression = null;
        this.select = null;
        this.parameters = null;
        this.paramTypes = null;
        this.subqueries = null;
    }

    boolean canExecute(Session session) throws HsqlException {
        switch (this.type) {
            case 5: 
            case 7: {
                for (int i = 0; i < this.select.tFilter.length; ++i) {
                    HsqlNameManager.HsqlName name = this.select.tFilter[i].filterTable.getName();
                    session.check(name, 1);
                }
                break;
            }
            case 2: {
                break;
            }
            case 4: {
                session.check(this.targetTable.getName(), 2);
                break;
            }
            case 1: {
                session.check(this.targetTable.getName(), 4);
                break;
            }
            case 3: {
                session.check(this.targetTable.getName(), 8);
                break;
            }
        }
        return true;
    }

    void checkTableWriteAccess(Session session, Table table) throws HsqlException {
        session.checkReadWrite();
        if (table.isView()) {
            throw Trace.error(55, table.getName().name);
        }
        table.checkDataReadOnly();
    }

    Result describeResult() {
        switch (this.type) {
            case 7: {
                Expression e = this.expression;
                Result r = Result.newSingleColumnResult(RETURN_COLUMN_NAME, e.getDataType());
                r.metaData.classNames[0] = e.getValueClassName();
                return r;
            }
            case 5: {
                return this.select.sIntoTable == null ? this.select.describeResult() : updateCountResult;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 9: {
                return updateCountResult;
            }
        }
        return new Result(Trace.runtimeError(201, "CompiledStatement.describeResult()"), null);
    }

    Result describeParameters() {
        int outlen = this.parameters.length;
        int offset = 0;
        Result out = Result.newParameterDescriptionResult(outlen);
        for (int i = 0; i < this.parameters.length; ++i) {
            Expression e = this.parameters[i];
            int idx = i + offset;
            out.metaData.colNames[idx] = PCOL_PREFIX + (i + 1);
            out.metaData.classNames[idx] = e.getValueClassName();
            out.metaData.colTypes[idx] = e.getDataType();
            out.metaData.colSizes[idx] = e.getColumnSize();
            out.metaData.colScales[idx] = e.getColumnScale();
            out.metaData.colNullable[idx] = e.nullability;
            out.metaData.isIdentity[idx] = e.isIdentity;
            out.metaData.paramMode[idx] = e.paramMode;
        }
        return out;
    }

    public String describe(Session session) {
        try {
            return this.describeImpl(session);
        }
        catch (Exception e) {
            return e.toString();
        }
    }

    private String describeImpl(Session session) throws Exception {
        StringBuffer sb = new StringBuffer();
        switch (this.type) {
            case 5: {
                sb.append(this.select.describe(session));
                this.appendParms(sb).append('\n');
                this.appendSubqueries(sb);
                return sb.toString();
            }
            case 1: {
                sb.append("INSERT VALUES");
                sb.append('[').append('\n');
                this.appendColumns(sb).append('\n');
                this.appendTable(sb).append('\n');
                this.appendParms(sb).append('\n');
                this.appendSubqueries(sb).append(']');
                return sb.toString();
            }
            case 2: {
                sb.append("INSERT SELECT");
                sb.append('[').append('\n');
                this.appendColumns(sb).append('\n');
                this.appendTable(sb).append('\n');
                sb.append(this.select.describe(session)).append('\n');
                this.appendParms(sb).append('\n');
                this.appendSubqueries(sb).append(']');
                return sb.toString();
            }
            case 3: {
                sb.append("UPDATE");
                sb.append('[').append('\n');
                this.appendColumns(sb).append('\n');
                this.appendTable(sb).append('\n');
                this.appendCondition(session, sb);
                sb.append(this.targetFilter.describe(session)).append('\n');
                this.appendParms(sb).append('\n');
                this.appendSubqueries(sb).append(']');
                return sb.toString();
            }
            case 4: {
                sb.append("DELETE");
                sb.append('[').append('\n');
                this.appendTable(sb).append('\n');
                this.appendCondition(session, sb);
                sb.append(this.targetFilter.describe(session)).append('\n');
                this.appendParms(sb).append('\n');
                this.appendSubqueries(sb).append(']');
                return sb.toString();
            }
            case 7: {
                sb.append("CALL");
                sb.append('[');
                sb.append(this.expression.describe(session)).append('\n');
                this.appendParms(sb).append('\n');
                this.appendSubqueries(sb).append(']');
                return sb.toString();
            }
        }
        return "UNKNOWN";
    }

    private StringBuffer appendSubqueries(StringBuffer sb) {
        sb.append("SUBQUERIES[");
        for (int i = 0; i < this.subqueries.length; ++i) {
            sb.append("\n[level=").append(this.subqueries[i].level).append('\n').append("hasParams=").append(this.subqueries[i].hasParams).append('\n');
            if (this.subqueries[i].select != null) {
                sb.append("com.fr.third.org.hsqldb.Select@").append(Integer.toHexString(this.subqueries[i].select.hashCode()));
            }
            sb.append("]");
        }
        sb.append(']');
        return sb;
    }

    private StringBuffer appendTable(StringBuffer sb) {
        sb.append("TABLE[").append(this.targetTable.getName().name).append(']');
        return sb;
    }

    private StringBuffer appendColumns(StringBuffer sb) {
        sb.append("COLUMNS=[");
        for (int i = 0; i < this.columnMap.length; ++i) {
            sb.append('\n').append(this.columnMap[i]).append(':').append(' ').append(this.targetTable.getColumn((int)this.columnMap[i]).columnName.name).append('[').append(this.columnValues[i]).append(']');
        }
        sb.append(']');
        return sb;
    }

    private StringBuffer appendParms(StringBuffer sb) {
        sb.append("PARAMETERS=[");
        for (int i = 0; i < this.parameters.length; ++i) {
            sb.append('\n').append('@').append(i).append('[').append(this.parameters[i]).append(']');
        }
        sb.append(']');
        return sb;
    }

    private StringBuffer appendCondition(Session session, StringBuffer sb) {
        return this.condition == null ? sb.append("CONDITION[]\n") : sb.append("CONDITION[").append(this.condition.describe(session)).append("]\n");
    }
}

