/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record.formula;

import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.hssf.record.formula.ControlPtg;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFWorkbook;
import com.fr.third.org.apache.poi.util.LittleEndian;

public final class ExpPtg
extends ControlPtg {
    private static final int SIZE = 5;
    public static final short sid = 1;
    private final short field_1_first_row;
    private final short field_2_first_col;

    public ExpPtg(RecordInputStream in) {
        this.field_1_first_row = in.readShort();
        this.field_2_first_col = in.readShort();
    }

    public void writeBytes(byte[] array, int offset) {
        array[offset + 0] = 1;
        LittleEndian.putShort(array, offset + 1, this.field_1_first_row);
        LittleEndian.putShort(array, offset + 3, this.field_2_first_col);
    }

    public int getSize() {
        return 5;
    }

    public short getRow() {
        return this.field_1_first_row;
    }

    public short getColumn() {
        return this.field_2_first_col;
    }

    public String toFormulaString(HSSFWorkbook book) {
        throw new RecordFormatException("Coding Error: Expected ExpPtg to be converted from Shared to Non-Shared Formula by ValueRecordsAggregate, but it wasn't");
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("[Array Formula or Shared Formula]\n");
        buffer.append("row = ").append(this.getRow()).append("\n");
        buffer.append("col = ").append(this.getColumn()).append("\n");
        return buffer.toString();
    }
}

