/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.signatures;

import com.fr.third.fr.pdf.signatures.DigestAlgorithms;
import com.fr.third.fr.pdf.signatures.IExternalDigest;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.jcajce.provider.digest.GOST3411;
import org.bouncycastle.jcajce.provider.digest.MD2;
import org.bouncycastle.jcajce.provider.digest.MD5;
import org.bouncycastle.jcajce.provider.digest.RIPEMD128;
import org.bouncycastle.jcajce.provider.digest.RIPEMD160;
import org.bouncycastle.jcajce.provider.digest.RIPEMD256;
import org.bouncycastle.jcajce.provider.digest.SHA1;
import org.bouncycastle.jcajce.provider.digest.SHA224;
import org.bouncycastle.jcajce.provider.digest.SHA256;
import org.bouncycastle.jcajce.provider.digest.SHA384;
import org.bouncycastle.jcajce.provider.digest.SHA512;

public class BouncyCastleDigest
implements IExternalDigest {
    private static Map<String, DigestHelper> digestHelperMap = new HashMap<String, DigestHelper>();

    public MessageDigest getMessageDigest(String hashAlgorithm) throws GeneralSecurityException {
        String oid = DigestAlgorithms.getAllowedDigest(hashAlgorithm);
        DigestHelper helper = digestHelperMap.get(oid);
        if (helper != null) {
            return helper.createDigest();
        }
        throw new NoSuchAlgorithmException(hashAlgorithm);
    }

    static {
        digestHelperMap.put("1.2.840.113549.2.2", new DigestHelper(){

            public MessageDigest createDigest() {
                return new MD2.Digest();
            }
        });
        digestHelperMap.put("1.2.840.113549.2.5", new DigestHelper(){

            public MessageDigest createDigest() {
                return new MD5.Digest();
            }
        });
        digestHelperMap.put("1.3.14.3.2.26", new DigestHelper(){

            public MessageDigest createDigest() {
                return new SHA1.Digest();
            }
        });
        digestHelperMap.put("2.16.840.1.101.3.4.2.4", new DigestHelper(){

            public MessageDigest createDigest() {
                return new SHA224.Digest();
            }
        });
        digestHelperMap.put("2.16.840.1.101.3.4.2.1", new DigestHelper(){

            public MessageDigest createDigest() {
                return new SHA256.Digest();
            }
        });
        digestHelperMap.put("2.16.840.1.101.3.4.2.2", new DigestHelper(){

            public MessageDigest createDigest() {
                return new SHA384.Digest();
            }
        });
        digestHelperMap.put("2.16.840.1.101.3.4.2.3", new DigestHelper(){

            public MessageDigest createDigest() {
                return new SHA512.Digest();
            }
        });
        digestHelperMap.put("1.3.36.3.2.2", new DigestHelper(){

            public MessageDigest createDigest() {
                return new RIPEMD128.Digest();
            }
        });
        digestHelperMap.put("1.3.36.3.2.1", new DigestHelper(){

            public MessageDigest createDigest() {
                return new RIPEMD160.Digest();
            }
        });
        digestHelperMap.put("11.3.36.3.2.3", new DigestHelper(){

            public MessageDigest createDigest() {
                return new RIPEMD256.Digest();
            }
        });
        digestHelperMap.put("1.2.643.2.2.9", new DigestHelper(){

            public MessageDigest createDigest() {
                return new GOST3411.Digest();
            }
        });
    }

    private static interface DigestHelper {
        public MessageDigest createDigest();
    }
}

