/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.layout.renderer;

import com.fr.third.fr.pdf.layout.layout.LayoutArea;
import com.fr.third.fr.pdf.layout.layout.LayoutContext;
import com.fr.third.fr.pdf.layout.layout.LayoutResult;
import com.fr.third.fr.pdf.layout.renderer.AbstractRenderer;
import com.fr.third.fr.pdf.layout.renderer.AreaBreakRenderer;
import com.fr.third.fr.pdf.layout.renderer.IRenderer;
import com.fr.third.fr.pdf.layout.renderer.ImageRenderer;
import com.fr.third.fr.pdf.slf4j.Logger;
import com.fr.third.fr.pdf.slf4j.LoggerFactory;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RootRenderer
extends AbstractRenderer {
    protected boolean immediateFlush = true;
    protected LayoutArea currentArea;
    protected int currentPageNumber;

    @Override
    public void addChild(IRenderer renderer) {
        super.addChild(renderer);
        if (this.currentArea == null) {
            this.updateCurrentArea(null);
        }
        if (this.currentArea != null && !this.childRenderers.isEmpty() && this.childRenderers.get(this.childRenderers.size() - 1) == renderer) {
            ArrayList<IRenderer> resultRenderers = new ArrayList<IRenderer>();
            LayoutResult result = null;
            LayoutArea storedArea = null;
            LayoutArea nextStoredArea = null;
            while (this.currentArea != null && renderer != null && (result = renderer.layout(new LayoutContext(this.currentArea.clone()))).getStatus() != 1) {
                if (result.getStatus() == 2) {
                    if (result.getOverflowRenderer() instanceof ImageRenderer) {
                        ((ImageRenderer)result.getOverflowRenderer()).autoScale(this.currentArea);
                    } else {
                        this.processRenderer(result.getSplitRenderer(), resultRenderers);
                        if (nextStoredArea != null) {
                            this.currentArea = nextStoredArea;
                            this.currentPageNumber = nextStoredArea.getPageNumber();
                            nextStoredArea = null;
                        } else {
                            this.updateCurrentArea(result);
                        }
                    }
                } else if (result.getStatus() == 3) {
                    if (result.getOverflowRenderer() instanceof ImageRenderer) {
                        if (this.currentArea.getBBox().getHeight() < ((ImageRenderer)result.getOverflowRenderer()).imageHeight && !this.currentArea.isEmptyArea()) {
                            this.updateCurrentArea(result);
                        }
                        ((ImageRenderer)result.getOverflowRenderer()).autoScale(this.currentArea);
                    } else {
                        if (this.currentArea.isEmptyArea() && !(renderer instanceof AreaBreakRenderer)) {
                            Logger logger;
                            if (Boolean.valueOf(true).equals(result.getOverflowRenderer().getModelElement().getProperty(32))) {
                                result.getOverflowRenderer().getModelElement().setProperty(32, false);
                                logger = LoggerFactory.getLogger(RootRenderer.class);
                                logger.warn(MessageFormat.format("Element does not fit current area. {0}", "KeepTogether property will be ignored."));
                                if (storedArea != null) {
                                    nextStoredArea = this.currentArea;
                                    this.currentArea = storedArea;
                                    this.currentPageNumber = storedArea.getPageNumber();
                                }
                                storedArea = this.currentArea;
                            } else {
                                result.getOverflowRenderer().setProperty(26, true);
                                logger = LoggerFactory.getLogger(RootRenderer.class);
                                logger.warn(MessageFormat.format("Element does not fit current area. {0}", ""));
                            }
                            renderer = result.getOverflowRenderer();
                            continue;
                        }
                        storedArea = this.currentArea;
                        this.updateCurrentArea(result);
                    }
                }
                renderer = result.getOverflowRenderer();
            }
            if (this.currentArea != null) {
                assert (result != null && result.getOccupiedArea() != null);
                this.currentArea.getBBox().setHeight(this.currentArea.getBBox().getHeight() - result.getOccupiedArea().getBBox().getHeight());
                this.currentArea.setEmptyArea(false);
                if (renderer != null) {
                    this.processRenderer(renderer, resultRenderers);
                }
            }
            this.childRenderers.remove(this.childRenderers.size() - 1);
            if (!this.immediateFlush) {
                this.childRenderers.addAll(resultRenderers);
            }
        } else if (this.positionedRenderers.size() > 0 && this.positionedRenderers.get(this.positionedRenderers.size() - 1) == renderer) {
            Integer positionedPageNumber = (Integer)renderer.getProperty(51);
            if (positionedPageNumber == null) {
                positionedPageNumber = this.currentPageNumber;
            }
            renderer.layout(new LayoutContext(new LayoutArea(positionedPageNumber, this.currentArea.getBBox().clone())));
            if (this.immediateFlush) {
                this.flushSingleRenderer(renderer);
                this.positionedRenderers.remove(this.positionedRenderers.size() - 1);
            }
        }
    }

    public void flush() {
        for (IRenderer resultRenderer : this.childRenderers) {
            this.flushSingleRenderer(resultRenderer);
        }
        for (IRenderer resultRenderer : this.positionedRenderers) {
            this.flushSingleRenderer(resultRenderer);
        }
        this.childRenderers.clear();
        this.positionedRenderers.clear();
    }

    @Override
    public LayoutResult layout(LayoutContext layoutContext) {
        throw new IllegalStateException("Layout is not supported for root renderers.");
    }

    public LayoutArea getCurrentArea() {
        if (this.currentArea == null) {
            this.updateCurrentArea(null);
        }
        return this.currentArea;
    }

    protected abstract void flushSingleRenderer(IRenderer var1);

    protected abstract LayoutArea updateCurrentArea(LayoutResult var1);

    private void processRenderer(IRenderer renderer, List<IRenderer> resultRenderers) {
        this.alignChildHorizontally(renderer, this.currentArea.getBBox().getWidth());
        if (this.immediateFlush) {
            this.flushSingleRenderer(renderer);
        } else {
            resultRenderers.add(renderer);
        }
    }
}

