/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.layout.renderer;

import com.fr.third.fr.pdf.kernel.color.Color;
import com.fr.third.fr.pdf.kernel.font.PdfFont;
import com.fr.third.fr.pdf.kernel.geom.Rectangle;
import com.fr.third.fr.pdf.kernel.pdf.PdfDocument;
import com.fr.third.fr.pdf.kernel.pdf.canvas.CanvasArtifact;
import com.fr.third.fr.pdf.kernel.pdf.canvas.PdfCanvas;
import com.fr.third.fr.pdf.kernel.pdf.tagutils.IAccessibleElement;
import com.fr.third.fr.pdf.layout.IPropertyContainer;
import com.fr.third.fr.pdf.layout.border.Border;
import com.fr.third.fr.pdf.layout.element.IElement;
import com.fr.third.fr.pdf.layout.layout.LayoutArea;
import com.fr.third.fr.pdf.layout.property.Background;
import com.fr.third.fr.pdf.layout.property.BaseDirection;
import com.fr.third.fr.pdf.layout.property.HorizontalAlignment;
import com.fr.third.fr.pdf.layout.property.Property;
import com.fr.third.fr.pdf.layout.property.TextAlignment;
import com.fr.third.fr.pdf.layout.property.VerticalAlignment;
import com.fr.third.fr.pdf.layout.renderer.DrawContext;
import com.fr.third.fr.pdf.layout.renderer.FloatPropertiesMap;
import com.fr.third.fr.pdf.layout.renderer.IRenderer;
import com.fr.third.fr.pdf.layout.renderer.PropertiesMap;
import com.fr.third.fr.pdf.slf4j.Logger;
import com.fr.third.fr.pdf.slf4j.LoggerFactory;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRenderer
implements IRenderer {
    public static final float EPS = 1.0E-4f;
    public static final float INF = 1000000.0f;
    protected List<IRenderer> childRenderers = new ArrayList<IRenderer>();
    protected List<IRenderer> positionedRenderers = new ArrayList<IRenderer>();
    protected IPropertyContainer modelElement;
    protected boolean flushed = false;
    protected LayoutArea occupiedArea;
    protected IRenderer parent;
    protected PropertiesMap properties = new PropertiesMap();
    protected FloatPropertiesMap floatProperties = new FloatPropertiesMap();
    protected boolean isLastRendererForModelElement = true;
    private static Integer DefaultLayoutPosition = 1;
    private PdfFont font = null;
    private boolean italic = false;
    private boolean bold = false;
    private Border border = null;
    private Border topBorder = null;
    private Border rightBorder = null;
    private Border bottomBorder = null;
    private Border leftBorder = null;
    private Background background;
    private TextAlignment alignment;
    private VerticalAlignment verticalAlignment;
    private float width;
    private Color fontColor;
    private Color strokeColor;
    private HorizontalAlignment horizontalAlignment;
    private Object underLine;
    private BaseDirection direction;
    private float font_size;

    protected AbstractRenderer() {
    }

    protected AbstractRenderer(IElement modelElement) {
        this.modelElement = modelElement;
    }

    protected AbstractRenderer(AbstractRenderer other) {
        this.childRenderers = other.childRenderers;
        this.positionedRenderers = other.positionedRenderers;
        this.modelElement = other.modelElement;
        this.flushed = other.flushed;
        this.occupiedArea = other.occupiedArea.clone();
        this.parent = other.parent;
        this.properties.putAll(other.properties);
        this.isLastRendererForModelElement = other.isLastRendererForModelElement;
    }

    @Override
    public void addChild(IRenderer renderer) {
        this.childRenderers.add(renderer);
        renderer.setParent(this);
    }

    @Override
    public IPropertyContainer getModelElement() {
        return this.modelElement;
    }

    @Override
    public List<IRenderer> getChildRenderers() {
        return this.childRenderers;
    }

    @Override
    public boolean hasProperty(int property) {
        return this.hasOwnProperty(property) || this.modelElement != null && this.modelElement.hasProperty(property) || this.parent != null && Property.isPropertyInherited(property) && this.parent.hasProperty(property);
    }

    @Override
    public boolean hasOwnProperty(int property) {
        return this.properties.containsKey(property);
    }

    @Override
    public void deleteOwnProperty(int property) {
        this.properties.remove(property);
    }

    public void deleteProperty(int property) {
        if (this.properties.containsKey(property)) {
            this.properties.remove(property);
        } else if (this.modelElement != null) {
            this.modelElement.deleteOwnProperty(property);
        }
    }

    @Override
    public void setFloatProperty(int key, float value) {
        this.floatProperties.put(key, value);
    }

    @Override
    public boolean hasFloatProperty(int key) {
        return this.floatProperties.containsKey(key);
    }

    @Override
    public float getFloatProperty(int key) {
        if (this.floatProperties.containsKey(key)) {
            return this.floatProperties.get(key);
        }
        if (this.modelElement != null && this.modelElement.hasFloatProperty(key)) {
            return this.modelElement.getFloatProperty(key);
        }
        return this.modelElement != null ? this.modelElement.getDefaultFloatProperty(key) : this.getDefaultFloatProperty(key);
    }

    @Override
    public <T1> T1 getProperty(int key) {
        Object property = this.properties.get(key);
        if (property != null || this.properties.containsKey(key)) {
            return (T1)property;
        }
        if (this.modelElement != null && ((property = this.modelElement.getProperty(key)) != null || this.modelElement.hasProperty(key))) {
            return (T1)property;
        }
        if (this.parent != null && Property.isPropertyInherited(key) && (property = this.parent.getProperty(key)) != null) {
            return (T1)property;
        }
        property = this.getDefaultProperty(key);
        if (property != null) {
            return (T1)property;
        }
        return this.modelElement != null ? (T1)this.modelElement.getDefaultProperty(key) : null;
    }

    @Override
    public <T1> T1 getOwnProperty(int property) {
        return (T1)this.properties.get(property);
    }

    @Override
    public <T1> T1 getProperty(int property, T1 defaultValue) {
        T1 result = this.getProperty(property);
        return result != null ? result : defaultValue;
    }

    @Override
    public void setProperty(int property, Object value) {
        this.properties.put(property, value);
    }

    @Override
    public <T1> T1 getDefaultProperty(int property) {
        switch (property) {
            case 52: {
                return (T1)DefaultLayoutPosition;
            }
        }
        return null;
    }

    @Override
    public float getDefaultFloatProperty(int property) {
        return 0.0f;
    }

    @Override
    public void setPdfFont(PdfFont font) {
        this.font = font;
    }

    @Override
    public PdfFont getPdfFont() {
        if (this.font != null) {
            return this.font;
        }
        PdfFont result = null;
        if (this.modelElement != null && (result = this.modelElement.getPdfFont()) != null) {
            return result;
        }
        if (this.parent != null && (result = this.parent.getPdfFont()) != null) {
            return result;
        }
        return this.modelElement != null ? (PdfFont)this.modelElement.getDefaultProperty(20) : null;
    }

    public float getPropertyAsFloat(int property) {
        return this.getFloatProperty(property);
    }

    public Boolean getPropertyAsBoolean(int property) {
        return (Boolean)this.getProperty(property);
    }

    @Override
    public boolean isITALIC() {
        return this.italic || this.modelElement != null && this.modelElement.isITALIC();
    }

    @Override
    public boolean isBold() {
        return this.bold || this.modelElement != null && this.modelElement.isBold();
    }

    @Override
    public void setITALIC(boolean italic) {
        this.italic = italic;
    }

    @Override
    public void setBold(boolean bold) {
        this.bold = bold;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (IRenderer renderer : this.childRenderers) {
            sb.append(renderer.toString());
        }
        return sb.toString();
    }

    @Override
    public LayoutArea getOccupiedArea() {
        return this.occupiedArea;
    }

    @Override
    public void draw(DrawContext drawContext) {
        this.applyDestination(drawContext.getDocument());
        this.applyAction(drawContext.getDocument());
        this.drawBackground(drawContext);
        this.drawBorder(drawContext);
        this.drawChildren(drawContext);
        this.flushed = true;
    }

    public void drawBackground(DrawContext drawContext) {
        Background background = this.getBackground();
        if (background != null) {
            Rectangle backgroundArea;
            boolean isTagged;
            Rectangle bBox = this.getOccupiedAreaBBox();
            boolean bl = isTagged = drawContext.isTaggingEnabled() && this.getModelElement() instanceof IAccessibleElement;
            if (isTagged) {
                drawContext.getCanvas().openTag(new CanvasArtifact());
            }
            if ((backgroundArea = this.applyMargins(bBox, false)).getWidth() <= 0.0f || backgroundArea.getHeight() <= 0.0f) {
                Logger logger = LoggerFactory.getLogger(AbstractRenderer.class);
                logger.error(MessageFormat.format("The {0} rectangle has negative or zero sizes. It will not be displayed.", "background"));
                return;
            }
            drawContext.getCanvas().saveState().setFillColor(background.getColor()).rectangle(backgroundArea.getX() - background.getExtraLeft(), backgroundArea.getY() - background.getExtraBottom(), backgroundArea.getWidth() + background.getExtraLeft() + background.getExtraRight(), backgroundArea.getHeight() + background.getExtraTop() + background.getExtraBottom()).fill().restoreState();
            if (isTagged) {
                drawContext.getCanvas().closeTag();
            }
        }
    }

    public void drawChildren(DrawContext drawContext) {
        for (IRenderer child : this.childRenderers) {
            child.draw(drawContext);
        }
    }

    public void drawBorder(DrawContext drawContext) {
        Border[] borders = this.getBorders();
        boolean gotBorders = false;
        for (Border border : borders) {
            gotBorders = gotBorders || border != null;
        }
        if (gotBorders) {
            float topWidth = borders[0] != null ? borders[0].getWidth() : 0.0f;
            float rightWidth = borders[1] != null ? borders[1].getWidth() : 0.0f;
            float bottomWidth = borders[2] != null ? borders[2].getWidth() : 0.0f;
            float leftWidth = borders[3] != null ? borders[3].getWidth() : 0.0f;
            Rectangle bBox = this.getBorderAreaBBox();
            if (bBox.getWidth() <= 0.0f || bBox.getHeight() <= 0.0f) {
                Logger logger = LoggerFactory.getLogger(AbstractRenderer.class);
                logger.error(MessageFormat.format("The {0} rectangle has negative or zero sizes. It will not be displayed.", "border"));
                return;
            }
            float x1 = bBox.getX();
            float y1 = bBox.getY();
            float x2 = bBox.getX() + bBox.getWidth();
            float y2 = bBox.getY() + bBox.getHeight();
            boolean isTagged = drawContext.isTaggingEnabled() && this.getModelElement() instanceof IAccessibleElement;
            PdfCanvas canvas = drawContext.getCanvas();
            if (isTagged) {
                canvas.openTag(new CanvasArtifact());
            }
            if (borders[0] != null) {
                canvas.saveState();
                borders[0].draw(canvas, x1, y2, x2, y2, leftWidth, rightWidth);
                canvas.restoreState();
            }
            if (borders[1] != null) {
                canvas.saveState();
                borders[1].draw(canvas, x2, y2, x2, y1, topWidth, bottomWidth);
                canvas.restoreState();
            }
            if (borders[2] != null) {
                canvas.saveState();
                borders[2].draw(canvas, x2, y1, x1, y1, rightWidth, leftWidth);
                canvas.restoreState();
            }
            if (borders[3] != null) {
                canvas.saveState();
                borders[3].draw(canvas, x1, y1, x1, y2, bottomWidth, topWidth);
                canvas.restoreState();
            }
            if (isTagged) {
                canvas.closeTag();
            }
        }
    }

    @Override
    public boolean isFlushed() {
        return this.flushed;
    }

    @Override
    public IRenderer setParent(IRenderer parent) {
        this.parent = parent;
        return this;
    }

    @Override
    public void move(float dxRight, float dyUp) {
        this.occupiedArea.getBBox().moveRight(dxRight);
        this.occupiedArea.getBBox().moveUp(dyUp);
        for (IRenderer childRenderer : this.childRenderers) {
            childRenderer.move(dxRight, dyUp);
        }
    }

    public List<Rectangle> initElementAreas(LayoutArea area) {
        return Collections.singletonList(area.getBBox());
    }

    public Rectangle getOccupiedAreaBBox() {
        return this.occupiedArea.getBBox().clone();
    }

    public Rectangle getBorderAreaBBox() {
        Rectangle rect = this.getOccupiedAreaBBox();
        this.applyMargins(rect, false);
        this.applyBorderBox(rect, false);
        return rect;
    }

    public Rectangle getInnerAreaBBox() {
        Rectangle rect = this.getOccupiedAreaBBox();
        this.applyMargins(rect, false);
        this.applyBorderBox(rect, false);
        this.applyPaddings(rect, false);
        return rect;
    }

    protected float retrieveWidth(float parentBoxWid) {
        return this.getUnitWidth();
    }

    protected float retrieveHeight() {
        return this.getFloatProperty(27);
    }

    protected PropertiesMap getOwnProperties() {
        return this.properties;
    }

    protected void addAllProperties(PropertiesMap properties) {
        this.properties.putAll(properties);
    }

    protected float getFirstYLineRecursively() {
        if (this.childRenderers.size() == 0) {
            return 0.0f;
        }
        return ((AbstractRenderer)this.childRenderers.get(0)).getFirstYLineRecursively();
    }

    protected Rectangle applyMargins(Rectangle rect, boolean reverse) {
        if (this.isPositioned()) {
            return rect;
        }
        return rect.applyMargins(this.getPropertyAsFloat(46), this.getPropertyAsFloat(45), this.getPropertyAsFloat(43), this.getPropertyAsFloat(44), reverse);
    }

    protected Rectangle applyPaddings(Rectangle rect, boolean reverse) {
        return rect.applyMargins(this.getPropertyAsFloat(50), this.getPropertyAsFloat(49), this.getPropertyAsFloat(47), this.getPropertyAsFloat(48), reverse);
    }

    protected Rectangle applyBorderBox(Rectangle rect, boolean reverse) {
        return rect;
    }

    protected void applyAbsolutePositioningTranslation(boolean reverse) {
        float dyUp;
        float top = this.getPropertyAsFloat(73);
        float bottom = this.getPropertyAsFloat(14);
        float left = this.getPropertyAsFloat(34);
        float right = this.getPropertyAsFloat(54);
        int reverseMultiplier = reverse ? -1 : 1;
        float dxRight = left != 0.0f ? left * (float)reverseMultiplier : -right * (float)reverseMultiplier;
        float f = dyUp = top != 0.0f ? -top * (float)reverseMultiplier : bottom * (float)reverseMultiplier;
        if (dxRight != 0.0f || dyUp != 0.0f) {
            this.move(dxRight, dyUp);
        }
    }

    protected void applyDestination(PdfDocument document) {
    }

    protected void applyAction(PdfDocument document) {
    }

    protected boolean isNotFittingHeight(LayoutArea layoutArea) {
        Rectangle area = this.applyMargins(layoutArea.getBBox().clone(), false);
        area = this.applyPaddings(area, false);
        return !this.isPositioned() && this.occupiedArea.getBBox().getHeight() > area.getHeight();
    }

    protected boolean isPositioned() {
        return false;
    }

    protected boolean isFixedLayout() {
        return false;
    }

    protected void alignChildHorizontally(IRenderer childRenderer, float availableWidth) {
        HorizontalAlignment horizontalAlignment = childRenderer.getHorizontalAlignment();
        if (horizontalAlignment != null && horizontalAlignment != HorizontalAlignment.LEFT) {
            float freeSpace = availableWidth - childRenderer.getOccupiedArea().getBBox().getWidth();
            switch (horizontalAlignment) {
                case RIGHT: {
                    childRenderer.move(freeSpace, 0.0f);
                    break;
                }
                case CENTER: {
                    childRenderer.move(freeSpace / 2.0f, 0.0f);
                }
            }
        }
    }

    @Override
    public Border getAllBorder() {
        if (this.border != null) {
            return this.border;
        }
        Border result = null;
        if (this.modelElement != null && (result = this.modelElement.getAllBorder()) != null) {
            return result;
        }
        return null;
    }

    @Override
    public Border getDefaultBorder() {
        return null;
    }

    @Override
    public void setAllBorder(Border border) {
        this.border = border;
    }

    @Override
    public Border getTopBorder() {
        if (this.topBorder != null) {
            return this.topBorder;
        }
        Border result = null;
        if (this.modelElement != null && (result = this.modelElement.getTopBorder()) != null) {
            return result;
        }
        return null;
    }

    @Override
    public void setTopBorder(Border topBorder) {
        this.topBorder = topBorder;
    }

    @Override
    public Border getRightBorder() {
        if (this.rightBorder != null) {
            return this.rightBorder;
        }
        Border result = null;
        if (this.modelElement != null && (result = this.modelElement.getRightBorder()) != null) {
            return result;
        }
        return null;
    }

    @Override
    public void setRightBorder(Border rightBorder) {
        this.rightBorder = rightBorder;
    }

    @Override
    public Border getBottomBorder() {
        if (this.bottomBorder != null) {
            return this.bottomBorder;
        }
        Border result = null;
        if (this.modelElement != null && (result = this.modelElement.getBottomBorder()) != null) {
            return result;
        }
        return null;
    }

    @Override
    public void setBottomBorder(Border bottomBorder) {
        this.bottomBorder = bottomBorder;
    }

    @Override
    public Border getLeftBorder() {
        if (this.leftBorder != null) {
            return this.leftBorder;
        }
        Border result = null;
        if (this.modelElement != null && (result = this.modelElement.getLeftBorder()) != null) {
            return result;
        }
        return null;
    }

    @Override
    public void setLeftBorder(Border leftBorder) {
        this.leftBorder = leftBorder;
    }

    @Override
    public Background getBackground() {
        if (this.background != null) {
            return this.background;
        }
        Background result = null;
        if (this.modelElement != null && (result = this.modelElement.getBackground()) != null) {
            return result;
        }
        return null;
    }

    @Override
    public void setBackground(Background background) {
        this.background = background;
    }

    @Override
    public TextAlignment getTextAlignment() {
        if (this.alignment != null) {
            return this.alignment;
        }
        TextAlignment result = null;
        if (this.modelElement != null && (result = this.modelElement.getTextAlignment()) != null) {
            return result;
        }
        return null;
    }

    @Override
    public void setRenderTextAlignment(TextAlignment alignment) {
        this.alignment = alignment;
    }

    @Override
    public VerticalAlignment getVerticalAlignment() {
        if (this.verticalAlignment != null) {
            return this.verticalAlignment;
        }
        VerticalAlignment result = null;
        if (this.modelElement != null && (result = this.modelElement.getVerticalAlignment()) != null) {
            return result;
        }
        return null;
    }

    @Override
    public void setRenderVerticalAlignment(VerticalAlignment verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
    }

    @Override
    public float getUnitWidth() {
        float result;
        if (this.width != 0.0f) {
            return this.width;
        }
        if (this.modelElement != null && (result = this.modelElement.getUnitWidth()) != 0.0f) {
            return result;
        }
        return 0.0f;
    }

    @Override
    public void setUnitWidth(float width) {
        this.width = width;
    }

    @Override
    public void setRenderFontColor(Color fontColor) {
        this.fontColor = fontColor;
    }

    @Override
    public void setRenderStrokeColor(Color strokeColor) {
        this.strokeColor = strokeColor;
    }

    @Override
    public Color getFontColor() {
        if (this.fontColor != null) {
            return this.fontColor;
        }
        if (this.modelElement != null) {
            return this.modelElement.getFontColor();
        }
        return null;
    }

    @Override
    public Color getRenderStrokeColor() {
        if (this.strokeColor != null) {
            return this.strokeColor;
        }
        if (this.modelElement != null) {
            return this.modelElement.getRenderStrokeColor();
        }
        return null;
    }

    @Override
    public HorizontalAlignment getHorizontalAlignment() {
        if (this.horizontalAlignment != null) {
            return this.horizontalAlignment;
        }
        if (this.modelElement != null) {
            return this.modelElement.getHorizontalAlignment();
        }
        return null;
    }

    @Override
    public void setRenderHorizontalAlignment(HorizontalAlignment horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
    }

    @Override
    public Object getUnderLine() {
        if (this.underLine != null) {
            return this.underLine;
        }
        if (this.modelElement != null) {
            return this.modelElement.getUnderLine();
        }
        return null;
    }

    @Override
    public void setRenderUnderLine(Object underLine) {
        this.underLine = underLine;
    }

    @Override
    public BaseDirection getBaseDirection() {
        if (this.direction != null) {
            return this.direction;
        }
        if (this.modelElement != null) {
            return this.modelElement.getBaseDirection();
        }
        return BaseDirection.NO_BIDI;
    }

    @Override
    public BaseDirection getOwnBaseDirection() {
        return this.direction;
    }

    @Override
    public void setRenderBaseDirection(BaseDirection direction) {
        this.direction = direction;
    }

    @Override
    public float getFontSize() {
        if (this.font_size != 0.0f) {
            return this.font_size;
        }
        float res = 0.0f;
        if (this.modelElement != null && (res = this.modelElement.getFontSize()) != 0.0f) {
            return res;
        }
        return 12.0f;
    }

    @Override
    public void setRenderFontSize(float font_size) {
        this.font_size = font_size;
    }

    protected Border[] getBorders() {
        Border border = this.getAllBorder();
        Border topBorder = this.getTopBorder();
        Border rightBorder = this.getRightBorder();
        Border bottomBorder = this.getBottomBorder();
        Border leftBorder = this.getLeftBorder();
        Border[] borders = new Border[]{topBorder, rightBorder, bottomBorder, leftBorder};
        for (int i = 0; i < borders.length; ++i) {
            if (borders[i] != null) continue;
            borders[i] = border;
        }
        return borders;
    }

    protected AbstractRenderer setBorders(Border border, int borderNumber) {
        switch (borderNumber) {
            case 0: {
                this.setTopBorder(border);
                break;
            }
            case 1: {
                this.setRightBorder(border);
                break;
            }
            case 2: {
                this.setBottomBorder(border);
                break;
            }
            case 3: {
                this.setLeftBorder(border);
            }
        }
        return this;
    }
}

