/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.kernel.utils;

import com.fr.third.fr.pdf.io.util.IdelOutputStream;
import com.fr.third.fr.pdf.kernel.pdf.PdfArray;
import com.fr.third.fr.pdf.kernel.pdf.PdfDictionary;
import com.fr.third.fr.pdf.kernel.pdf.PdfIndirectReference;
import com.fr.third.fr.pdf.kernel.pdf.PdfName;
import com.fr.third.fr.pdf.kernel.pdf.PdfObject;
import com.fr.third.fr.pdf.kernel.pdf.PdfOutputStream;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdfResourceCounter {
    private Map<Integer, PdfObject> resources = new HashMap<Integer, PdfObject>();

    public PdfResourceCounter(PdfObject obj) {
        this.process(obj);
    }

    protected final void process(PdfObject obj) {
        PdfIndirectReference ref = obj.getIndirectReference();
        if (ref == null) {
            this.loopOver(obj);
        } else if (!this.resources.containsKey(ref.getObjNumber())) {
            this.resources.put(ref.getObjNumber(), obj);
            this.loopOver(obj);
        }
    }

    protected final void loopOver(PdfObject obj) {
        switch (obj.getType()) {
            case 1: {
                PdfArray array = (PdfArray)obj;
                for (int i = 0; i < array.size(); ++i) {
                    this.process(array.get(i));
                }
                break;
            }
            case 3: 
            case 9: {
                PdfDictionary dict = (PdfDictionary)obj;
                if (PdfName.Pages.equals(dict.get(PdfName.Type))) break;
                for (PdfName name : dict.keySet()) {
                    this.process(dict.get(name));
                }
                break;
            }
        }
    }

    public Map<Integer, PdfObject> getResources() {
        return this.resources;
    }

    public long getLength(Map<Integer, PdfObject> res) {
        long length = 0L;
        for (int ref : this.resources.keySet()) {
            if (res != null && res.containsKey(ref)) continue;
            PdfOutputStream os = new PdfOutputStream(new IdelOutputStream());
            os.write(this.resources.get(ref).clone());
            length += os.getCurrentPos() - 1L;
        }
        return length;
    }
}

