/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.kernel.pdf.layer;

import com.fr.third.fr.pdf.kernel.pdf.PdfArray;
import com.fr.third.fr.pdf.kernel.pdf.PdfDictionary;
import com.fr.third.fr.pdf.kernel.pdf.PdfDocument;
import com.fr.third.fr.pdf.kernel.pdf.PdfIndirectReference;
import com.fr.third.fr.pdf.kernel.pdf.PdfName;
import com.fr.third.fr.pdf.kernel.pdf.PdfObject;
import com.fr.third.fr.pdf.kernel.pdf.PdfObjectWrapper;
import com.fr.third.fr.pdf.kernel.pdf.layer.IPdfOCG;
import com.fr.third.fr.pdf.kernel.pdf.layer.PdfLayer;
import com.fr.third.fr.pdf.kernel.pdf.layer.PdfVisibilityExpression;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdfLayerMembership
extends PdfObjectWrapper<PdfDictionary>
implements IPdfOCG {
    private static final long serialVersionUID = -597407628148657784L;

    public PdfLayerMembership(PdfDocument doc) {
        super(new PdfDictionary());
        this.makeIndirect(doc);
        ((PdfDictionary)this.getPdfObject()).put(PdfName.Type, PdfName.OCMD);
    }

    public PdfLayerMembership(PdfDictionary membershipDictionary) {
        super(membershipDictionary);
        PdfLayerMembership.ensureObjectIsAddedToDocument(membershipDictionary);
        if (!PdfName.OCMD.equals(membershipDictionary.getAsName(PdfName.Type))) {
            throw new IllegalArgumentException("Invalid membershipDictionary.");
        }
    }

    public Collection<PdfLayer> getLayers() {
        final PdfObject layers = ((PdfDictionary)this.getPdfObject()).get(PdfName.OCGs);
        if (layers instanceof PdfDictionary) {
            return new ArrayList<PdfLayer>(){
                {
                    this.add(new PdfLayer(((PdfDictionary)layers).makeIndirect(PdfLayerMembership.this.getDocument())));
                }
            };
        }
        if (layers instanceof PdfArray) {
            ArrayList<PdfLayer> layerList = new ArrayList<PdfLayer>();
            for (int ind = 0; ind < ((PdfArray)layers).size(); ++ind) {
                layerList.add(new PdfLayer(((PdfArray)layers).makeIndirect(this.getDocument()).getAsDictionary(ind)));
            }
            return layerList;
        }
        return null;
    }

    public void addLayer(PdfLayer layer) {
        PdfArray layers = ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.OCGs);
        if (layers == null) {
            layers = new PdfArray();
            ((PdfDictionary)this.getPdfObject()).put(PdfName.OCGs, layers);
        }
        layers.add((PdfObject)layer.getPdfObject());
        layers.setModified();
    }

    public void setVisibilityPolicy(PdfName visibilityPolicy) {
        if (visibilityPolicy == null || !PdfName.AllOn.equals(visibilityPolicy) && !PdfName.AnyOn.equals(visibilityPolicy) && !PdfName.AnyOff.equals(visibilityPolicy) && !PdfName.AllOff.equals(visibilityPolicy)) {
            throw new IllegalArgumentException("Argument: visibilityPolicy");
        }
        ((PdfDictionary)this.getPdfObject()).put(PdfName.P, visibilityPolicy);
        ((PdfDictionary)this.getPdfObject()).setModified();
    }

    public PdfName getVisibilityPolicy() {
        PdfName visibilityPolicy = ((PdfDictionary)this.getPdfObject()).getAsName(PdfName.P);
        if (visibilityPolicy == null || !visibilityPolicy.equals(PdfName.AllOn) && !visibilityPolicy.equals(PdfName.AllOff) && !visibilityPolicy.equals(PdfName.AnyOn) && !visibilityPolicy.equals(PdfName.AnyOff)) {
            return PdfName.AnyOn;
        }
        return visibilityPolicy;
    }

    public void setVisibilityExpression(PdfVisibilityExpression visibilityExpression) {
        ((PdfDictionary)this.getPdfObject()).put(PdfName.VE, (PdfObject)visibilityExpression.getPdfObject());
        ((PdfDictionary)this.getPdfObject()).setModified();
    }

    public PdfVisibilityExpression getVisibilityExpression() {
        PdfArray ve = ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.VE);
        return ve != null ? new PdfVisibilityExpression(ve) : null;
    }

    @Override
    public PdfIndirectReference getIndirectReference() {
        ((PdfDictionary)this.getPdfObject()).makeIndirect(this.getDocument());
        return ((PdfDictionary)this.getPdfObject()).getIndirectReference();
    }

    @Override
    protected boolean isWrappedObjectMustBeIndirect() {
        return true;
    }

    protected PdfDocument getDocument() {
        return ((PdfDictionary)this.getPdfObject()).getIndirectReference().getDocument();
    }
}

