/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.kernel.pdf.canvas.parser.listener;

import com.fr.third.fr.pdf.kernel.geom.LineSegment;
import com.fr.third.fr.pdf.kernel.geom.Vector;
import com.fr.third.fr.pdf.kernel.pdf.canvas.parser.EventType;
import com.fr.third.fr.pdf.kernel.pdf.canvas.parser.data.IEventData;
import com.fr.third.fr.pdf.kernel.pdf.canvas.parser.data.TextRenderInfo;
import com.fr.third.fr.pdf.kernel.pdf.canvas.parser.listener.ITextExtractionStrategy;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleTextExtractionStrategy
implements ITextExtractionStrategy {
    private Vector lastStart;
    private Vector lastEnd;
    private final StringBuilder result = new StringBuilder();

    @Override
    public void eventOccurred(IEventData data, EventType type) {
        if (type.equals((Object)EventType.RENDER_TEXT)) {
            float spacing;
            float sameLineThreshold;
            Vector x1;
            Vector x2;
            float dist;
            TextRenderInfo renderInfo = (TextRenderInfo)data;
            boolean firstRender = this.result.length() == 0;
            boolean hardReturn = false;
            LineSegment segment = renderInfo.getBaseline();
            Vector start = segment.getStartPoint();
            Vector end = segment.getEndPoint();
            if (!firstRender && (dist = (x2 = this.lastEnd).subtract(x1 = this.lastStart).cross(x1.subtract(start)).lengthSquared() / x2.subtract(x1).lengthSquared()) > (sameLineThreshold = 1.0f)) {
                hardReturn = true;
            }
            if (hardReturn) {
                this.appendTextChunk("\n");
            } else if (!firstRender && this.result.charAt(this.result.length() - 1) != ' ' && renderInfo.getText().length() > 0 && renderInfo.getText().charAt(0) != ' ' && (spacing = this.lastEnd.subtract(start).length()) > renderInfo.getSingleSpaceWidth() / 2.0f) {
                this.appendTextChunk(" ");
            }
            this.appendTextChunk(renderInfo.getText());
            this.lastStart = start;
            this.lastEnd = end;
        }
    }

    @Override
    public Set<EventType> getSupportedEvents() {
        return Collections.unmodifiableSet(new LinkedHashSet<EventType>(Collections.singletonList(EventType.RENDER_TEXT)));
    }

    @Override
    public String getResultantText() {
        return this.result.toString();
    }

    protected final void appendTextChunk(CharSequence text) {
        this.result.append(text);
    }
}

