/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.kernel.pdf.canvas.parser;

import com.fr.third.fr.pdf.kernel.geom.AffineTransform;
import com.fr.third.fr.pdf.kernel.geom.BezierCurve;
import com.fr.third.fr.pdf.kernel.geom.IShape;
import com.fr.third.fr.pdf.kernel.geom.Line;
import com.fr.third.fr.pdf.kernel.geom.Matrix;
import com.fr.third.fr.pdf.kernel.geom.NoninvertibleTransformException;
import com.fr.third.fr.pdf.kernel.geom.Path;
import com.fr.third.fr.pdf.kernel.geom.Point;
import com.fr.third.fr.pdf.kernel.geom.Subpath;
import com.fr.third.fr.pdf.kernel.pdf.canvas.CanvasGraphicsState;
import com.fr.third.fr.pdf.kernel.pdf.canvas.parser.clipper.ClipperBridge;
import com.fr.third.fr.pdf.kernel.pdf.canvas.parser.clipper.DefaultClipper;
import com.fr.third.fr.pdf.kernel.pdf.canvas.parser.clipper.IClipper;
import com.fr.third.fr.pdf.kernel.pdf.canvas.parser.clipper.PolyTree;
import java.util.Arrays;
import java.util.List;

public class ParserGraphicsState
extends CanvasGraphicsState {
    private Path clippingPath;

    ParserGraphicsState() {
    }

    ParserGraphicsState(ParserGraphicsState source) {
        super(source);
        if (source.clippingPath != null) {
            this.clippingPath = new Path(source.clippingPath);
        }
    }

    public void setClippingPath(Path clippingPath) {
        Path pathCopy = new Path(clippingPath);
        pathCopy.closeAllSubpaths();
        this.clippingPath = pathCopy;
    }

    public void updateCtm(Matrix newCtm) {
        super.updateCtm(newCtm);
        if (this.clippingPath != null) {
            this.transformClippingPath(newCtm);
        }
    }

    public void clip(Path path, int fillingRule) {
        if (this.clippingPath == null || this.clippingPath.isEmpty()) {
            return;
        }
        Path pathCopy = new Path(path);
        pathCopy.closeAllSubpaths();
        DefaultClipper clipper = new DefaultClipper();
        ClipperBridge.addPath(clipper, this.clippingPath, IClipper.PolyType.SUBJECT);
        ClipperBridge.addPath(clipper, pathCopy, IClipper.PolyType.CLIP);
        PolyTree resultTree = new PolyTree();
        clipper.execute(IClipper.ClipType.INTERSECTION, resultTree, IClipper.PolyFillType.NON_ZERO, ClipperBridge.getFillType(fillingRule));
        this.clippingPath = ClipperBridge.convertToPath(resultTree);
    }

    public Path getClippingPath() {
        return this.clippingPath;
    }

    private void transformClippingPath(Matrix newCtm) {
        Path path = new Path();
        for (Subpath subpath : this.clippingPath.getSubpaths()) {
            Subpath transformedSubpath = this.transformSubpath(subpath, newCtm);
            path.addSubpath(transformedSubpath);
        }
        this.clippingPath = path;
    }

    private Subpath transformSubpath(Subpath subpath, Matrix newCtm) {
        Subpath newSubpath = new Subpath();
        newSubpath.setClosed(subpath.isClosed());
        for (IShape segment : subpath.getSegments()) {
            IShape transformedSegment = this.transformSegment(segment, newCtm);
            newSubpath.addSegment(transformedSegment);
        }
        return newSubpath;
    }

    private IShape transformSegment(IShape segment, Matrix newCtm) {
        List<Point> segBasePts = segment.getBasePoints();
        Point[] transformedPoints = this.transformPoints(newCtm, segBasePts.toArray(new Point[segBasePts.size()]));
        IShape newSegment = segment instanceof BezierCurve ? new BezierCurve(Arrays.asList(transformedPoints)) : new Line(transformedPoints[0], transformedPoints[1]);
        return newSegment;
    }

    private Point[] transformPoints(Matrix transformationMatrix, Point ... points) {
        try {
            AffineTransform t = new AffineTransform(transformationMatrix.get(0), transformationMatrix.get(1), transformationMatrix.get(3), transformationMatrix.get(4), transformationMatrix.get(6), transformationMatrix.get(7));
            t = t.createInverse();
            Point[] transformed = new Point[points.length];
            t.transform(points, 0, transformed, 0, points.length);
            return transformed;
        }
        catch (NoninvertibleTransformException e) {
            throw new RuntimeException(e);
        }
    }
}

