/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.io.font.otf;

import com.fr.third.fr.pdf.io.font.otf.ContextualSubstRule;
import com.fr.third.fr.pdf.io.font.otf.Glyph;
import com.fr.third.fr.pdf.io.font.otf.GlyphLine;
import com.fr.third.fr.pdf.io.font.otf.OpenTableLookup;
import com.fr.third.fr.pdf.io.font.otf.OpenTypeFontTableReader;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ContextualSubTable {
    protected OpenTypeFontTableReader openReader;
    protected int lookupFlag;

    protected ContextualSubTable(OpenTypeFontTableReader openReader, int lookupFlag) {
        this.openReader = openReader;
        this.lookupFlag = lookupFlag;
    }

    public ContextualSubstRule getMatchingContextRule(GlyphLine line) {
        if (line.idx >= line.end) {
            return null;
        }
        Glyph g = line.get(line.idx);
        List<ContextualSubstRule> rules = this.getSetOfRulesForStartGlyph(g.getCode());
        for (ContextualSubstRule rule : rules) {
            int lastGlyphIndex = this.checkIfContextMatch(line, rule);
            if (lastGlyphIndex == -1) continue;
            line.start = line.idx;
            line.end = lastGlyphIndex + 1;
            return rule;
        }
        return null;
    }

    protected abstract List<ContextualSubstRule> getSetOfRulesForStartGlyph(int var1);

    protected int checkIfContextMatch(GlyphLine line, ContextualSubstRule rule) {
        boolean isMatch;
        int j;
        OpenTableLookup.GlyphIndexer gidx = new OpenTableLookup.GlyphIndexer();
        gidx.line = line;
        gidx.idx = line.idx;
        for (j = 1; j < rule.getContextLength(); ++j) {
            gidx.nextGlyph(this.openReader, this.lookupFlag);
            if (gidx.glyph == null || !rule.isGlyphMatchesInput(gidx.glyph.getCode(), j)) break;
        }
        boolean bl = isMatch = j == rule.getContextLength();
        if (isMatch) {
            return gidx.idx;
        }
        return -1;
    }
}

