/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.agent.test;

import cn.com.infosec.netsign.agent.NetSignAgent;
import cn.com.infosec.netsign.agent.NetSignResult;
import cn.com.infosec.netsign.logger.ConsoleLogger;
import java.io.FileInputStream;
import java.security.cert.X509Certificate;
import java.util.PropertyResourceBundle;

public class TestSM2SignAndVerify {
    public static void main(String[] args) throws Exception {
        TestSM2SignAndVerify.init();
        TestSM2SignAndVerify.test2();
    }

    private static void init() {
        try {
            FileInputStream in = new FileInputStream("D:\\WORK\\myjava\\infosec\\netsign\\PBC2_COM_NetSign\\netsignagent.properties");
            PropertyResourceBundle prb = new PropertyResourceBundle(in);
            NetSignAgent.initialize(prb);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void test2() throws Exception {
        String signed = null;
        int i = 0;
        while (i < 10000) {
            try {
                NetSignResult result = NetSignAgent.attachedSignature("11111111".getBytes(), "O=infosec,CN=perf_sm2test1", null, false);
                signed = result.getStringResult("Base64_Signed_Text");
                result = NetSignAgent.attachedVerify(signed, null, true);
            }
            catch (Exception e) {
                System.out.println(signed);
            }
            if ((i + 1) % 100 == 0) {
                System.out.println(i + 1);
            }
            ++i;
        }
    }

    private static void test1() throws Exception {
        NetSignResult result = NetSignAgent.CMSAttachedSignature("11111111".getBytes(), "CN=testsm2_1,O=infosec", null, false);
        byte[] signed = result.getByteArrayResult("Base64_Signed_Text");
        ConsoleLogger.logBinary((String)"signed text", (byte[])signed);
        result = NetSignAgent.attachedVerify(signed, null, true);
        System.out.println("ISSUER:" + result.getStringResult("Sign_Issuer_Subject"));
        System.out.println("SN:" + result.getStringResult("Sign_Ser_Number"));
        System.out.println("DN:" + result.getStringResult("Sign_Subject"));
        System.out.println("NotBefore:" + result.getStringResult("Sign_Start_Time"));
        System.out.println("NotAfter:" + result.getStringResult("Sign_End_Time"));
        System.out.println("Plain Text:" + new String(result.getByteArrayResult("Byte_Array_Plain_Text")));
        X509Certificate signcert = result.getSignCert();
    }
}

