/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.agent.test;

import cn.com.infosec.netsign.agent.NetSignAgent;
import cn.com.infosec.netsign.agent.NetSignAgentUtil;
import cn.com.infosec.netsign.agent.NetSignResult;
import java.io.FileInputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.PropertyResourceBundle;

public class Test {
    static X509Certificate cert;

    public static void main(String[] args) {
        Test.init();
        Test.testWeekAlg();
    }

    public static void init() {
        try {
            FileInputStream in = new FileInputStream("D:\\WORK\\myjava\\infosec\\netsign\\PBC2_COM_NetSign\\netsignagent.properties");
            PropertyResourceBundle prb = new PropertyResourceBundle(in);
            NetSignAgent.initialize(prb);
            FileInputStream certin = new FileInputStream("D:\\WORK\\myjava\\infosec\\certs\\cert\\enccert\\5year.cer");
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            cert = (X509Certificate)cf.generateCertificate(certin);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void testWeekAlg() {
        try {
            NetSignResult result = null;
            result = NetSignAgent.makeEnvelope(cert, "RC2", "11111111".getBytes());
            String enced = result.getStringResult("Base64_Enveloped_Text");
            NetSignAgent.decryptEnvelope(enced, "C=cn,O=syn080924,CN=5year");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void testGetCert() {
        String signed = "MIIEKAYJKoZIhvcNAQcCoIIEGTCCBBUCAQExCzAJBgUrDgMCGgUAMBIGCSqGSIb3DQEHAaAFBAMxMjOgggMHMIIDAzCCAeugAwIBAgIES5IBODANBgkqhkiG9w0BAQUFADA2MQswCQYDVQQGEwJjbjESMBAGA1UEChMJc3luMDgwOTI0MRMwEQYDVQQDEwpyb290MDgwOTI0MB4XDTA4MTEwNzA4NDMyMVoXDTE3MTEwNzA4NDMyMVowMTEOMAwGA1UEAwwFNXllYXIxEjAQBgNVBAoMCXN5bjA4MDkyNDELMAkGA1UEBhMCY24wgZ8wDQYJKoZIhvcNAQEBBQADgY0AMIGJAoGBAPFcLIYgYbuz18NEMcn7hopBOcUWQt0mmfjyWWJPCr5C5UltMfyXO2yPJb1EnAbfCDe72vQpl++DpvJwMlPCwnkoQGYs/SEtZYyYiiIhGOh5YRTCN0HJJlkwBkp2HE6EXTcdbUCA+ppwDsqsv+VUr63fKF45U+qOtempmT/u/uX1AgMBAAGjgaEwgZ4wEQYJYIZIAYb4QgEBBAQDAgWgMAkGA1UdEwQCMAAwUgYDVR0fBEswSTBHoEWgQ6RBMD8xDjAMBgNVBAMMBWNybDE2MQwwCgYDVQQLDANjcmwxEjAQBgNVBAoMCXN5bjA4MDkyNDELMAkGA1UEBhMCY24wCwYDVR0PBAQDAgbAMB0GA1UdJQQWMBQGCCsGAQUFBwMCBggrBgEFBQcDBDANBgkqhkiG9w0BAQUFAAOCAQEAnSkwt7bs/8GvdmGSmX8N6D+t8fO33OJVDtynhZr03kySffhwCLd221lDf4lauLyeut8wigqWmPEBGtQ8xRn+RqlTnDpRFBlAqD6TbeKjdrZ5ZvTH2fEXes7duZTAHu7I7yPqoc9wMK2il3sai30NntusE1aUDy92V4qM1BQSB1PDYGMJ8Hz1N2OU7uMKSP0KiOs6jwzbKxp3jjqPgFfR8W05UVnzISp6XbqRFCArf0a8ErvQGy41eom0bN/2itQBqe4GyvhFnFkzQ9L8Lru+atzzfFTKCO90WwOFZICvJMAZakrqgQrvMdCLUcB7glVN4TfyLYoOt1s0bGNLSk6F+zGB4zCB4AIBATA+MDYxCzAJBgNVBAYTAmNuMRIwEAYDVQQKEwlzeW4wODA5MjQxEzARBgNVBAMTCnJvb3QwODA5MjQCBEuSATgwCQYFKw4DAhoFADANBgkqhkiG9w0BAQEFAASBgI7VWe+evh414d/LgSwvfgMZW+pYWvHMtNt3Bu6mQOt0dWuVW/MLJz3pX159C32Ibs1gdZbNejJyJxdthVHJHX/f7y+jCwcqJdbF5NLHPwc50bbeRddNjhzgnlGBtEKqAvu2GwRpfnL0K20BFUmJzbkOjbdvt/h4knJ6QAh5qlGe";
        X509Certificate cert = NetSignAgentUtil.getCertificateFromP7(signed);
        System.out.println(cert.getSubjectDN().toString());
    }
}

