/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.agent.test;

import cn.com.infosec.netsign.agent.NetSignAgent;
import cn.com.infosec.netsign.agent.NetSignResult;
import cn.com.infosec.netsign.base.PDFParameters;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.security.cert.X509Certificate;
import java.util.PropertyResourceBundle;

public class EncryptPDFTest {
    public static void main(String[] args) {
        EncryptPDFTest.init();
        EncryptPDFTest.testEncryptPDF();
    }

    public static void init() {
        try {
            FileInputStream in = new FileInputStream("netsignagent.properties");
            PropertyResourceBundle prb = new PropertyResourceBundle(in);
            NetSignAgent.initialize(prb);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void testEncryptPDF() {
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            try {
                in = new FileInputStream("E:/temp/Test_Position/pdf2TestUse.pdf");
                byte[] bs = new byte[in.available()];
                in.read(bs);
                PDFParameters para = new PDFParameters();
                para.setPdf(bs);
                para.setOwnerPassword("11111111".getBytes());
                X509Certificate cert = null;
                try {
                    FileInputStream inCert = new FileInputStream("E:/certs/cert_5year/5year.cer");
                    byte[] bsCert = new byte[inCert.available()];
                    inCert.read(bsCert);
                    cert = NetSignAgent.generateCertificate(bsCert);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                NetSignResult result = NetSignAgent.pdfEncrypt(cert, para);
                bs = result.getByteArrayResult("Pdf_Encrypt_Text");
                out = new FileOutputStream("E:/temp/Test_Position/pdfEncrypt_test.pdf");
                out.write(bs);
                out.flush();
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exception) {}
        }
    }
}

