/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.agent.communication;

import cn.com.infosec.netsign.agent.communication.APIToServer;
import cn.com.infosec.netsign.base.AbstractMessage;
import cn.com.infosec.netsign.communication.Communicator;
import cn.com.infosec.netsign.communication.multiple.MultiCommunicator;
import cn.com.infosec.netsign.logger.ConsoleLogger;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;

public class ConnectionPool {
    private static ConnectionPool instance = null;
    private int maxConnections = 50;
    private int usedConnections = 0;
    private int timeout = 0;
    private int connectTimeout = 0;
    private String host = null;
    private int port = 0;
    private List commList = null;
    private Object syncObj = new Object();

    static {
        Runtime.getRuntime().addShutdownHook(new ShutdownThread());
    }

    public int size() {
        return this.commList == null ? 0 : this.commList.size();
    }

    public static synchronized ConnectionPool getInstance() {
        if (instance == null) {
            instance = new ConnectionPool();
        }
        return instance;
    }

    private ConnectionPool() {
        this.host = APIToServer.getHost();
        this.port = APIToServer.getPort();
        this.timeout = APIToServer.getTimeout();
        this.maxConnections = APIToServer.getMaxConnectons();
        this.commList = new ArrayList(this.maxConnections);
        this.connectTimeout = APIToServer.getConnectTimeout();
    }

    private void clear() {
        this.commList.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void freeConnection(Communicator comm) {
        Object object = this.syncObj;
        synchronized (object) {
            this.commList.add(comm);
            --this.usedConnections;
            try {
                this.syncObj.notifyAll();
            }
            catch (IllegalMonitorStateException e) {
                ConsoleLogger.logException((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeConnection(PoolCommunicator comm) {
        Object object = this.syncObj;
        synchronized (object) {
            --this.usedConnections;
            try {
                this.syncObj.notifyAll();
            }
            catch (IllegalMonitorStateException e) {
                ConsoleLogger.logException((Throwable)e);
            }
        }
    }

    public PoolCommunicator newConnection() throws IOException {
        try {
            return new PoolCommunicator();
        }
        catch (Exception e) {
            e.printStackTrace();
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e instanceof NullPointerException) {
                throw new IOException("Create Socket Failed");
            }
            throw new IOException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PoolCommunicator getConnection() throws InterruptedException, IOException {
        PoolCommunicator comm = null;
        Object object = this.syncObj;
        synchronized (object) {
            while (this.maxConnections > 0 && this.usedConnections >= this.maxConnections) {
                this.syncObj.wait();
            }
            comm = this.commList.size() > 0 ? (PoolCommunicator)this.commList.remove(0) : this.newConnection();
            ++this.usedConnections;
        }
        return comm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getAllConnections() throws InterruptedException, IOException {
        ArrayList list = new ArrayList();
        Object object = this.syncObj;
        synchronized (object) {
            if (this.commList.size() != 0) {
                int i = 0;
                int size = this.commList.size();
                while (i < size) {
                    list.add(this.commList.remove(0));
                    ++i;
                }
                this.usedConnections += list.size();
            }
        }
        return list;
    }

    public class PoolCommunicator
    implements Communicator {
        private boolean closed = false;
        private Communicator comm = null;

        private PoolCommunicator() throws IOException {
            InetSocketAddress isa = new InetSocketAddress(ConnectionPool.this.host, ConnectionPool.this.port);
            Socket socket = new Socket();
            socket.connect(isa, ConnectionPool.this.connectTimeout);
            socket.setSoTimeout(ConnectionPool.this.timeout);
            socket.setTcpNoDelay(true);
            socket.setSoLinger(true, 0);
            this.comm = new MultiCommunicator(socket);
        }

        public void close() {
            if (!this.closed) {
                ConnectionPool.this.freeConnection(this);
            }
        }

        public boolean isClosed() {
            return this.comm.isClosed();
        }

        public void realyClose() {
            try {
                if (this.comm != null) {
                    this.comm.close();
                }
                ConnectionPool.this.closeConnection(this);
                this.closed = true;
            }
            catch (Throwable t) {
                ConsoleLogger.logException((Throwable)t);
            }
        }

        public void send(AbstractMessage msg) throws IOException {
            this.comm.send(msg);
        }

        public AbstractMessage recv() throws IOException, ClassNotFoundException {
            AbstractMessage msg = this.comm.recv();
            return msg;
        }
    }

    private static class ShutdownThread
    extends Thread {
        private ShutdownThread() {
        }

        public void run() {
            if (instance != null) {
                instance.clear();
            }
        }
    }
}

